/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import translator.Debug;
import translator.ResourceLocator;
import translator.Translator;

public class ExtendedResourceBundle {
    public static final String ASCII_FORMAT = "ascii";
    public static final String PROPERTY_FORMAT = "properties";
    private Translator translator = null;
    PropertyResourceBundle bundle = null;

    public ExtendedResourceBundle(String filename) {
        this(filename, PROPERTY_FORMAT);
    }

    public ExtendedResourceBundle(String filename, String formatName) {
        try {
            InputStream in = ResourceLocator.getResourceLocator().getResourceStream(filename);
            if (formatName == PROPERTY_FORMAT) {
                this.bundle = new PropertyResourceBundle(new BufferedInputStream(in));
            }
        }
        catch (IOException ioException) {
            if (this.translator != null) {
                Debug.printlnMessage(this.getTranslator().translateMessage("verboseException", new Object[]{"(String) [constructor]", this.getClass().getName(), ioException.getMessage(), "(no information available)", ioException.getClass().getName()}));
            } else {
                System.err.println("Sorry, but there was a problem in accessing the resource " + filename);
            }
        }
        catch (IllegalArgumentException illArg) {
            System.err.println(illArg.getMessage());
        }
    }

    public String[] getKeys() {
        Vector<String> v = new Vector<String>(128);
        Enumeration<String> e = this.bundle.getKeys();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        String[] result = new String[v.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)v.elementAt(i);
            ++i;
        }
        return result;
    }

    public String getMessage(String key) {
        return this.getMessage(key, true);
    }

    public String getMessage(String key, boolean warnOnError) {
        block3: {
            try {
                if (this.bundle != null) {
                    return this.bundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (this.bundle == null || !warnOnError || "noSuchKeyException".equalsIgnoreCase(key)) break block3;
                Debug.printlnMessage(this.getTranslator().translateMessage("noSuchKeyException", new Object[]{key}));
            }
        }
        return null;
    }

    public Translator getTranslator() {
        if (this.translator == null) {
            this.translator = new Translator("en", Locale.US);
        }
        return this.translator;
    }

    public void printProperties() {
        this.printProperties(System.out);
    }

    public void printProperties(PrintStream outputStream) {
        if (this.bundle == null) {
            return;
        }
        String[] keys = this.getKeys();
        String key = null;
        if (keys != null) {
            int nrKeys = keys.length;
            int i = 0;
            while (i < nrKeys) {
                key = keys[i];
                outputStream.println("key: '" + key + "' entry: '" + this.bundle.getObject(key) + "'");
                ++i;
            }
        }
    }

    public void setTranslator(Translator trans) {
        this.translator = trans == null ? new Translator() : trans;
    }
}

