/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

import animal.misc.XProperties;

public class AnimatedArray {
    private StringBuilder localBuffer = null;
    private String arrayName = "array";
    private XProperties props = new XProperties();
    private static int arrayCode = 0;
    private boolean inStep = false;
    private int nrComparisons = 0;
    private int nrAssignments = 0;

    public AnimatedArray(char[] arrayData) {
        this("array" + arrayCode++, AnimatedArray.convertToStringArray(arrayData));
    }

    public AnimatedArray(double[] arrayData) {
        this("array" + arrayCode++, AnimatedArray.convertToStringArray(arrayData));
    }

    public AnimatedArray(int[] arrayData) {
        this("array" + arrayCode++, AnimatedArray.convertToStringArray(arrayData));
    }

    public AnimatedArray(String[] arrayData) {
        this("array" + arrayCode++, arrayData);
    }

    public AnimatedArray(Object[] arrayData) {
        this("array" + arrayCode++, AnimatedArray.convertToStringArray(arrayData));
    }

    public AnimatedArray(String label, char[] arrayData) {
        this(label, AnimatedArray.convertToStringArray(arrayData), new StringBuilder(Short.MAX_VALUE));
    }

    public AnimatedArray(String label, double[] arrayData) {
        this(label, AnimatedArray.convertToStringArray(arrayData), new StringBuilder(Short.MAX_VALUE));
    }

    public AnimatedArray(String label, int[] arrayData) {
        this(label, AnimatedArray.convertToStringArray(arrayData), new StringBuilder(Short.MAX_VALUE));
    }

    public AnimatedArray(String label, String[] arrayData) {
        this(label, arrayData, new StringBuilder(Short.MAX_VALUE));
    }

    public AnimatedArray(String label, Object[] arrayData) {
        this(label, AnimatedArray.convertToStringArray(arrayData), new StringBuilder(Short.MAX_VALUE));
    }

    public AnimatedArray(String label, char[] arrayData, StringBuilder targetBuffer) {
        this.setArrayName(label);
        this.setArray(AnimatedArray.convertToStringArray(arrayData));
        this.setLocalBuffer(targetBuffer);
    }

    public AnimatedArray(String label, double[] arrayData, StringBuilder targetBuffer) {
        this.setArrayName(label);
        this.setArray(AnimatedArray.convertToStringArray(arrayData));
        this.setLocalBuffer(targetBuffer);
    }

    public AnimatedArray(String label, int[] arrayData, StringBuilder targetBuffer) {
        this.setArrayName(label);
        this.setArray(AnimatedArray.convertToStringArray(arrayData));
        this.setLocalBuffer(targetBuffer);
    }

    public AnimatedArray(String label, String[] arrayData, StringBuilder targetBuffer) {
        this.setArrayName(label);
        this.setArray(arrayData);
        this.setLocalBuffer(targetBuffer);
    }

    public AnimatedArray(String label, Object[] arrayData, StringBuilder targetBuffer) {
        this.setArrayName(label);
        this.setArray(AnimatedArray.convertToStringArray(arrayData));
        this.setLocalBuffer(targetBuffer);
    }

    public int getNrComparisons() {
        return this.nrComparisons;
    }

    public void incrementAssignments() {
        this.incrementAssignments(1);
    }

    public void incrementAssignments(int howMuch) {
        this.nrAssignments += howMuch;
    }

    public void incrementComparisons() {
        this.incrementComparisons(1);
    }

    public void incrementComparisons(int howMuch) {
        this.nrComparisons += howMuch;
    }

    public int getNrAssignments() {
        return this.nrAssignments;
    }

    public void setLocalBuffer(StringBuilder targetBuffer) {
        this.localBuffer = targetBuffer;
    }

    public static String[] convertToStringArray(char[] arrayValues) {
        if (arrayValues == null || arrayValues.length == 0) {
            return new String[0];
        }
        int length = arrayValues.length;
        String[] targetArray = new String[length];
        int pos = 0;
        while (pos < length) {
            targetArray[pos] = String.valueOf(arrayValues);
            ++pos;
        }
        return targetArray;
    }

    public static String[] convertToStringArray(double[] arrayValues) {
        if (arrayValues == null || arrayValues.length == 0) {
            return new String[0];
        }
        int length = arrayValues.length;
        String[] targetArray = new String[length];
        int pos = 0;
        while (pos < length) {
            targetArray[pos] = String.valueOf(arrayValues);
            ++pos;
        }
        return targetArray;
    }

    public static String[] convertToStringArray(int[] arrayValues) {
        if (arrayValues == null || arrayValues.length == 0) {
            return new String[0];
        }
        int length = arrayValues.length;
        String[] targetArray = new String[length];
        int pos = 0;
        while (pos < length) {
            targetArray[pos] = String.valueOf(arrayValues[pos]);
            ++pos;
        }
        return targetArray;
    }

    public static String[] convertToStringArray(String[] arrayValues) {
        return arrayValues;
    }

    public static String[] convertToStringArray(Object[] arrayValues) {
        if (arrayValues == null || arrayValues.length == 0) {
            return new String[0];
        }
        int length = arrayValues.length;
        String[] targetArray = new String[length];
        int pos = 0;
        while (pos < length) {
            if (arrayValues[pos] != null) {
                targetArray[pos] = arrayValues[pos].toString();
            }
            ++pos;
        }
        return targetArray;
    }

    public void setArray(String[] arrayValues) {
        if (arrayValues == null || arrayValues.length == 0) {
            return;
        }
        int i = 0;
        while (i < arrayValues.length) {
            this.props.put(String.valueOf(this.getArrayName()) + "." + i, arrayValues[i]);
            ++i;
        }
        this.installBasicArray(arrayValues.length);
    }

    public void installSourceCode(String[] codeLines, int[] indentations) {
        if (codeLines == null || codeLines.length == 0) {
            return;
        }
        String codeGroupName = String.valueOf(this.getArrayName()) + " code";
        this.startStep();
        this.localBuffer.append("  codegroup \"").append(codeGroupName);
        this.localBuffer.append("\" at (20, 140) color black highlightColor red");
        this.localBuffer.append("contextColor blue2 font SansSerif size 11");
        int i = 0;
        while (i < codeLines.length) {
            this.localBuffer.append("\n  addCodeLine \"").append(codeLines[i]);
            this.localBuffer.append("\" to \"").append(codeGroupName);
            this.localBuffer.append("\" indentation ").append(indentations[i]);
            this.props.put(String.valueOf(this.getArrayName()) + ".codeline_" + i, codeLines[i]);
            ++i;
        }
        this.endStep();
    }

    public void startStep() {
        if (this.inStep) {
            this.endStep();
        }
        this.localBuffer.append("{\n");
        this.inStep = true;
    }

    public void endStep() {
        if (this.inStep) {
            this.localBuffer.append("}\n");
        }
        this.inStep = false;
    }

    public void highlightCode(int line, boolean highlightOn, boolean contextMode) {
        this.localBuffer.append("  ");
        if (!highlightOn) {
            this.localBuffer.append("un");
        }
        this.localBuffer.append("highlightCode on \"").append(String.valueOf(this.getArrayName()) + " code");
        this.localBuffer.append("\" line ").append(line);
        if (contextMode) {
            this.localBuffer.append(" context");
        }
        this.localBuffer.append("\n");
    }

    public void installBasicArray(int length) {
        this.props.put(String.valueOf(this.getArrayName()) + ".name", this.getArrayName());
        this.props.put(String.valueOf(this.getArrayName()) + ".length", length);
        if (this.localBuffer == null) {
            this.setLocalBuffer(new StringBuilder(Short.MAX_VALUE));
        }
        this.localBuffer.append("  array \"").append(this.getArrayName()).append("\" (20, 80)");
        this.localBuffer.append(" color black fillColor white elementColor black ");
        this.localBuffer.append("elementHighlight blue cellHighlight gray length ");
        this.localBuffer.append(length).append(" ");
        int i = 0;
        while (i < length) {
            this.localBuffer.append(this.props.getProperty(String.valueOf(this.getArrayName()) + "." + i)).append(' ');
            ++i;
        }
        this.localBuffer.append("\n");
    }

    public String getArrayName() {
        if (this.arrayName == null) {
            this.arrayName = "array" + arrayCode;
            ++arrayCode;
        }
        return this.arrayName;
    }

    public void setArrayName(String name) {
        this.arrayName = name;
    }

    public StringBuilder getLocalBuffer() {
        if (this.localBuffer == null) {
            this.localBuffer = new StringBuilder(32768);
        }
        return this.localBuffer;
    }

    public void swap(int firstIndex, int secondIndex) {
        this.swappingCode(firstIndex, secondIndex);
    }

    private void swappingCode(int firstIndex, int secondIndex) {
        this.localBuffer.append("  arraySwap on \"").append(this.getArrayName());
        this.localBuffer.append("\" position ").append(firstIndex).append(" with ");
        this.localBuffer.append(secondIndex).append(" within 10 ticks\n");
        String currentElement = this.props.getProperty(String.valueOf(this.getArrayName()) + "." + firstIndex);
        this.props.put((Object)(String.valueOf(this.getArrayName()) + "." + firstIndex), this.props.get(String.valueOf(this.getArrayName()) + "." + secondIndex));
        this.props.put(String.valueOf(this.getArrayName()) + "." + secondIndex, currentElement);
        this.incrementAssignments(3);
    }

    public void installArrayIndex(int targetPosition, String label, String title) {
        if (targetPosition >= 0 && targetPosition < this.props.getIntProperty(String.valueOf(this.getArrayName()) + ".length", -1)) {
            this.createIndexCode(targetPosition, label, title);
        }
    }

    public void createIndexCode(int targetPosition, String label, String title) {
        this.localBuffer.append("  arrayIndex \"").append(label).append("\" on \"");
        this.localBuffer.append(this.getArrayName()).append("\" atIndex ").append(targetPosition);
        if (title != null) {
            this.localBuffer.append(" label \"").append(title).append("\"");
        }
        this.localBuffer.append(" color ").append("red").append("\n");
        this.props.put(String.valueOf(this.getArrayName()) + ".index_" + label, targetPosition);
        this.props.put(String.valueOf(this.getArrayName()) + ".label_" + label, label);
        this.props.put(String.valueOf(this.getArrayName()) + ".label_" + title, title);
        this.incrementAssignments();
    }

    public void moveArrayIndex(String label, int targetPosition) {
        this.localBuffer.append("  moveMarker \"").append(label).append("\" to position ");
        this.localBuffer.append(targetPosition).append(" within 5 ticks\n");
        this.props.put(String.valueOf(this.getArrayName()) + ".index_" + label, targetPosition);
        this.incrementAssignments();
    }

    public void putElement(char newVal, int position) {
        this.putElement(String.valueOf(newVal), position);
    }

    public void putElement(int newVal, int position) {
        this.putElement(String.valueOf(newVal), position);
    }

    public void putElement(double newVal, int position) {
        this.putElement(String.valueOf(newVal), position);
    }

    public void putElement(String newVal, int position) {
        int length = this.props.getIntProperty(String.valueOf(this.getArrayName()) + ".length", -1);
        if (position < 0 || position >= length) {
            return;
        }
        this.createPutCode(newVal, position);
    }

    public void putElement(Object newVal, int position) {
        this.putElement(newVal.toString(), position);
    }

    public String[] getCurrentArrayState() {
        String name = this.getArrayName();
        int arrayLength = this.props.getIntProperty(String.valueOf(name) + ".length", 0);
        if (arrayLength > 0) {
            String[] arrayVals = new String[arrayLength];
            int i = 0;
            while (i < arrayLength) {
                arrayVals[i] = this.props.getProperty(String.valueOf(name) + "." + i);
                ++i;
            }
            return arrayVals;
        }
        return null;
    }

    public void printArray(String[] array) {
        if (array != null) {
            int length = array.length;
            if (length > 0) {
                int i = 0;
                while (i < length) {
                    System.out.print("  " + array[i]);
                    ++i;
                }
            }
            System.out.print("\n");
        }
    }

    public void createPutCode(String code, int position) {
        this.localBuffer.append("  arrayPut \"").append(code).append("\" on \"");
        this.localBuffer.append(this.getArrayName()).append("\" position ").append(position).append("\n");
        this.props.put(String.valueOf(this.getArrayName()) + "." + position, code);
        this.incrementAssignments();
    }
}

