/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.fileHandler.FileHandler;
import algorithm.stringSearch.BruteForceStringSearch;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BruteForceStringSearchWrapper
implements Generator {
    private static final String DESCRIPTION = "In dieser naiven Variante der Suche einer Suchmaske in einem Text wird iterativ jede Position des Textes als Start der Suchmaske ausprobiert. Falls das aktuelle Textzeichen dabei nicht zur aktuellen Position der Suchmaske passt, wird die gesamte Suchmaske um ein Zeichen verschoben und ab dem ersten Zeichen der Suchmaske erneut gesucht. Dies kann also auch ein R\u00fcckspringen im Text bedeuten, was das Verfahren f\u00fcr Suchen in Datein oder externen Daten ungeeignet  macht.\nDie Komplexit\u00e4tsklasse des Verfahrens ist O(m*n), wobei m die L\u00e4nge der Suchmaske und n die L\u00e4nge des Suchtextes ist.";
    private static final String SOURCE_CODE = "fehlt noch";
    private GeneratorType myType = new GeneratorType(2);

    @Override
    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "Brute-Force Suche in Strings";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String fullText = (String)primitives.get("text");
        String toSearch = (String)primitives.get("searchFor");
        FileHandler handler = new FileHandler("demo.asu");
        AnimalTranslator animalTrans = new AnimalTranslator(handler);
        BruteForceStringSearch bruteForceSearch = new BruteForceStringSearch(animalTrans);
        bruteForceSearch.initialize(fullText, toSearch);
        try {
            bruteForceSearch.generateAnimation();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return handler.getAnimationCode();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

