/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.generators;

import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Chart;
import de.ahrgr.animal.kohnert.asugen.CodeGroup;
import de.ahrgr.animal.kohnert.asugen.Generator;
import de.ahrgr.animal.kohnert.asugen.Node;
import de.ahrgr.animal.kohnert.asugen.PolyLine;
import de.ahrgr.animal.kohnert.asugen.Text;
import de.ahrgr.animal.kohnert.asugen.TextBox;
import de.ahrgr.animal.kohnert.asugen.property.Property;
import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VigenereDecode2
implements Generator {
    private Hashtable<String, Object> propertyMapper = null;

    public VigenereDecode2(Hashtable<String, Object> dataSet) {
        this.propertyMapper = dataSet;
    }

    private de.ahrgr.animal.kohnert.asugen.Color decodeColor(String key) {
        Color readColor = (Color)this.propertyMapper.get(key);
        return new de.ahrgr.animal.kohnert.asugen.Color(readColor);
    }

    private de.ahrgr.animal.kohnert.asugen.Font decodeFont(String key) {
        Font readFont = (Font)this.propertyMapper.get(key);
        return new de.ahrgr.animal.kohnert.asugen.Font(readFont);
    }

    public void generate(Writer out) {
        PrintWriter o = null;
        o = new PrintWriter(out);
        AnimalScriptWriter w = new AnimalScriptWriter(o);
        this.generateDecode(w);
    }

    public void generateDecode(AnimalScriptWriter w) {
        TextBox b2;
        w.clear();
        String data = ((String)this.propertyMapper.get("stringToDecode")).toUpperCase();
        String key = ((String)this.propertyMapper.get("key")).toUpperCase();
        String zeichensatz = (String)this.propertyMapper.get("charSet");
        w.startBlock();
        w.addLabel("Description");
        String title = (String)this.propertyMapper.get("title");
        Text tx = w.createText(w.abs(10, 40), title);
        tx.setColor(this.decodeColor("titleColor"));
        tx.setFont(this.decodeFont("titleFont"));
        w.createRectangle(tx.createOffset(0, 5, 6), tx.createOffset(5, 6, 8));
        CodeGroup g = w.createCodeGroup(tx.createOffset(0, 12, 6));
        g.setFont(this.decodeFont("codeFont"));
        g.setColor(this.decodeColor("codeColor"));
        String decodingLabel = (String)this.propertyMapper.get("decodeLabel");
        g.addCodeLine(String.valueOf(decodingLabel) + data);
        String keyLabel = (String)this.propertyMapper.get("keyLabel");
        g.addCodeLine(String.valueOf(keyLabel) + key);
        g.addCodeLine("");
        Chart chart = new Chart(w, w.abs(10, 360), data.length(), 2);
        chart.setCharsHorizontaly(0, 0, data);
        chart.register();
        w.endBlock();
        w.addLabel("Assign Key Chars");
        String repeatedCopyLabel = (String)this.propertyMapper.get("repeatedCopyLabel");
        g.addCodeLine(repeatedCopyLabel);
        int width = data.length();
        int pos = 0;
        while (pos < width) {
            w.startBlock();
            chart.setCharsHorizontaly(pos, 1, key);
            pos += key.length();
            w.endBlock();
        }
        w.addLabel("Create Chart");
        String tableCreateLabel = (String)this.propertyMapper.get("tableCreateLabel");
        g.addCodeLine(tableCreateLabel);
        w.startBlock();
        Chart tabelle = new Chart(w, chart.createOffset(50, 200, 7), zeichensatz.length(), key.length() + 1);
        tabelle.setCharsHorizontaly(0, 0, zeichensatz);
        de.ahrgr.animal.kohnert.asugen.Color clRow = this.decodeColor("tableRowColor");
        de.ahrgr.animal.kohnert.asugen.Color clCol = this.decodeColor("tableColumnColor");
        de.ahrgr.animal.kohnert.asugen.Color clRest = this.decodeColor("tableFillColor");
        tabelle.setFillColorRect(0, 0, zeichensatz.length(), 1, clRow);
        tabelle.setFillColorRect(0, 1, 1, key.length(), clCol);
        tabelle.setFillColorRect(1, 1, zeichensatz.length() - 1, key.length(), clRest);
        tabelle.register();
        tabelle.setCharsVerticaly(0, 1, key);
        int i = 0;
        while (i < key.length()) {
            w.startBlock();
            char keyChar = key.charAt(i);
            int keyCharPos = zeichensatz.indexOf("" + keyChar);
            String s = zeichensatz.substring(keyCharPos + 1);
            s = String.valueOf(s) + zeichensatz.substring(0, keyCharPos);
            tabelle.setCharsHorizontaly(1, i + 1, s);
            ++i;
        }
        w.endBlock();
        String searchRowLabel = (String)this.propertyMapper.get("searchRow");
        g.addCodeLine(searchRowLabel);
        w.addLabel("begin decryption");
        AnimalObject p = null;
        AnimalObject p2 = null;
        TextBox lastChar = null;
        boolean firstChar = true;
        int steps = (Integer)this.propertyMapper.get("numberSteps");
        if (steps == 0) {
            steps = 1000;
        }
        i = 0;
        while (i < data.length() && i < steps) {
            w.startBlock();
            w.addLabel("decrypt '" + data.charAt(i) + "'");
            if (p != null) {
                p.setHidden(true);
            }
            if (p2 != null) {
                p2.setHidden(true);
            }
            p = new PolyLine(w);
            Node n = chart.getElementAt(i, 0).createOffset(0, 0, 1);
            ((PolyLine)p).addNode(n);
            ((PolyLine)p).addNode(n.createOffset(0, -10));
            n = chart.createOffset(10, -10, 2);
            ((PolyLine)p).addNode(n);
            n = chart.createOffset(10, 10, 8);
            ((PolyLine)p).addNode(n);
            int x = (zeichensatz.length() + zeichensatz.indexOf(data.charAt(i)) - zeichensatz.indexOf(key.charAt(i % key.length()))) % zeichensatz.length();
            n = tabelle.getElementAt(x, 0).createOffset(0, -30, 1);
            ((PolyLine)p).addNode(n);
            ((PolyLine)p).addNode(n.createOffset(0, 30));
            ((PolyLine)p).setArrow(1);
            ((PolyLine)p).register();
            p2 = new PolyLine(w);
            n = chart.getElementAt(i, 1).createOffset(0, 1, 7);
            ((PolyLine)p2).addNode(n);
            ((PolyLine)p2).addNode(n.createOffset(0, 10));
            n = tabelle.createOffset(-50, -50, 0);
            ((PolyLine)p2).addNode(n);
            int y = i % key.length() + 1;
            n = tabelle.getElementAt(0, y).createOffset(-50, 0, 3);
            ((PolyLine)p2).addNode(n);
            ((PolyLine)p2).addNode(n.createOffset(50, 0));
            ((PolyLine)p2).setArrow(1);
            ((PolyLine)p2).register();
            TextBox b = tabelle.getElementAt(x, 0);
            b2 = new TextBox(w, b.getPosition(), b.getText().getValue());
            TextBox b3 = tabelle.getElementAt(x, y);
            b3.getRectangle().setFillColor(de.ahrgr.animal.kohnert.asugen.Color.ORANGE);
            b2.register();
            b2.getRectangle().setFillColor(this.decodeColor("resultColor"));
            n = lastChar == null ? tabelle.createOffset(-30, 30, 6) : lastChar.createOffset(5, 0, 2);
            w.endBlock();
            b2.moveTo(n);
            w.startBlock();
            de.ahrgr.animal.kohnert.asugen.Color bkcolor = this.decodeColor("backgroundColor");
            if (x == 0) {
                bkcolor = this.decodeColor("backgroundColFirstRow");
            }
            b3.getRectangle().setFillColor(bkcolor);
            lastChar = b2;
            if (firstChar) {
                firstChar = false;
                String repeatLabel = (String)this.propertyMapper.get("codePosLabel");
                g.addCodeLine(repeatLabel);
            }
            ++i;
        }
        w.startBlock();
        p.setHidden(true);
        p2.setHidden(true);
        while (i < data.length()) {
            int x = (zeichensatz.length() + zeichensatz.indexOf(data.charAt(i)) - zeichensatz.indexOf(key.charAt(i % key.length()))) % zeichensatz.length();
            int y = 0;
            TextBox srcTB = tabelle.getElementAt(x, y);
            Node n = lastChar.getRectangle().createOffset(5, 0, 8);
            b2 = new TextBox(w, n, srcTB.getText().getValue());
            b2.register();
            b2.getRectangle().setFillColor(this.decodeColor("resultColor"));
            lastChar = b2;
            ++i;
        }
        w.endBlock();
    }

    @Override
    public String getGeneratorName() {
        return "Vigenere Decryption";
    }

    @Override
    public Property[] getProperties() {
        return null;
    }

    @Override
    public void generateScript(Writer out) {
        this.generate(out);
    }
}

