/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.generatorgui;

import de.ahrgr.animal.kohnert.asugen.EmbeddedPropertiesFilter;
import de.ahrgr.animal.kohnert.asugen.Generator;
import de.ahrgr.animal.kohnert.asugen.GeneratorFactory;
import de.ahrgr.animal.kohnert.asugen.PropertyParser;
import de.ahrgr.animal.kohnert.asugen.property.ColorProperty;
import de.ahrgr.animal.kohnert.asugen.property.FontProperty;
import de.ahrgr.animal.kohnert.asugen.property.FormatedTextProperty;
import de.ahrgr.animal.kohnert.asugen.property.Property;
import de.ahrgr.animal.kohnert.asugen.property.TextProperty;
import de.ahrgr.animal.kohnert.generatorgui.AnimalLink;
import de.ahrgr.animal.kohnert.generatorgui.ColorPropertyEdit;
import de.ahrgr.animal.kohnert.generatorgui.FontPropertyEdit;
import de.ahrgr.animal.kohnert.generatorgui.FormatedTextPropertyEdit;
import de.ahrgr.animal.kohnert.generatorgui.GeneratorSelectionDialog;
import de.ahrgr.animal.kohnert.generatorgui.PropertyEdit;
import de.ahrgr.animal.kohnert.generatorgui.PropertyTreeNode;
import de.ahrgr.animal.kohnert.generatorgui.TextPropertyEdit;
import de.ahrgr.animal.kohnert.generators.VigenereEncode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;

public class GeneratorGUI
extends JFrame
implements ActionListener,
ListSelectionListener,
TreeSelectionListener,
GeneratorFactory {
    private static final long serialVersionUID = 4637276464167824445L;
    static GeneratorGUI instance = null;
    public static final String[] generatorNames = new String[]{"Vigenere Encryption", "Vigenere Decryption"};
    public static final String[] generatorClasses = new String[]{"de.ahrgr.animal.kohnert.generators.VigenereEncode", "de.ahrgr.animal.kohnert.generators.VigenereDecode"};
    protected JPanel buttonpane;
    protected JButton btGenerate;
    protected JButton btExit;
    protected JList propertyList;
    protected JScrollPane propListSP;
    protected JLabel lbAnimationType;
    protected JPanel propertyPane;
    protected JButton btDefaultValue;
    protected JPanel dummyPane;
    protected JTextArea lbPropertyDescription;
    protected JSplitPane splitPane;
    protected PropertyEdit currentPropertyEdit = null;
    protected JMenuBar menuBar;
    protected JFileChooser fileChooser;
    protected JTree propertyTree;
    protected PropertyTreeNode propertyRootNode;
    protected File currentFile = null;
    protected Generator generator;
    Property[] properties;
    protected TextPropertyEdit textEdit = null;
    protected ColorPropertyEdit colorEdit = null;
    protected FormatedTextPropertyEdit formatedTextEdit = null;
    protected FontPropertyEdit fontEdit = null;
    protected AnimalLink animalLink = null;

    public GeneratorGUI() {
        this.setTitle("Animal Generator");
        Container p = this.getContentPane();
        this.buttonpane = new JPanel();
        JButton aBtGenerate = new JButton("Save Animation");
        aBtGenerate.setActionCommand("save");
        aBtGenerate.addActionListener(this);
        JButton aBtExit = new JButton("Exit");
        aBtExit.setActionCommand("exit");
        aBtExit.addActionListener(this);
        this.buttonpane.add(aBtGenerate);
        this.buttonpane.add(aBtExit);
        this.lbAnimationType = new JLabel("Vigenere Animation");
        p.add((Component)this.lbAnimationType, "North");
        p.add((Component)this.buttonpane, "South");
        this.propertyTree = new JTree();
        this.propertyTree.getSelectionModel().setSelectionMode(1);
        this.propertyTree.addTreeSelectionListener(this);
        this.propListSP = new JScrollPane(this.propertyTree, 22, 30);
        this.propertyPane = new JPanel();
        this.splitPane = new JSplitPane(1, this.propListSP, this.propertyPane);
        this.splitPane.setDividerLocation(200);
        p.add((Component)this.splitPane, "Center");
        this.propertyPane.setLayout(new BorderLayout());
        this.btDefaultValue = new JButton("set to default value");
        this.btDefaultValue.setActionCommand("defaultvalue");
        this.btDefaultValue.addActionListener(this);
        this.propertyPane.add((Component)this.btDefaultValue, "South");
        this.dummyPane = new JPanel();
        this.lbPropertyDescription = new JTextArea("no property selected");
        this.lbPropertyDescription.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.lbPropertyDescription.setEditable(false);
        this.lbPropertyDescription.setLineWrap(true);
        this.propertyPane.add((Component)new JScrollPane(this.lbPropertyDescription), "North");
        this.propertyPane.setBorder(new TitledBorder("no property"));
        this.propertyPane.setPreferredSize(new Dimension(400, 500));
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem m = fileMenu.add("New");
        m.setMnemonic(78);
        m.setActionCommand("new");
        m.addActionListener(this);
        m = fileMenu.add("Load...");
        m.setMnemonic(76);
        m.setActionCommand("load");
        m.addActionListener(this);
        m = fileMenu.add("Save");
        m.setMnemonic(83);
        m.setActionCommand("save");
        m.addActionListener(this);
        m = fileMenu.add("Save as...");
        m.setMnemonic(65);
        m.setActionCommand("saveas");
        m.addActionListener(this);
        fileMenu.addSeparator();
        m = fileMenu.add("Exit");
        m.setMnemonic(69);
        m.setActionCommand("exit");
        m.addActionListener(this);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        m = helpMenu.add("Animal website");
        m.setMnemonic(87);
        m.setActionCommand("www");
        m.addActionListener(this);
        helpMenu.addSeparator();
        m = helpMenu.add("About AnimalGenerator...");
        m.setMnemonic(65);
        m.setActionCommand("about");
        m.addActionListener(this);
        this.menuBar.add(fileMenu);
        this.menuBar.add(helpMenu);
        this.setJMenuBar(this.menuBar);
        this.textEdit = new TextPropertyEdit();
        this.colorEdit = new ColorPropertyEdit();
        this.formatedTextEdit = new FormatedTextPropertyEdit();
        this.fontEdit = new FontPropertyEdit();
        this.pack();
        this.setSize(600, 500);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new ASUFileFilter());
    }

    public void setPropertyDescription(String s) {
    }

    public void setGenerator(Generator g) {
        this.properties = g.getProperties();
        int s = this.properties.length;
        String[] keys = new String[s];
        int i = 0;
        while (i < s) {
            keys[i] = this.properties[i].getKey();
            ++i;
        }
        this.generator = g;
        this.propertyRootNode = new PropertyTreeNode(null, g.getGeneratorName());
        i = 0;
        while (i < s) {
            this.propertyRootNode.addProperty(this.properties[i], keys[i]);
            ++i;
        }
        this.propertyTree.setModel(new DefaultTreeModel(this.propertyRootNode));
        if (this.currentPropertyEdit != null) {
            this.propertyPane.remove(this.currentPropertyEdit);
        }
        this.propertyPane.setBorder(new TitledBorder("No property selected"));
        this.lbPropertyDescription.setText("no property selected");
        this.propertyPane.validate();
    }

    public static void main(String[] args) {
        instance = new GeneratorGUI();
        instance.setVisible(true);
        instance.setGenerator(new VigenereEncode());
    }

    public void newGenerator() {
        GeneratorSelectionDialog d = new GeneratorSelectionDialog(generatorNames);
        int r = d.showModal();
        if (r < 0) {
            return;
        }
        Generator g = this.getGenerator(generatorClasses[r]);
        this.setGenerator(g);
    }

    public Generator getGenerator(String className) {
        try {
            Class<?> c = Class.forName(className);
            Generator g = (Generator)c.newInstance();
            return g;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(this, "Sorry. Did not find generator class \"" + className + "\"");
            e.printStackTrace();
        }
        return null;
    }

    public void writeProperty() {
        if (this.currentPropertyEdit != null) {
            this.currentPropertyEdit.writeProperty();
        }
    }

    public void loadFile(File f) {
        PropertyParser p = new PropertyParser();
        try {
            Reader r = new FileReader(f);
            r = new EmbeddedPropertiesFilter(r);
            Generator g = p.parse(r, this);
            if (g != null) {
                this.setGenerator(g);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.writeProperty();
        if (this.generator == null) {
            JOptionPane.showMessageDialog(this, "Please select a generator first");
            return;
        }
        if (this.animalLink == null) {
            this.animalLink = new AnimalLink();
        }
        JOptionPane.showMessageDialog(this, "Sorry. This feature is disabled in this version.");
    }

    public void exit() {
    }

    public void actionPerformed(ActionEvent arg0) {
        int r;
        if ("exit".equals(arg0.getActionCommand())) {
            System.exit(0);
        }
        if ("save".equals(arg0.getActionCommand()) || "saveas".equals(arg0.getActionCommand())) {
            if (this.generator == null) {
                return;
            }
            this.writeProperty();
            boolean dialog = "saveas".equals(arg0.getActionCommand());
            if (this.currentFile == null) {
                dialog = true;
            }
            boolean generate = false;
            if (dialog) {
                int r2 = this.fileChooser.showSaveDialog(this);
                if (r2 == 0) {
                    generate = true;
                    this.currentFile = this.fileChooser.getSelectedFile();
                }
            } else {
                generate = true;
            }
            if (generate) {
                try {
                    FileWriter w = new FileWriter(this.currentFile);
                    this.generator.generateScript(w);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "IO error while generating Script:\n\n" + e, "IO Error", 0);
                }
            }
        }
        if ("new".equals(arg0.getActionCommand())) {
            this.newGenerator();
        }
        if ("load".equals(arg0.getActionCommand()) && (r = this.fileChooser.showOpenDialog(this)) == 0) {
            this.loadFile(this.fileChooser.getSelectedFile());
        }
        if ("run".equals(arg0.getActionCommand())) {
            this.run();
        }
        if ("defaultvalue".equals(arg0.getActionCommand()) && this.currentPropertyEdit != null) {
            this.currentPropertyEdit.setToDefaultValue();
        }
        if ("about".equals(arg0.getActionCommand())) {
            JOptionPane.showMessageDialog(this, "AnimalGenerator 1.0\n\nadd author information here", "About AnimalGenerator", 1);
        }
        if ("www".equals(arg0.getActionCommand())) {
            JOptionPane.showMessageDialog(this, "More information about Animal at\n\nhttp://www.animal.ahrgr.de/", "Animal WWW", 1);
        }
    }

    public void setEditProperty(Property p) {
        if (this.currentPropertyEdit != null) {
            this.currentPropertyEdit.writeProperty();
            this.propertyPane.remove(this.currentPropertyEdit);
        }
        this.propertyPane.setVisible(false);
        this.currentPropertyEdit = null;
        if (p instanceof TextProperty) {
            this.currentPropertyEdit = this.textEdit;
            this.textEdit.setProperty((TextProperty)p);
        }
        if (p instanceof ColorProperty) {
            this.currentPropertyEdit = this.colorEdit;
            this.colorEdit.setProperty((ColorProperty)p);
        }
        if (p instanceof FormatedTextProperty) {
            this.currentPropertyEdit = this.formatedTextEdit;
            this.formatedTextEdit.setProperty((FormatedTextProperty)p);
        }
        if (p instanceof FontProperty) {
            this.currentPropertyEdit = this.fontEdit;
            this.fontEdit.setProperty((FontProperty)p);
        }
        if (this.currentPropertyEdit != null) {
            this.propertyPane.add((Component)this.currentPropertyEdit, "Center");
        }
        this.propertyPane.setBorder(new TitledBorder(p.getKey()));
        this.lbPropertyDescription.setText(p.getDescription());
        this.propertyPane.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getValueIsAdjusting()) {
            return;
        }
        int i = this.propertyList.getSelectedIndex();
        if (i >= 0) {
            Property p = this.properties[i];
            this.setEditProperty(p);
        }
    }

    public void valueChanged(TreeSelectionEvent arg0) {
        PropertyTreeNode node = (PropertyTreeNode)this.propertyTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.property != null) {
            this.setEditProperty(node.property);
        }
    }

    public static class ASUFileFilter
    extends FileFilter {
        public boolean accept(File arg0) {
            return arg0.isDirectory() || arg0.getName().endsWith(".asu");
        }

        public String getDescription() {
            return "Animal Script - Generator file";
        }
    }
}

