/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.ackermann.guicomponents;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ColorChooserComboBox
extends JComboBox
implements ActionListener {
    private static final long serialVersionUID = -984850815478582378L;
    private static final String[] strAnimalNames = new String[]{"black", "dark Gray", "gray", "light Gray", "white", "red", "pink", "orange", "yellow", "green", "cyan", "blue", "magenta", "blue4", "blue3", "blue2", "light_blue", "green4", "green3", "green2", "cyan4", "cyan3", "cyan2", "red4", "red3", "red2", "magenta4", "magenta3", "magenta2", "brown4", "brown3", "brown2", "pink4", "pink3", "pink2", "pink", "gold", "more"};
    private static final Color[] colorValues = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.white, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta, new Color(0, 0, 144), new Color(0, 0, 176), new Color(0, 0, 208), new Color(135, 206, 255), new Color(0, 144, 0), new Color(0, 176, 0), new Color(0, 208, 0), new Color(0, 144, 144), new Color(0, 176, 176), new Color(0, 208, 208), new Color(144, 0, 0), new Color(176, 0, 0), new Color(208, 0, 0), new Color(144, 0, 144), new Color(176, 0, 176), new Color(208, 0, 208), new Color(128, 48, 0), new Color(160, 64, 0), new Color(192, 96, 0), new Color(255, 128, 128), new Color(255, 160, 160), new Color(255, 192, 192), new Color(255, 224, 224), new Color(255, 215, 0)};
    private Color colorSelected = Color.BLACK;
    private ComboBoxRenderer renderer = new ComboBoxRenderer();
    private String strSelected = "black";
    private Object[][] values = new Object[strAnimalNames.length][2];
    private boolean bChangeByComponent = false;

    public ColorChooserComboBox() {
        this.init();
    }

    public ColorChooserComboBox(Color colorNew) {
        this.init();
        this.setColorSelected(colorNew);
    }

    public ColorChooserComboBox(String strNewColor) {
        this.init();
        this.setColorSelected(strNewColor);
    }

    public void setColorSelected(Color colorNew) {
        if (colorNew == null) {
            return;
        }
        this.colorSelected = colorNew;
        int i = 0;
        while (i < colorValues.length) {
            if (colorValues[i].equals(colorNew)) {
                this.strSelected = strAnimalNames[i];
                this.bChangeByComponent = true;
                this.setSelectedIndex(i);
                this.bChangeByComponent = false;
                this.repaint();
                return;
            }
            ++i;
        }
        this.strSelected = this.getStringForColorRGB(colorNew);
        int iLastIndex = strAnimalNames.length - 1;
        if (!(this.getItemAt(iLastIndex) instanceof Object[])) {
            return;
        }
        Object[] lastitem = (Object[])this.getItemAt(iLastIndex);
        if (!(lastitem[0] instanceof ColoredSquare)) {
            return;
        }
        ColoredSquare csq = (ColoredSquare)lastitem[0];
        csq.changeColor(colorNew);
        this.bChangeByComponent = true;
        this.setSelectedIndex(iLastIndex);
        this.bChangeByComponent = false;
        this.repaint();
    }

    public void setColorSelected(String strNewColor) {
        if (strNewColor == null) {
            return;
        }
        if ((strNewColor = strNewColor.trim()).matches("\\x28((\\d{1,3})(,\\s)){2}(\\d{1,3})\\x29")) {
            int r = 1000;
            int g = 1000;
            int b = 1000;
            int fc = strNewColor.indexOf(", ");
            int sc = strNewColor.indexOf(", ", fc + 2);
            if (fc < 1 || sc < 1) {
                return;
            }
            try {
                r = Integer.parseInt(strNewColor.substring(1, fc));
                g = Integer.parseInt(strNewColor.substring(fc + 2, sc));
                b = Integer.parseInt(strNewColor.substring(sc + 2, strNewColor.length() - 1));
            }
            catch (NumberFormatException e) {
                return;
            }
            if (r > 255 || g > 255 || b > 255) {
                return;
            }
            Color colorNew = new Color(r, g, b);
            this.setColorSelected(colorNew);
        } else {
            int i = 0;
            while (i < strAnimalNames.length - 1) {
                if (strAnimalNames[i].equals(strNewColor)) {
                    this.strSelected = strNewColor;
                    this.colorSelected = colorValues[i];
                    this.bChangeByComponent = true;
                    this.setSelectedIndex(i);
                    this.bChangeByComponent = false;
                    this.repaint();
                    return;
                }
                ++i;
            }
        }
    }

    public Color getColorSelected() {
        return this.colorSelected;
    }

    public String getColorSelectedAsString() {
        return this.strSelected;
    }

    public String getStringForColor(Color colorObject) {
        int i = 0;
        while (i < colorValues.length) {
            if (colorValues[i].equals(colorObject)) {
                return strAnimalNames[i];
            }
            ++i;
        }
        return this.getStringForColorRGB(colorObject);
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (this.bChangeByComponent) {
            return;
        }
        int index = this.getSelectedIndex();
        if (index != strAnimalNames.length - 1) {
            this.colorSelected = colorValues[index];
            this.strSelected = strAnimalNames[index];
        } else {
            Color colorNew = JColorChooser.showDialog(this, "Choose a Color", this.colorSelected);
            if (colorNew == null) {
                return;
            }
            this.setColorSelected(colorNew);
        }
    }

    private String getStringForColorRGB(Color colorObject) {
        StringBuilder buf = new StringBuilder(15);
        buf.append("(");
        buf.append(Integer.toString(colorObject.getRed()));
        buf.append(", ");
        buf.append(Integer.toString(colorObject.getGreen()));
        buf.append(", ");
        buf.append(Integer.toString(colorObject.getBlue()));
        buf.append(")");
        return buf.toString();
    }

    private void init() {
        int i = 0;
        while (i < colorValues.length) {
            this.values[i][0] = new ColoredSquare(colorValues[i]);
            this.values[i][1] = strAnimalNames[i];
            this.addItem(this.values[i]);
            ++i;
        }
        this.values[i][0] = new ColoredSquare();
        this.values[i][1] = "More Colors...";
        this.addItem(this.values[i]);
        this.setRenderer(this.renderer);
        this.addActionListener(this);
        this.colorSelected = colorValues[0];
    }

    private class ColoredSquare
    implements Icon {
        private Color color;
        private boolean special = false;

        public ColoredSquare(Color c) {
            if (c == null) {
                return;
            }
            this.color = c;
            this.special = false;
        }

        public ColoredSquare() {
            this.color = Color.WHITE;
            this.special = true;
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconHeight() {
            return 12;
        }

        public int getIconWidth() {
            return 14;
        }

        public void changeColor(Color c) {
            if (c == null) {
                return;
            }
            this.color = c;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c == null || g == null) {
                return;
            }
            Color oldColor = g.getColor();
            if (!this.special) {
                g.setColor(this.color);
                g.fill3DRect(x + 2, y, this.getIconWidth() - 2, this.getIconHeight(), true);
            } else {
                g.setColor(Color.WHITE);
                g.fill3DRect(x + 2, y, this.getIconWidth() - 2, this.getIconHeight(), true);
                g.setColor(Color.GRAY);
                g.drawRect(4, 9, 1, 1);
                g.drawRect(7, 9, 1, 1);
                g.drawRect(10, 9, 1, 1);
            }
            g.setColor(oldColor);
        }
    }

    private class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -3699370669894412136L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null || value == null) {
                this.setText("?");
                this.setIcon(new ColoredSquare(Color.BLACK));
                return this;
            }
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!(value instanceof Object[])) {
                return this;
            }
            Object[] itemValues = (Object[])value;
            if (!(itemValues[1] instanceof String)) {
                return this;
            }
            this.setText((String)itemValues[1]);
            if (index >= 0 || this.getText() != "More Colors...") {
                this.setIcon((Icon)itemValues[0]);
            } else {
                this.setText("Custom Color");
                if (!(itemValues[0] instanceof ColoredSquare)) {
                    return this;
                }
                ColoredSquare csq = (ColoredSquare)itemValues[0];
                this.setIcon(new ColoredSquare(csq.getColor()));
            }
            return this;
        }
    }
}

