/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerTextFieldEx
extends JTextField {
    private static final long serialVersionUID = 6503913782014113889L;
    private Integer defaultValue = new Integer(0);
    private IntegerDocumentEx intDoc;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;
    private char numberOfDigits = (char)11;
    private boolean minusAllowed = true;

    public IntegerTextFieldEx() {
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.init();
        this.setText("0");
    }

    public IntegerTextFieldEx(int newMinValue, int newMaxValue) {
        this.minValue = newMinValue;
        this.maxValue = newMaxValue;
        this.checkMinAndMaxValues();
        this.defaultValue = new Integer(this.minValue);
        this.init();
        this.setText(this.defaultValue.toString());
    }

    public IntegerTextFieldEx(String text) {
        this.minValue = Integer.MIN_VALUE;
        this.maxValue = Integer.MAX_VALUE;
        this.init();
        this.setText(text);
    }

    public void setDefaultValue(Integer newDefaultValue) {
        int i = newDefaultValue;
        if (i < this.minValue || i > this.maxValue) {
            return;
        }
        this.defaultValue = new Integer(i);
    }

    public Integer getDefaultValue() {
        return new Integer(this.defaultValue);
    }

    public void setMinMaxValues(int newMinValue, int newMaxValue) {
        Integer oldValue = this.getValue();
        this.minValue = newMinValue;
        this.maxValue = newMaxValue;
        this.checkMinAndMaxValues();
        this.defaultValue = new Integer(this.minValue);
        this.init();
        this.setText(oldValue.toString());
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setText(String text) {
        Integer newValue = this.defaultValue;
        if (text.length() != 0) {
            try {
                newValue = new Integer(Integer.parseInt(text));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.setText(newValue.toString());
    }

    public String getText() {
        return this.getValue().toString();
    }

    public Integer getValue() {
        String content = super.getText();
        if (content.length() != 0) {
            Integer retval;
            try {
                retval = new Integer(Integer.parseInt(content));
            }
            catch (NumberFormatException nfe) {
                return this.defaultValue;
            }
            if (retval < this.minValue) {
                return new Integer(this.minValue);
            }
            if (retval > this.maxValue) {
                return new Integer(this.maxValue);
            }
            return retval;
        }
        return this.defaultValue;
    }

    private void init() {
        this.calcNumberDigits();
        this.intDoc = new IntegerDocumentEx(this.numberOfDigits, this.minusAllowed);
        this.setDocument(this.intDoc);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                IntegerTextFieldEx textField = (IntegerTextFieldEx)e.getSource();
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        int iVal = Integer.parseInt(content);
                        if (iVal < textField.getMinValue()) {
                            iVal = textField.getMinValue();
                        }
                        if (iVal > textField.getMaxValue()) {
                            iVal = textField.getMaxValue();
                        }
                        textField.setText(Integer.toString(iVal));
                    }
                    catch (NumberFormatException nfe) {
                        IntegerTextFieldEx.this.getToolkit().beep();
                        textField.setText(textField.getDefaultValue().toString());
                    }
                } else {
                    textField.setText(textField.getDefaultValue().toString());
                }
            }
        });
    }

    private void calcNumberDigits() {
        int i = Math.max(Math.abs(this.maxValue), Math.abs(this.minValue));
        int digits = 1;
        while ((double)i / 10.0 >= 1.0) {
            digits = (char)(digits + 1);
            i /= 10;
        }
        this.minusAllowed = this.minValue < 0;
        this.numberOfDigits = (char)digits;
    }

    private void checkMinAndMaxValues() {
        if (this.minValue == this.maxValue) {
            this.minValue = Integer.MIN_VALUE;
            this.maxValue = Integer.MAX_VALUE;
            return;
        }
        if (this.minValue > this.maxValue) {
            int tmp = this.minValue;
            this.minValue = this.maxValue;
            this.maxValue = tmp;
        }
    }

    private static class IntegerDocumentEx
    extends PlainDocument {
        private static final long serialVersionUID = 6425645003078010892L;
        private int maxLength = 11;
        private boolean minusAllowed = true;

        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            String newValue;
            if (string == null) {
                return;
            }
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuilder currentBuffer = new StringBuilder(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            if (newValue.equals("-") && this.minusAllowed) {
                super.insertString(offset, newValue, attributes);
                return;
            }
            String textWithOutMinus = newValue.replaceAll("-", "");
            if (textWithOutMinus.length() > this.maxLength) {
                return;
            }
            try {
                Integer.parseInt(newValue);
                super.insertString(offset, string, attributes);
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public IntegerDocumentEx() {
            this.maxLength = 11;
        }

        public IntegerDocumentEx(int newMaxLength, boolean newMinusAllowed) {
            this.maxLength = newMaxLength;
            this.minusAllowed = newMinusAllowed;
        }
    }
}

