/*
 * Decompiled with CFR 0.152.
 */
package avinteraction;

import avinteraction.Documentation;
import avinteraction.GroupInfo;
import avinteraction.InteractionInterface;
import avinteraction.Question;
import avinteraction.UnknownInteractionException;
import avinteraction.UnknownParserException;
import avinteraction.WindowWatcher;
import avinteraction.backend.BackendInterface;
import avinteraction.backend.GenericBackend;
import avinteraction.parser.AnimalscriptParser;
import avinteraction.parser.BadSyntaxException;
import avinteraction.parser.LanguageParserInterface;
import avinteraction.parser.Parser;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import translator.ResourceLocator;
import translator.Translator;

public class InteractionModule
implements InteractionInterface {
    protected static final String EMPTY_STRING = "";
    private static final String RESOURCE_NAME = "interactionRes";
    private static final String PARSER_CONFIG_NAME = "parser.config";
    public static Translator translator;
    private BackendInterface backend;
    private Hashtable<String, Object> allInteractions;
    private Hashtable<String, String> availableParsers;
    private Hashtable<String, GroupInfo> groupInfos;
    private JFrame theFrame;
    private WindowWatcher windowListener;
    private boolean DEBUG = false;

    public InteractionModule() throws BadSyntaxException, IOException {
        this(new GenericBackend());
    }

    public InteractionModule(BackendInterface backendObj) throws BadSyntaxException, IOException {
        this(backendObj, false);
    }

    public InteractionModule(BackendInterface backendObj, boolean integratedInAnimal) throws BadSyntaxException, IOException {
        this.setBackend(backendObj);
        if (integratedInAnimal) {
            this.setUpListForAnimal();
        } else {
            this.createParserList();
        }
    }

    public static Translator getTranslator() {
        return translator;
    }

    public static void setTranslatorLocale(Locale targetLocale) {
        translator = targetLocale != null ? new Translator(RESOURCE_NAME, targetLocale) : new Translator(RESOURCE_NAME, Locale.US);
    }

    public static String translateMessage(String key) {
        return InteractionModule.translateMessage(key, null);
    }

    public static String translateMessage(String key, Object[] parameters) {
        return InteractionModule.getTranslator().translateMessage(key, parameters);
    }

    public void setBackend(BackendInterface backendObj) {
        this.backend = backendObj;
    }

    public BackendInterface getBackend() {
        return this.backend;
    }

    public JFrame getFrame() {
        if (this.theFrame == null) {
            this.theFrame = new JFrame();
            this.theFrame.setDefaultCloseOperation(2);
        }
        return this.theFrame;
    }

    public void interaction(String interactionID) throws UnknownInteractionException {
        if (!this.allInteractions.containsKey(interactionID)) {
            throw new UnknownInteractionException(InteractionModule.translateMessage("unknownInteractionID", new String[]{interactionID}));
        }
        if (this.allInteractions.get(interactionID) instanceof Question) {
            Question aQuestion = (Question)this.allInteractions.get(interactionID);
            this.showQuestion(aQuestion);
        } else if (this.allInteractions.get(interactionID) instanceof Documentation) {
            Documentation doc = (Documentation)this.allInteractions.get(interactionID);
            doc.makeGUI();
            doc.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.theFrame = new JFrame(InteractionModule.translateMessage("docu", new String[]{doc.docURL}));
            this.theFrame.setDefaultCloseOperation(2);
            this.theFrame.getContentPane().add((Component)doc, "Center");
            this.theFrame.setSize(400, 500);
            this.theFrame.setVisible(true);
        }
    }

    public void interactionDefinition(String definitionFile, LanguageParserInterface parser) {
        this.allInteractions = parser.parse(definitionFile);
        this.groupInfos = parser.getGroupInfo();
    }

    public void interactionDefinition(String definitionFile) {
        AnimalscriptParser parser = new AnimalscriptParser(this.DEBUG);
        this.interactionDefinition(definitionFile, parser);
    }

    public void interactionDefinition(String definitionFile, String parserType) throws UnknownParserException {
        LanguageParserInterface parser;
        String className = EMPTY_STRING;
        className = this.availableParsers.get(parserType);
        if (EMPTY_STRING.equals(className)) {
            throw new UnknownParserException(InteractionModule.translateMessage("unknownParser", new String[]{parserType}));
        }
        try {
            Class<?> c = Class.forName(className);
            parser = (LanguageParserInterface)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new UnknownParserException(InteractionModule.translateMessage("parserNotLoaded", new String[]{e.getMessage()}));
        }
        catch (IllegalAccessException e) {
            throw new UnknownParserException(InteractionModule.translateMessage("parserNotLoaded", new String[]{e.getMessage()}));
        }
        catch (InstantiationException e) {
            throw new UnknownParserException(InteractionModule.translateMessage("parserNotLoaded", new String[]{e.getMessage()}));
        }
        parser.setDebug(this.DEBUG);
        this.allInteractions = parser.parse(definitionFile);
        this.groupInfos = parser.getGroupInfo();
    }

    protected void closeElement(String questionID) {
        JPanel displayElement = (JPanel)this.allInteractions.get(questionID);
        if (displayElement != null) {
            this.theFrame.remove(displayElement);
        }
        this.theFrame.removeWindowListener(this.windowListener);
    }

    protected void createParserList() throws BadSyntaxException, IOException {
        InputStream inS = this.getClass().getResourceAsStream("/parser.config");
        inS = ResourceLocator.getResourceLocator().getResourceStream(PARSER_CONFIG_NAME);
        StreamTokenizer stok = new StreamTokenizer(new BufferedReader(new InputStreamReader(inS)));
        Parser parser = new Parser(stok);
        stok.commentChar(35);
        this.availableParsers = new Hashtable();
        try {
            while (stok.ttype != -1) {
                String type = EMPTY_STRING;
                String parserClass = EMPTY_STRING;
                parser.getOptionalWhitespace();
                while (parser.getOptionalEOX()) {
                    parser.getOptionalWhitespace();
                }
                type = parser.getQuoted();
                parser.getOptionalWhitespace();
                char aChar = parser.getChar();
                if (aChar != '=') {
                    throw new BadSyntaxException(InteractionModule.translateMessage("lookingForEquals", new String[]{String.valueOf((int)aChar), PARSER_CONFIG_NAME}));
                }
                parser.getOptionalWhitespace();
                parserClass = parser.getQuoted();
                parser.getOptionalWhitespace();
                parser.getEOX();
                this.availableParsers.put(type, parserClass);
            }
        }
        catch (BadSyntaxException e) {
            throw new BadSyntaxException(InteractionModule.translateMessage("parserConfigError", new String[]{PARSER_CONFIG_NAME, e.getMessage()}));
        }
    }

    protected void processQuestion(String interactionID, Question aQuestion) {
        boolean displayAnswer = this.backend.submitAnswer(interactionID, aQuestion.isCorrect(), aQuestion.getPoints(), aQuestion.getAchievedPoints());
        String groupID = aQuestion.getGroupID();
        GroupInfo group = this.groupInfos.get(groupID);
        if (!EMPTY_STRING.equals(groupID) && group != null && aQuestion.isCorrect()) {
            ++group.processed;
        }
        aQuestion.setFeedbackBlack();
        StringBuilder feedbackBuffer = new StringBuilder(256);
        if (displayAnswer) {
            if (!EMPTY_STRING.equals(aQuestion.getComment())) {
                feedbackBuffer.append(aQuestion.getComment());
            } else if (aQuestion.isCorrect()) {
                feedbackBuffer.append(InteractionModule.translateMessage("answerCorrect"));
            } else {
                feedbackBuffer.append(InteractionModule.translateMessage("answerInCorrect"));
            }
        } else {
            feedbackBuffer.append(InteractionModule.translateMessage("answerSubmitted"));
        }
        feedbackBuffer.append(InteractionModule.translateMessage("mayCloseWindow"));
        aQuestion.setFeedback(feedbackBuffer.toString());
    }

    private void setUpListForAnimal() {
        this.availableParsers = new Hashtable();
        this.availableParsers.put("text/animalscript", "avinteraction.parser.AnimalscriptParser");
    }

    private void showQuestion(Question aQuestion) {
        String groupID = aQuestion.getGroupID();
        GroupInfo group = this.groupInfos.get(groupID);
        if (group != null && !EMPTY_STRING.equals(groupID) && group.processed >= group.repeats && group.processed != 0 && group.repeats != 0) {
            return;
        }
        boolean guiBuilt = aQuestion.getGuiBuilt();
        if (guiBuilt) {
            aQuestion.rebuildQuestion();
        } else {
            aQuestion.makeGUI();
        }
        aQuestion.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        aQuestion.setVisible(true);
        aQuestion.setHandler(this);
        this.theFrame = new JFrame(aQuestion.getTitle());
        this.theFrame.getContentPane().add((Component)aQuestion, "Center");
        if (this.windowListener == null) {
            this.windowListener = new WindowWatcher();
        }
        this.windowListener.setInstance(this);
        this.windowListener.setID(aQuestion.objectID);
        this.theFrame.addWindowListener(this.windowListener);
        this.theFrame.pack();
        Dimension theSize = this.theFrame.getSize();
        this.theFrame.setSize(400, theSize.height);
        this.theFrame.setVisible(true);
    }
}

