/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.generators.SourceCodeGenerator;
import animalscriptapi.properties.SourceCodeProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.util.HashMap;
import java.util.LinkedList;

public class SourceCode
extends Primitive {
    private SourceCodeProperties properties;
    private SourceCodeGenerator generator = null;
    private Node upperLeft;
    private LinkedList<String> lines;
    private HashMap<String, String> linesRows;
    private HashMap<String, Integer> elementRows;
    private HashMap<String, Integer> labelsToLineNumbers;

    public SourceCode(SourceCodeGenerator scg, Node upperLeftCorner, String name, DisplayOptions display, SourceCodeProperties sp) {
        super(scg, display);
        this.upperLeft = upperLeftCorner;
        this.properties = sp;
        this.setName(name);
        this.generator = scg;
        this.lines = new LinkedList();
        this.elementRows = new HashMap();
        this.labelsToLineNumbers = new HashMap(47);
        this.generator.create(this);
    }

    public SourceCodeProperties getProperties() {
        return this.properties;
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public int addCodeLine(String codeline, String name, int indentation, Timing delay) throws NullPointerException {
        if (codeline != null) {
            this.lines.add(codeline);
            this.generator.addCodeLine(this, codeline, name, indentation, delay);
            if (name != null) {
                this.labelsToLineNumbers.put(name, new Integer(this.lines.size() - 1));
            }
            return this.lines.size();
        }
        throw new NullPointerException("Please provide a code line.");
    }

    public int addCodeElement(String codeline, String name, int row, int indentation, Timing delay) throws NullPointerException {
        String line;
        if (codeline != null && (line = this.lines.getLast()) != null) {
            this.elementRows.put(codeline, new Integer(row));
            this.linesRows.put(codeline, line);
            this.generator.addCodeElement(this, codeline, name, indentation, row, delay);
            if (name != null) {
                this.labelsToLineNumbers.put(name, new Integer(this.lines.size() - 1));
            }
            return this.lines.size();
        }
        throw new NullPointerException("Please provide a code line.");
    }

    public void highlight(int line) throws LineNotExistsException {
        this.highlight(line, -1, false, null, null);
    }

    public void highlight(int line, int row, boolean context) throws LineNotExistsException {
        this.highlight(line, row, context, null, null);
    }

    public void highlight(String lineName) throws LineNotExistsException {
        this.highlight(lineName, -1, false, null, null);
    }

    public void highlight(String lineName, int row, boolean context) throws LineNotExistsException {
        this.highlight(lineName, row, context, null, null);
    }

    public void highlight(String lineName, int row, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        Integer lineNo = this.labelsToLineNumbers.get(lineName);
        if (lineNo == null || lineNo >= this.lines.size()) {
            throw new LineNotExistsException("Line #" + lineNo + " [" + lineName + "] is greater than the max. line #");
        }
        this.generator.highlight(this, lineNo, row, context, delay, duration);
    }

    public void highlight(int line, int row, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        if (line >= this.lines.size()) {
            throw new LineNotExistsException("Line #" + line + " is greater than the max. line #");
        }
        this.generator.highlight(this, line, row, context, delay, duration);
    }

    public void toggleHighlight(int previousLine, int newLine) throws LineNotExistsException {
        this.toggleHighlight(previousLine, -1, false, newLine, -1, null, null);
    }

    public void toggleHighlight(int previousLine, int previousRow, boolean switchToContextMode, int newLine, int newRow) throws LineNotExistsException {
        this.toggleHighlight(previousLine, previousRow, switchToContextMode, newLine, newRow, null, null);
    }

    public void toggleHighlight(String previousLineName, String newLineName) throws LineNotExistsException {
        this.toggleHighlight(previousLineName, -1, false, newLineName, -1, null, null);
    }

    public void toggleHighlight(String previousLineName, int previousRow, boolean switchToContextMode, String newLineName, int newRow) throws LineNotExistsException {
        this.toggleHighlight(previousLineName, previousRow, switchToContextMode, newLineName, newRow, null, null);
    }

    public void toggleHighlight(int previousLine, int previousRow, boolean switchToContextMode, int newLine, int newRow, Timing delay, Timing duration) throws LineNotExistsException {
        this.unhighlight(previousLine, previousRow, switchToContextMode, delay, duration);
        this.highlight(newLine, newRow, switchToContextMode, delay, duration);
    }

    public void toggleHighlight(String previousLineName, int previousRow, boolean switchToContextMode, String newLineName, int newRow, Timing delay, Timing duration) throws LineNotExistsException {
        this.unhighlight(previousLineName, previousRow, switchToContextMode, delay, duration);
        this.highlight(newLineName, newRow, switchToContextMode, delay, duration);
    }

    public void unhighlight(int line) throws LineNotExistsException {
        this.unhighlight(line, -1, false, null, null);
    }

    public void unhighlight(int line, int row, boolean context) throws LineNotExistsException {
        this.unhighlight(line, row, context, null, null);
    }

    public void unhighlight(String lineName) throws LineNotExistsException {
        this.unhighlight(lineName, -1, false, null, null);
    }

    public void unhighlight(String lineName, int row, boolean context) throws LineNotExistsException {
        this.unhighlight(lineName, row, context, null, null);
    }

    public void unhighlight(int line, int row, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        if (line >= this.lines.size()) {
            throw new LineNotExistsException("Line #" + line + " is greater than the max. line #");
        }
        this.generator.unhighlight(this, line, row, context, delay, duration);
    }

    public void unhighlight(String lineName, int row, boolean context, Timing delay, Timing duration) throws LineNotExistsException {
        Integer lineNo = this.labelsToLineNumbers.get(lineName);
        if (lineNo == null || lineNo >= this.lines.size()) {
            throw new LineNotExistsException("Line #" + lineNo + " is greater than the max. line #");
        }
        this.generator.unhighlight(this, lineNo, row, context, delay, duration);
    }

    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }
}

