/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.Polygon;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.primitives.generators.PolygonGenerator;
import animalscriptapi.properties.PolygonProperties;
import animalscriptapi.util.Node;
import java.awt.Color;

public class AnimalPolygonGenerator
extends AnimalGenerator
implements PolygonGenerator {
    private static int count = 1;

    public AnimalPolygonGenerator(Language aLang) {
        super(aLang);
    }

    public void create(Polygon p) {
        if (this.isNameUsed(p.getName()) || p.getName() == "") {
            p.setName("Polygon" + count);
            ++count;
        }
        this.lang.addItem(p);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("polygon \"" + p.getName() + "\" ");
        Node[] nodes = p.getNodes();
        int i = 0;
        while (i < nodes.length) {
            str.append(AnimalGenerator.makeNodeDef(nodes[i]));
            ++i;
        }
        PolygonProperties props = p.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
            str.append(" filled");
            if (props.get("fillColor") != null) {
                str.append(" fillColor ");
                str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(p.getDisplayOptions()));
        this.lang.addLine(str);
    }
}

