/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.exceptions.IllegalDirectionException;
import animalscriptapi.primitives.Polygon;
import animalscriptapi.primitives.Polyline;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.Square;
import animalscriptapi.primitives.Triangle;
import animalscriptapi.primitives.generators.Generator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Hidden;
import animalscriptapi.util.Node;
import animalscriptapi.util.Offset;
import animalscriptapi.util.Timing;
import java.awt.Color;

public abstract class AnimalGenerator
extends Generator {
    public AnimalGenerator(Language aLang) {
        super(aLang);
    }

    public static String makeNodeDef(Node n) {
        if (n instanceof Offset) {
            Offset o = (Offset)n;
            return "offset (" + o.getX() + "," + o.getY() + ") from \"" + o.getRef().getName() + "\" " + o.getDirection();
        }
        if (n instanceof Coordinates) {
            Coordinates c = (Coordinates)n;
            return "(" + c.getX() + "," + c.getY() + ")";
        }
        return "";
    }

    public static String makeColorDef(int r, int g, int b) {
        return "(" + r % 256 + "," + g % 256 + "," + b % 256 + ")";
    }

    public static String makeColorDef(Color aColor) {
        if (aColor == null) {
            return "(0, 0, 0)";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append("(").append(aColor.getRed() % 256).append(", ");
        sb.append(aColor.getGreen() % 256).append(", ");
        sb.append(aColor.getBlue() % 256).append(")");
        return sb.toString();
    }

    public static String makeOffsetTimingDef(Timing delay) {
        if (delay == null) {
            return "";
        }
        return " after " + delay.getDelay() + " " + delay.getUnit();
    }

    public static String makeDurationTimingDef(Timing duration) {
        if (duration == null) {
            return "";
        }
        return " within " + duration.getDelay() + " " + duration.getUnit();
    }

    public static String makeDisplayOptionsDef(DisplayOptions d) {
        if (d instanceof Hidden) {
            return " hidden";
        }
        if (d instanceof Timing) {
            return AnimalGenerator.makeOffsetTimingDef((Timing)d);
        }
        return "";
    }

    public void exchange(Primitive p, Primitive q) {
        this.lang.addLine("exchange \"" + p.getName() + "\" \"" + q.getName() + "\"");
    }

    public void hide(Primitive q, Timing t) {
        this.lang.addLine("hide \"" + q.getName() + "\" " + AnimalGenerator.makeOffsetTimingDef(t));
    }

    public void rotate(Primitive p, Primitive around, int degrees, Timing t, Timing d) {
        if (p instanceof Polygon || p instanceof Rect || p instanceof Triangle || p instanceof Square) {
            this.lang.addLine("rotate \"" + p.getName() + "\" around \"" + around.getName() + "\" degrees " + degrees % 360 + AnimalGenerator.makeOffsetTimingDef(t) + " " + AnimalGenerator.makeDurationTimingDef(d));
        }
    }

    public void rotate(Primitive p, Node center, int degrees, Timing t, Timing d) {
        if (p instanceof Polyline || p instanceof Square || p instanceof Rect || p instanceof Triangle || p instanceof Polygon) {
            StringBuilder def = new StringBuilder("rotate \"");
            def.append(p.getName());
            def.append("\" center ");
            def.append(AnimalGenerator.makeNodeDef(center));
            def.append(" ");
            if (degrees != 0) {
                def.append(" degrees ");
                def.append(degrees % 360);
            }
            def.append(AnimalGenerator.makeOffsetTimingDef(t));
            def.append(AnimalGenerator.makeDurationTimingDef(d));
            this.lang.addLine(def);
        }
    }

    public void show(Primitive p, Timing t) {
        this.lang.addLine("show \"" + p.getName() + "\" " + AnimalGenerator.makeOffsetTimingDef(t));
    }

    public void moveVia(Primitive elem, String direction, String moveType, Primitive via, Timing delay, Timing d) throws IllegalDirectionException {
        if (!this.lang.isValidDirection(direction)) {
            throw new IllegalDirectionException(direction);
        }
        String str = "move \"" + elem.getName() + "\"";
        if (direction != null) {
            str = String.valueOf(str) + " corner " + direction;
        }
        if (moveType != null) {
            str = String.valueOf(str) + " type \"" + moveType + "\"";
        }
        this.lang.addLine(String.valueOf(str) + " via \"" + via.getName() + "\" " + AnimalGenerator.makeOffsetTimingDef(delay) + " " + AnimalGenerator.makeDurationTimingDef(d));
    }

    public void moveTo(Primitive p, String direction, String moveType, Node target, Timing delay, Timing duration) throws IllegalDirectionException {
        if (!this.lang.isValidDirection(direction)) {
            throw new IllegalDirectionException(direction);
        }
        String str = "move \"" + p.getName() + "\"";
        if (direction != null) {
            str = String.valueOf(str) + " corner " + direction;
        }
        if (moveType != null) {
            str = String.valueOf(str) + " type \"" + moveType + "\"";
        }
        this.lang.addLine(String.valueOf(str) + " to " + AnimalGenerator.makeNodeDef(target) + " " + AnimalGenerator.makeOffsetTimingDef(delay) + " " + AnimalGenerator.makeDurationTimingDef(duration));
    }

    public void moveBy(Primitive p, String moveType, int dx, int dy, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder();
        sb.append("move \"").append(p.getName()).append("\"");
        if (moveType != null) {
            sb.append(" type \"").append(moveType).append("\"");
        }
        sb.append(" along line (0, 0) (").append(dx).append(", ").append(dy);
        sb.append(") ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    public void changeColor(Primitive elem, String colorType, Color newColor, Timing delay, Timing d) {
        String str = "color \"" + elem.getName() + "\"";
        if (colorType != null && colorType != "") {
            str = String.valueOf(str) + " type \"" + colorType + "\"";
        }
        str = String.valueOf(str) + " " + AnimalGenerator.makeColorDef(newColor.getRed(), newColor.getGreen(), newColor.getBlue());
        str = String.valueOf(str) + " " + AnimalGenerator.makeOffsetTimingDef(delay);
        str = String.valueOf(str) + " " + AnimalGenerator.makeDurationTimingDef(d);
        this.lang.addLine(str);
    }
}

