/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.CircleSeg;
import animalscriptapi.primitives.generators.CircleSegGenerator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.CircleSegProperties;
import java.awt.Color;

public class AnimalCircleSegGenerator
extends AnimalGenerator
implements CircleSegGenerator {
    private static int count = 1;

    public AnimalCircleSegGenerator(Language aLang) {
        super(aLang);
    }

    public void create(CircleSeg aseg) {
        if (this.isNameUsed(aseg.getName()) || aseg.getName() == "") {
            aseg.setName("CircleSeg" + count);
            ++count;
        }
        this.lang.addItem(aseg);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("circleSeg \"" + aseg.getName() + "\" ");
        str.append(AnimalGenerator.makeNodeDef(aseg.getCenter()));
        str.append(" radius " + aseg.getRadius());
        CircleSegProperties props = aseg.getProperties();
        if (props.get("angle") != null) {
            str.append(" angle " + props.get("angle").toString());
        }
        if (props.get("startAngle") != null) {
            str.append(" startAngle " + props.get("startAngle").toString());
        }
        if (props.get("clockwise") != null && ((Boolean)props.get("clockwise")).booleanValue()) {
            str.append(" clockwise ");
        } else if (props.get("clockwise") != null && ((Boolean)props.get("counterclockwise")).booleanValue()) {
            str.append(" counterclockwise ");
        }
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("closed") != null && ((Boolean)props.get("closed")).booleanValue()) {
            str.append(" closed ");
            if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
                str.append(" filled");
                if (props.get("fillColor") != null) {
                    str.append(" fillColor ");
                    str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
                }
            }
        } else {
            if (props.get("fwArrow") != null && ((Boolean)props.get("fwArrow")).booleanValue()) {
                str.append(" fwarrow ");
            }
            if (props.get("bwArrow") != null && ((Boolean)props.get("bwArrow")).booleanValue()) {
                str.append(" bwarrow ");
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(aseg.getDisplayOptions()));
        this.lang.addLine(str);
    }
}

