/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.DocumentationAction;
import animal.animator.ExternalAction;
import animal.animator.FillInBlanksQuestionAction;
import animal.animator.InteractionElement;
import animal.animator.MultipleChoiceQuestionAction;
import animal.animator.PerformableAction;
import animal.animator.TrueFalseQuestionAction;
import animal.main.Animal;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import avinteraction.InteractionModule;
import avinteraction.UnknownParserException;
import avinteraction.backend.AnimalEvalBackend;
import avinteraction.backend.BackendInterface;
import avinteraction.parser.BadSyntaxException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;

public class ExternalActionSupport
extends BasicParser
implements AnimalScriptInterface {
    private static InteractionModule interactionHandler;
    private BackendInterface backend = null;
    private boolean startQuestionsEncountered = false;

    public ExternalActionSupport() {
        this.handledKeywords = new Hashtable();
        this.handledKeywords.put("documentation", "parseDocumentation");
        this.handledKeywords.put("fibquestion", "parseFIBQuestion");
        this.handledKeywords.put("mcquestion", "parseMCQuestion");
        this.handledKeywords.put("tfquestion", "parseTFQuestion");
        this.handledKeywords.put("startquestions", "parseStartQuestions");
        this.handledKeywords.put("interactiondefinition", "parseInteractionDefinition");
        this.handledKeywords.put("interaction", "parseInteraction");
        ExternalAction.clearActions();
        this.backend = new AnimalEvalBackend();
        try {
            interactionHandler = new InteractionModule(this.backend, true);
            InteractionModule.setTranslatorLocale(Animal.getCurrentLocale());
        }
        catch (BadSyntaxException e) {
            System.err.println("Problem: bad syntax for backend...");
        }
        catch (Exception ee) {
            System.err.println("Some other exception: " + ee.getClass().getName() + " / " + ee.getMessage());
            ee.printStackTrace();
        }
    }

    public boolean generateNewStep(String command) {
        if (this.startQuestionsEncountered && !employsQuestions) {
            this.startQuestionsEncountered = false;
        }
        return !sameStep && !employsQuestions && !command.equalsIgnoreCase("StartQuestions");
    }

    public void reset() {
        employsQuestions = false;
    }

    private int getPointsPossibleForQuestion(StreamTokenizer strTok, String message) {
        return this.getPointsPossibleForQuestion(strTok, message, 0, Integer.MAX_VALUE);
    }

    private int getMinimumIterationCount(StreamTokenizer strTok, String message) {
        int minIterationCount = 1;
        try {
            if (ParseSupport.parseOptionalWord(strTok, String.valueOf(message) + " keyword 'nrRepeats'", "nrRepeats")) {
                minIterationCount = ParseSupport.parseInt(strTok, String.valueOf(message) + " minimum number of iterations", 1);
                MessageDisplay.message(String.valueOf(message) + minIterationCount);
                ParseSupport.parseMandatoryEOL(stok, String.valueOf(message) + " answer EOL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return minIterationCount;
    }

    int getPointsPossibleForQuestion(StreamTokenizer strTok, String message, int minPossible, int maxPossible) {
        int pointsPossible = 1;
        try {
            if (ParseSupport.parseOptionalWord(strTok, String.valueOf(message) + " keyword 'points'", "Points")) {
                pointsPossible = ParseSupport.parseInt(strTok, String.valueOf(message) + " possible points", 1);
                MessageDisplay.message(String.valueOf(message) + pointsPossible);
                ParseSupport.parseMandatoryEOL(stok, String.valueOf(message) + " answer EOL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pointsPossible;
    }

    private String getQuestionGroup(StreamTokenizer strTok, String message) {
        String questionGroup = null;
        try {
            if (ParseSupport.parseOptionalWord(strTok, String.valueOf(message) + " keyword 'questionGroup'", "QuestionGroup")) {
                questionGroup = AnimalParseSupport.parseText(strTok, String.valueOf(message) + " question group");
                MessageDisplay.message(String.valueOf(message) + '\"' + questionGroup + '\"');
                ParseSupport.parseMandatoryEOL(strTok, String.valueOf(message) + " answer EOL");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return questionGroup;
    }

    public void parseDocumentation() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'Documentation' keyword", "Documentation");
        String targetURL = AnimalParseSupport.parseText(stok, "Documentation URL");
        ExternalAction externalAction = new ExternalAction(currentStep, 1, "docu", new DocumentationAction(targetURL));
        BasicParser.addAnimatorToAnimation(externalAction, anim);
    }

    public BackendInterface getInteractionBackend() {
        return this.backend;
    }

    public void parseFIBQuestion() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'FIBQuestion' keyword", "FIBQuestion");
        String questionID = "\"" + AnimalParseSupport.parseText(stok, "question ID") + "\"";
        if (!this.startQuestionsEncountered) {
            FillInBlanksQuestionAction targetAction = new FillInBlanksQuestionAction(questionID);
            ExternalAction externalAction = new ExternalAction(currentStep, 2, questionID, targetAction);
            BasicParser.addAnimatorToAnimation(externalAction, anim);
        } else {
            String entry;
            boolean usableAction = true;
            PerformableAction action = null;
            try {
                action = ExternalAction.getActionNamed(questionID);
            }
            catch (Exception e) {
                usableAction = false;
            }
            usableAction = action != null && action instanceof FillInBlanksQuestionAction;
            FillInBlanksQuestionAction targetAction = null;
            targetAction = usableAction ? (FillInBlanksQuestionAction)action : new FillInBlanksQuestionAction(String.valueOf(questionID));
            ParseSupport.parseMandatoryEOL(stok, "FillInBlanksQuestion keyword 'answer' EOL");
            String questionGroup = this.getQuestionGroup(stok, "Fill in the Blanks Question \"" + questionID + "\" Group ");
            int minIterations = this.getMinimumIterationCount(stok, "Fill in the Blanks Question \"" + questionID + "\" minimum number of iterations: ");
            int pointsPossible = this.getPointsPossibleForQuestion(stok, "Fill in the Blanks Question \"" + questionID + "\" points possible ");
            while (!ParseSupport.parseOptionalWord(stok, "FillInBlanksQuestion keyword 'ENDTEXT'", "endtext")) {
                entry = AnimalParseSupport.parseText(stok, "FillInBlanksQuestion prompt");
                ParseSupport.parseMandatoryEOL(stok, "FillInBlanksQuestion question EOL");
                targetAction.addToQuestionText(entry);
            }
            ParseSupport.parseMandatoryEOL(stok, "FillInBlanksQuestion question EOL");
            ParseSupport.parseMandatoryWord(stok, "FillInBlanksQuestion keyword 'answer'", "answer");
            ParseSupport.parseMandatoryEOL(stok, "FillInBlanksQuestion keyword 'answer' EOL");
            while (!ParseSupport.parseOptionalWord(stok, "FillInBlanksQuestion keyword 'ENDTEXT'", "endanswer")) {
                entry = AnimalParseSupport.parseText(stok, "FillInBlanksQuestion answer");
                ParseSupport.parseMandatoryEOL(stok, "FillInBlanksQuestion answer EOL");
                targetAction.addAnswer(entry);
            }
            if (!usableAction) {
                System.err.println("Throwing away the following interaction object, as it was not declared:\n" + targetAction.toString());
            }
        }
    }

    public void parseMCQuestion() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'MCQuestion' keyword", "MCQuestion");
        String questionID = "\"" + AnimalParseSupport.parseText(stok, "question ID") + "\"";
        if (!this.startQuestionsEncountered) {
            MultipleChoiceQuestionAction targetAction = new MultipleChoiceQuestionAction(questionID);
            ExternalAction externalAction = new ExternalAction(currentStep, 2, questionID, targetAction);
            BasicParser.addAnimatorToAnimation(externalAction, anim);
        } else {
            boolean usableAction = true;
            PerformableAction action = null;
            try {
                action = ExternalAction.getActionNamed(questionID);
            }
            catch (Exception e) {
                usableAction = false;
            }
            usableAction = action != null && action instanceof MultipleChoiceQuestionAction;
            MultipleChoiceQuestionAction targetAction = null;
            targetAction = usableAction ? (MultipleChoiceQuestionAction)action : new MultipleChoiceQuestionAction(String.valueOf(questionID));
            ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion keyword 'answer' EOL");
            int nrAnswers = 0;
            int pointsPossible = 1;
            int minIterations = 1;
            String questionText = null;
            String answerText = null;
            String commentText = null;
            String questionGroup = null;
            questionGroup = this.getQuestionGroup(stok, "Multiple Choice Question \"" + questionID + "\" Group ");
            minIterations = this.getMinimumIterationCount(stok, "Multiple Choice Question \"" + questionID + "\" minimum number of iterations: ");
            pointsPossible = this.getPointsPossibleForQuestion(stok, "Multiple Choice Question \"" + questionID + "\" points possible ");
            while (!ParseSupport.parseOptionalWord(stok, "MultipleChoiceQuestion keyword 'ENDTEXT'", "endtext")) {
                questionText = AnimalParseSupport.parseText(stok, "MultipleChoiceQuestion prompt");
                ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion question EOL");
                targetAction.addToQuestionText(questionText);
            }
            ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion question EOL");
            while (!ParseSupport.parseOptionalWord(stok, "MultipleChoiceQuestion keyword 'ANSWER'", "answer")) {
                answerText = AnimalParseSupport.parseText(stok, "MultipleChoiceQuestion choice");
                targetAction.addAnswer(answerText);
                ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion choice EOL");
                ParseSupport.parseMandatoryWord(stok, "MultipleChoiceQuestion keyword 'endchoice'", "EndChoice");
                ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion choice EOL");
                if (ParseSupport.parseOptionalWord(stok, "MultipleChoiceQuestion parameter 'comment'", "comment")) {
                    ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion choice EOL");
                    commentText = AnimalParseSupport.parseText(stok, "MultipleChoiceQuestion comment");
                    MessageDisplay.message("Didactical comment for question\n\t\"" + questionText + "\"\n\tanswer " + answerText + ":\n\t" + commentText);
                    ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion choice EOL");
                    ParseSupport.parseMandatoryWord(stok, "MultipleChoiceQuestion choice ENDCOMMENT", "EndComment");
                    ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion choice EOL");
                }
                ++nrAnswers;
            }
            ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion answer EOL");
            int correctAnswer = ParseSupport.parseInt(stok, "MultipleChoiceQuestion correct answer ID", 1, nrAnswers);
            targetAction.setCorrectAnswer(correctAnswer);
            ParseSupport.parseMandatoryEOL(stok, "MultipleChoiceQuestion answer EOL");
            ParseSupport.parseMandatoryWord(stok, "MultipleChoiceQuestion keyword 'endAnswer'", "endAnswer");
            if (!usableAction) {
                System.err.println("Throwing away the following interaction object, as it was not declared:\n" + targetAction.toString());
            }
        }
    }

    public void parseTFQuestion() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'TFQuestion' keyword", "TFQuestion");
        String questionID = "\"" + AnimalParseSupport.parseText(stok, "question ID") + "\"";
        if (!this.startQuestionsEncountered) {
            TrueFalseQuestionAction targetAction = new TrueFalseQuestionAction(questionID);
            ExternalAction externalAction = new ExternalAction(currentStep, 2, questionID, targetAction);
            BasicParser.addAnimatorToAnimation(externalAction, anim);
        } else {
            PerformableAction action = null;
            boolean usableAction = true;
            try {
                action = ExternalAction.getActionNamed(questionID);
            }
            catch (Exception e) {
                usableAction = false;
            }
            usableAction = action != null && action instanceof TrueFalseQuestionAction;
            TrueFalseQuestionAction targetAction = null;
            targetAction = usableAction ? (TrueFalseQuestionAction)action : new TrueFalseQuestionAction(String.valueOf(questionID));
            ParseSupport.parseMandatoryEOL(stok, "TrueFalseQuestion keyword 'answer' EOL");
            String questionGroup = this.getQuestionGroup(stok, "True/False Question \"" + questionID + "\" Group ");
            int minIterations = this.getMinimumIterationCount(stok, "True/False Question \"" + questionID + "\" minimum number of iterations: ");
            int pointsPossible = this.getPointsPossibleForQuestion(stok, "True/False Question \"" + questionID + "\" points possible ");
            while (!ParseSupport.parseOptionalWord(stok, "TrueFalseQuestion keyword 'ENDTEXT'", "endtext")) {
                String entry = AnimalParseSupport.parseText(stok, "TrueFalseQuestion prompt");
                ParseSupport.parseMandatoryEOL(stok, "TrueFalseQuestion question EOL");
                targetAction.addToQuestionText(entry);
            }
            ParseSupport.parseMandatoryEOL(stok, "FillInBlanksQuestion question EOL");
            ParseSupport.parseMandatoryWord(stok, "TrueFalseQuestion keyword 'ANSWER'", "answer");
            ParseSupport.parseMandatoryEOL(stok, "FillInBlanksQuestion answer EOL");
            String result = ParseSupport.parseWord(stok, "TrueFalseQuestion classifier");
            boolean isCorrect = result.toLowerCase().equals("t");
            ParseSupport.parseMandatoryEOL(stok, "TrueFalseQuestion classifier EOL");
            ParseSupport.parseMandatoryWord(stok, "TrueFalseQuestion keyword 'ENDANSWER'", "endAnswer");
            if (usableAction) {
                targetAction.setCorrectAnswer(isCorrect);
            } else {
                System.err.println("Throwing away the following interaction object, as it was not declared:\n" + targetAction.toString());
            }
        }
    }

    public void parseStartQuestions() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'StartQuestions' keyword", "StartQuestions");
        this.startQuestionsEncountered = true;
        employsQuestions = true;
        ExternalAction.resetActions();
    }

    public void parseInteractionDefinition() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'InteractionDefinition' keyword", "interactionDefinition");
        String interactionURL = AnimalParseSupport.parseText(stok, "interactionDefinition URL");
        try {
            interactionHandler.interactionDefinition(interactionURL, "text/animalscript");
        }
        catch (UnknownParserException upe) {
            System.err.println("Oops, parser unknown!");
        }
        catch (Exception ee) {
            System.err.println("Some other exception: " + ee.getMessage());
        }
        InteractionElement interactionElement = new InteractionElement(currentStep, interactionURL, 1, interactionHandler);
        BasicParser.addAnimatorToAnimation(interactionElement, anim);
        interactionElement.action(0L, 0.0);
    }

    public void parseInteraction() throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'Interaction' keyword", "interaction");
        String interactionID = AnimalParseSupport.parseText(stok, "interaction ID");
        InteractionElement interactionElement = new InteractionElement(currentStep, interactionID, 2, interactionHandler);
        BasicParser.addAnimatorToAnimation(interactionElement, anim);
    }
}

