/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BaseAdminProducer;
import animalscript.core.BasicParser;
import java.awt.Point;
import java.io.IOException;
import java.util.Hashtable;

public class BaseAdminParser
extends BasicParser
implements AnimalScriptInterface {
    public static final String DELAY_KEY_PRESS = "delay.keyPress";
    public static final String DELAY_OBJECT_CLICK = "delay.clickOn";
    public static final String DELAY_TARGET_ID = "delay.targetID";
    public static final String DELAY_TIME = "delay.time";
    public static final String DELAY_TYPE = "delay.type";
    public static final String DELAY_UNIT = "delay.unit";
    public static final String ECHO_BOUND_IDS = "echo.boundingBoxIDs";
    public static final String ECHO_LOCATION = "echo.location";
    public static final String ECHO_MODE = "echo.mode";
    public static final String ECHO_RULE_NAME = "echo.ruleName";
    public static final String ECHO_RULE_VALUE = "echo.ruleValue";
    public static final String ECHO_TEXT = "echo.text";
    public static final String ECHO_VALUE_IDS = "echo.valueIDs";
    public static final String GROUP_ID = "group.groupID";
    public static final String GROUP_MODE = "group.mode";
    public static final String GROUP_TARGET_OIDS = "group.targetOIDs";
    public static final String GROUP_TYPE = "group.type";
    public static final String LABEL_ID = "label.ID";
    public static final String LOCATION_ID = "location.name";
    public static final String LOCATION_POINT = "location.point";
    public static final String SWAP_TYPE = "swap.type";
    public static final String SWAP_FIRST_OID = "swap.firstOID";
    public static final String SWAP_SECOND_OID = "swap.secondOID";
    private static BaseAdminProducer producer = new BaseAdminProducer();

    public BaseAdminParser() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("delay", "parseDelay");
        this.rulesHash.put("delay", "# delay next step by <int> ms or ticks");
        this.handledKeywords.put("echo", "parseEcho");
        this.handledKeywords.put("print", "parseEcho");
        this.handledKeywords.put("write", "parseEcho");
        this.rulesHash.put("echo", "# debugging support by printing...:\n# * the location of the given node,\n# * the bounding box for each given object\n# * the given text to stdout; useful for state messages in loading\n# *  the value of assignments\n# * the numeric IDs of the objects with the given name(s)\n# * the ids of all currently visible objects");
        this.rulesHash.put("print", "see rule for 'echo'");
        this.rulesHash.put("write", "see rule for 'echo'");
        this.handledKeywords.put("group", "parseGrouping");
        this.handledKeywords.put("merge", "parseGrouping");
        this.handledKeywords.put("remove", "parseGrouping");
        this.handledKeywords.put("set", "parseGrouping");
        this.handledKeywords.put("ungroup", "parseGrouping");
        this.rulesHash.put("group", "# merge the given IDs under new ID 'groupID'");
        this.rulesHash.put("merge", "# see rule for 'group'");
        this.rulesHash.put("set", "# see rule for 'group'");
        this.rulesHash.put("remove", "# remove the given ID(s) from the group ID");
        this.rulesHash.put("ungroup", "# see rule for 'remove'");
        this.handledKeywords.put("label", "parseLabel");
        this.rulesHash.put("label", "# insert 'label title' as a target for direct jumps in the TimeLine window");
        this.handledKeywords.put("deflocation", "parseLocation");
        this.handledKeywords.put("definelocation", "parseLocation");
        this.handledKeywords.put("location", "parseLocation");
        this.handledKeywords.put("movelocation", "parseLocation");
        this.rulesHash.put("location", "# define a new location that can be used wherever\n# a location is expected, as if generated from an object");
        this.rulesHash.put("deflocation", "# see rule for 'location'");
        this.rulesHash.put("definelocation", "# see rule for 'location'");
        this.handledKeywords.put("swap", "parseSwap");
        this.handledKeywords.put("exchange", "parseSwap");
        this.rulesHash.put("swap", "# swap the IDs of object 'id1' and 'id2'");
        this.rulesHash.put("exchange", "# see rule for 'swap'");
        this.rulesHash.put("id", "# Object ids are arbitrary strings placed in double quotes \"\"");
        this.rulesHash.put("int", "# an integer number, i.e. -10, 0, 42, ...");
        this.rulesHash.put("double", "# a double, i.e. -10.2, 3.14159, ...");
        this.rulesHash.put("nat", "# a natural number, i.e. 0, 1, 2, ...");
        this.rulesHash.put("nat+", "# a natural number greater than 0, i.e.1, 2, ...");
        this.rulesHash.put("dir", "# a compass needle point: NW, N, NE, W, C, CENTER, E, SW, S, SE");
        this.rulesHash.put("font", "# valid font names for all platforms are 'Serif', 'SansSerif' and 'Monospace'");
    }

    public boolean generateNewStep(String command) {
        return false;
    }

    public XProperties parseDelay() throws IOException {
        XProperties parsedProperties = new XProperties();
        int token = stok.nextToken();
        if (token != -3) {
            throw new IOException("keyword 'delay' expected!");
        }
        if (ParseSupport.parseOptionalWord(stok, "link delay mode `click on <id>'", "click")) {
            parsedProperties.put(DELAY_TYPE, DELAY_OBJECT_CLICK);
            ParseSupport.parseWord(stok, "link delay keyword `on'", "on");
            String refName = ParseSupport.parseText(stok, "link delay click target ID");
            int targetID = BaseAdminParser.getObjectIDs().getIntProperty(refName, -1);
            if (targetID != -1) {
                parsedProperties.put(DELAY_TARGET_ID, targetID);
            } else {
                parsedProperties.put(DELAY_TYPE, DELAY_KEY_PRESS);
                System.err.println("target ID \"" + refName + "\" unknown; replaced by key press delay.");
            }
        } else {
            parsedProperties.put(DELAY_TYPE, DELAY_TIME);
            parsedProperties.put(DELAY_TIME, ParseSupport.parseInt(stok, "link delay", 0));
            ParseSupport.parseOptionalWord(stok, "link delay unit 'ms'", "ms");
            parsedProperties.put(DELAY_UNIT, "ms");
        }
        producer.produceDelay(parsedProperties, currentLink);
        return parsedProperties;
    }

    public XProperties parseEcho() throws IOException {
        boolean success;
        XProperties parsedProperties = new XProperties();
        StringBuilder sb = new StringBuilder(80);
        sb.append("# ");
        ParseSupport.parseMandatoryWord(stok, "'echo' command", "echo");
        int token = stok.nextToken();
        String modeString = null;
        if (token == -3) {
            modeString = BaseAdminParser.stok.sval;
        } else {
            stok.pushBack();
        }
        boolean bl = success = modeString != null;
        if (modeString != null) {
            if ("location".equalsIgnoreCase(modeString)) {
                parsedProperties.put(ECHO_MODE, "location");
                ParseSupport.parseMandatoryChar(stok, "echo location colon ':'", ':');
                Point p = AnimalParseSupport.parseNodeInfo(stok, "echo location", null);
                parsedProperties.put(ECHO_LOCATION, p);
            } else if ("boundingBox".equalsIgnoreCase(modeString) || "bounds".equalsIgnoreCase(modeString)) {
                parsedProperties.put(ECHO_MODE, "boundingBox");
                ParseSupport.parseMandatoryChar(stok, "echo location colon ':'", ':');
                String[] oids = ParseSupport.parseOIDs(stok, BaseAdminParser.getObjectIDs(), true);
                parsedProperties.put(ECHO_BOUND_IDS, oids);
            } else if ("text".equalsIgnoreCase(modeString)) {
                ParseSupport.parseOptionalChar(stok, "echo text colon ':'", ':');
                parsedProperties.put(ECHO_MODE, "text");
                parsedProperties.put(ECHO_TEXT, AnimalParseSupport.parseText(stok, "echo text value"));
            } else if ("value".equalsIgnoreCase(modeString)) {
                ParseSupport.parseMandatoryChar(stok, "echo value colon ':'", ':');
                String[] oids = ParseSupport.parseOIDs(stok, BaseAdminParser.getObjectIDs(), false);
                parsedProperties.put(ECHO_MODE, "value");
                parsedProperties.put(ECHO_VALUE_IDS, oids);
            } else if ("ids".equalsIgnoreCase(modeString)) {
                ParseSupport.parseMandatoryChar(stok, "echo ids colon ':'", ':');
                String[] oids = ParseSupport.parseOIDs(stok, BaseAdminParser.getObjectIDs(), false);
                parsedProperties.put(ECHO_MODE, "ids");
                parsedProperties.put(ECHO_VALUE_IDS, oids);
            } else if ("visible".equalsIgnoreCase(modeString)) {
                parsedProperties.put(ECHO_MODE, "visible");
            } else if ("rule".equalsIgnoreCase(modeString)) {
                ParseSupport.parseMandatoryChar(stok, "echo rule colon ':'", ':');
                String rule = AnimalParseSupport.parseText(stok, "echo text value");
                parsedProperties.put(ECHO_MODE, "rule");
                parsedProperties.put(ECHO_RULE_NAME, rule);
                parsedProperties.put(ECHO_RULE_VALUE, this.getRuleFor(rule));
            } else {
                success = false;
            }
        }
        if (!success) {
            stok.pushBack();
            parsedProperties.put(ECHO_MODE, "text");
            parsedProperties.put(ECHO_TEXT, ParseSupport.consumeIncludingEOL(stok, "echo parameter"));
            stok.pushBack();
        }
        producer.produceEcho(parsedProperties, BaseAdminParser.getObjectIDs(), BaseAdminParser.getObjectProperties(), stok.lineno(), currentStep);
        return parsedProperties;
    }

    public XProperties parseGrouping() throws IOException {
        XProperties parsedProperties = new XProperties();
        String localType = ParseSupport.parseWord(stok, "Keyword 'group' | 'set' | 'merge'");
        parsedProperties.put(GROUP_TYPE, localType);
        boolean groupingMode = localType.equalsIgnoreCase("group") || localType.equalsIgnoreCase("merge") || localType.equalsIgnoreCase("set");
        parsedProperties.put(GROUP_MODE, groupingMode);
        parsedProperties.put(GROUP_ID, AnimalParseSupport.parseText(stok, "Grouping target ID"));
        parsedProperties.put(GROUP_TARGET_OIDS, ParseSupport.parseOIDs(stok, BaseAdminParser.getObjectIDs()));
        producer.produceGrouping(parsedProperties, BaseAdminParser.getObjectIDs(), anim.getNextGraphicObjectNum());
        return parsedProperties;
    }

    public XProperties parseLabel() throws IOException {
        if (currentLink == null) {
            BaseAdminParser.newLink();
        }
        XProperties parsedProperties = new XProperties();
        ParseSupport.parseWord(stok, "label keyword");
        parsedProperties.put(LABEL_ID, AnimalParseSupport.parseText(stok, "label text entry", null, false, chosenLanguage));
        producer.produceLabel(parsedProperties, currentLink);
        return parsedProperties;
    }

    public XProperties parseLocation() throws IOException {
        XProperties parsedProperties = new XProperties();
        String keyWords = ParseSupport.parseWord(stok, "defineLocation keyword");
        parsedProperties.put(LOCATION_ID, AnimalParseSupport.parseText(stok, "location ID"));
        if (keyWords.equalsIgnoreCase("moveLocation")) {
            ParseSupport.parseOptionalWord(stok, "move location keyword 'to'", "to");
        } else {
            ParseSupport.parseOptionalWord(stok, "define location keyword 'at'", "at");
        }
        parsedProperties.put(LOCATION_POINT, AnimalParseSupport.parseNodeInfo(stok, "target for location definition", null));
        producer.produceLocation(parsedProperties, BaseAdminParser.getLocations());
        return parsedProperties;
    }

    public XProperties parseSwap() throws IOException {
        XProperties parsedProperties = new XProperties();
        stok.nextToken();
        parsedProperties.put(SWAP_TYPE, BaseAdminParser.stok.sval);
        parsedProperties.put(SWAP_FIRST_OID, AnimalParseSupport.parseText(stok, "swap: first object name"));
        parsedProperties.put(SWAP_SECOND_OID, AnimalParseSupport.parseText(stok, "swap: second object name"));
        producer.produceSwap(parsedProperties, BaseAdminParser.getObjectIDs(), stok.lineno());
        return parsedProperties;
    }
}

