/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import translator.ExtendedResourceBundle;

public class ParseSupport {
    public static final int NODETYPE_ABSOLUTE = 0;
    public static final int NODETYPE_OFFSET_DIRECTION = 1;
    public static final int NODETYPE_OFFSET_NODE = 2;
    public static final int NODETYPE_OFFSET_MOVE = 4;
    public static final int NODETYPE_OFFSET_BASELINE = 8;
    protected static int token;
    protected static ExtendedResourceBundle bundle;
    protected static int errorCounter;

    static {
        errorCounter = 0;
    }

    public static void setResourceBundle(ExtendedResourceBundle theBundle) {
        bundle = theBundle;
    }

    public static String consumeIncludingEOL(StreamTokenizer stok, String description) throws IOException {
        StringBuilder sb = new StringBuilder();
        while ((token = stok.nextToken()) != -1 && token != 10) {
            if (token == -3) {
                sb.append(stok.sval);
            } else if (token == -2) {
                if ((double)((int)stok.nval) == stok.nval) {
                    sb.append((int)stok.nval);
                } else {
                    sb.append(stok.nval);
                }
            } else if (token == 34) {
                sb.append("\"").append(stok.sval).append("\"");
            } else {
                sb.append((char)token);
            }
            sb.append(' ');
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void formatException(String message, StreamTokenizer stok) throws StreamCorruptedException {
        StringBuilder sb = new StringBuilder(message);
        sb.append(", read '").append(stok.sval).append("'/").append(stok.nval);
        sb.append("/").append(stok.ttype).append(" at line ");
        sb.append(stok.lineno());
        throw new StreamCorruptedException(sb.toString());
    }

    public static void formatException2(String messagePattern, Object[] arguments) throws StreamCorruptedException {
        ParseSupport.incrementErrorCounter();
        MessageFormat format = new MessageFormat(ParseSupport.getMessagePattern(messagePattern));
        throw new StreamCorruptedException(format.format(arguments));
    }

    public static String getMessagePattern(String type) {
        return AnimalTranslator.getResourceBundle().getMessage(type);
    }

    public static boolean nextTokenIsNodeToken(StreamTokenizer stok) throws IOException {
        token = stok.nextToken();
        boolean result = token == 40 || token == -3 && (stok.sval.equalsIgnoreCase("offset") || stok.sval.equalsIgnoreCase("move"));
        stok.pushBack();
        return result;
    }

    public static boolean parseChar(StreamTokenizer stok, String description, char expectedChar) throws IOException {
        token = stok.nextToken();
        if (token == -2 || token == -3) {
            ParseSupport.formatException2("mandatoryWordNotFound", new Object[]{String.valueOf(expectedChar), description, stok.toString()});
        }
        return token == expectedChar;
    }

    public static void parseMandatoryChar(StreamTokenizer stok, String description, char expectedChar) throws IOException {
        token = stok.nextToken();
        if (token == -2 || token == -3) {
            ParseSupport.formatException2("wrongTypeError", new Object[]{"char", description, stok.toString()});
        }
        if (token != expectedChar) {
            ParseSupport.formatException2("mandatoryWordNotFound", new Object[]{String.valueOf(expectedChar), description, stok.toString()});
        }
    }

    public static Color parseColor(StreamTokenizer stok, String description) throws IOException {
        return ParseSupport.parseColor(stok, description, "color");
    }

    public static Color parseColor(StreamTokenizer stok, String description, String heading) throws IOException {
        ParseSupport.parseMandatoryWord(stok, "'color' for " + description + " " + heading, heading);
        return ParseSupport.parseColorRaw(stok, description);
    }

    public static Color parseColorRaw(StreamTokenizer stok, String description) throws IOException {
        ParseSupport.parseMandatoryChar(stok, "( for " + description + " color", '(');
        int r = ParseSupport.parseInt(stok, String.valueOf(description) + " R color value", 0, 255);
        ParseSupport.parseMandatoryChar(stok, "',' between " + description + " R/G color", ',');
        int g = ParseSupport.parseInt(stok, String.valueOf(description) + " G color value", 0, 255);
        ParseSupport.parseMandatoryChar(stok, "',' between " + description + " G/B color", ',');
        int b = ParseSupport.parseInt(stok, String.valueOf(description) + " B color value", 0, 255);
        ParseSupport.parseMandatoryChar(stok, ") for " + description + " color", ')');
        Color col = new Color(r, g, b);
        return col;
    }

    public static double parseDouble(StreamTokenizer stok, String description) throws IOException {
        return ParseSupport.parseDouble(stok, description, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public static double parseDouble(StreamTokenizer stok, String description, double minValue, double maxValue) throws IOException {
        token = stok.nextToken();
        double valueRead = 0.0;
        if (token == -2) {
            valueRead = stok.nval;
        } else if (token == 40) {
            valueRead = ParseSupport.parseDouble(stok, String.valueOf(description) + " expression L");
            int localToken = stok.nextToken();
            double secondValue = ParseSupport.parseDouble(stok, String.valueOf(description) + " expression R");
            if (localToken == 43) {
                valueRead += secondValue;
            } else if (localToken == 45) {
                valueRead -= secondValue;
            }
            if (localToken == 42) {
                valueRead *= secondValue;
            }
            if (localToken == 58 && secondValue != 0.0) {
                valueRead /= secondValue;
            }
            ParseSupport.parseMandatoryChar(stok, "')' for " + description + " expression", ')');
        }
        if (valueRead < minValue || valueRead > maxValue) {
            ParseSupport.formatException("double value for " + description + " expected inside [" + minValue + ", " + maxValue + "]", stok);
        }
        return valueRead;
    }

    public static double parseDoubleOLD(StreamTokenizer stok, String description, double minValue, double maxValue) throws IOException {
        double valueRead;
        token = stok.nextToken();
        if (token != -2) {
            ParseSupport.formatException("double value for " + description + " expected", stok);
        }
        if ((valueRead = stok.nval) < minValue || valueRead > maxValue) {
            ParseSupport.formatException("double value for " + description + " expected", stok);
        }
        return valueRead;
    }

    public static void parseMandatoryEOL(StreamTokenizer stok, String description) throws IOException {
        token = stok.nextToken();
        if (token != 10) {
            ParseSupport.formatException("EOL for " + description + " expected", stok);
        }
    }

    public static int parseInt(StreamTokenizer stok, String description) throws IOException {
        return ParseSupport.parseInt(stok, description, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int parseInt(StreamTokenizer stok, String description, int minValue) throws IOException {
        return ParseSupport.parseInt(stok, description, minValue, Integer.MAX_VALUE);
    }

    public static int parseInt(StreamTokenizer stok, String description, int minValue, int maxValue) throws IOException {
        return (int)Math.round(ParseSupport.parseDouble(stok, description, minValue, maxValue));
    }

    public static Point parseNode(StreamTokenizer stok, String description) throws IOException {
        ParseSupport.parseMandatoryChar(stok, "open brace for " + description, '(');
        int x = ParseSupport.parseInt(stok, String.valueOf(description) + " x value");
        ParseSupport.parseMandatoryChar(stok, "',' between " + description + " coords expected", ',');
        int y = ParseSupport.parseInt(stok, String.valueOf(description) + " y value");
        ParseSupport.parseMandatoryChar(stok, "open brace for " + description, ')');
        Point p = new Point(x, y);
        return p;
    }

    public static int[] parseObjectIDs(StreamTokenizer stok, String description) throws IOException {
        return ParseSupport.parseObjectIDs(stok, description, "by");
    }

    public static int[] parseObjectIDs(StreamTokenizer stok, String description, String keyword) throws IOException {
        Vector<Integer> targetObjects = new Vector<Integer>();
        StringBuilder msgBuffer = new StringBuilder(description);
        msgBuffer.append(" objects keyword ").append(keyword);
        String msg = msgBuffer.toString();
        while (!ParseSupport.parseOptionalWord(stok, msg, keyword) && stok.ttype != 10) {
            targetObjects.addElement(new Integer(ParseSupport.parseInt(stok, "Animator target ID")));
        }
        int n = targetObjects.size();
        int[] objectNums = new int[n];
        int i = 0;
        while (i < n) {
            objectNums[i] = (Integer)targetObjects.elementAt(i);
            ++i;
        }
        return objectNums;
    }

    public static String[] parseOIDs(StreamTokenizer stok, XProperties xprops) {
        return ParseSupport.parseOIDs(stok, xprops, true);
    }

    public static String[] parseOIDs(StreamTokenizer stok, XProperties xprops, boolean checkIDRegistry) {
        int oid = -1;
        String name = "";
        Vector<String> ids = new Vector<String>(50, 20);
        try {
            while ((token = stok.nextToken()) == 34) {
                name = stok.sval;
                if (checkIDRegistry && xprops.getProperty(name) == null) continue;
                ids.addElement(name);
            }
        }
        catch (IOException e) {
            System.err.println("Name: " + name + " OID: " + oid + " #:" + ids.size() + e.getMessage());
        }
        stok.pushBack();
        String[] result = new String[ids.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)ids.elementAt(i);
            ++i;
        }
        return result;
    }

    public static int[] parseOIDsFromString(String name) {
        int[] result = null;
        StringTokenizer stok = new StringTokenizer(name);
        int size = stok.countTokens();
        result = new int[size];
        int i = 0;
        while (i < size) {
            result[i] = Integer.parseInt(stok.nextToken());
            ++i;
        }
        if (result == null) {
            System.err.println("int[]-Property not found! " + name);
        }
        return result;
    }

    public static int[] parseOIDNames(StreamTokenizer stok, XProperties xprops, int nrObjects) {
        String[] oidNames = ParseSupport.parseOIDs(stok, xprops);
        return ParseSupport.expandIDsFromStrings(oidNames, xprops, nrObjects);
    }

    public static int[] expandIDsFromStrings(String[] ids, XProperties xprops, int nrLastElement) {
        int j;
        boolean[] usedIDs = new boolean[nrLastElement + 1];
        int nrEntries = 0;
        int i = 0;
        while (i < ids.length) {
            int[] firstElements = xprops.getIntArrayProperty(ids[i]);
            j = 0;
            while (j < firstElements.length) {
                if (!usedIDs[firstElements[j]]) {
                    ++nrEntries;
                }
                usedIDs[firstElements[j]] = true;
                ++j;
            }
            ++i;
        }
        int[] oids = new int[nrEntries];
        j = 0;
        i = 0;
        while (i < usedIDs.length) {
            if (usedIDs[i]) {
                oids[j++] = i;
            }
            ++i;
        }
        return oids;
    }

    public static int[] parseObjectIDsTillEOL(StreamTokenizer stok, String description) throws IOException {
        Vector<Integer> targetObjects = new Vector<Integer>();
        StringBuilder msgBuffer = new StringBuilder(description);
        msgBuffer.append(" objects EOL ");
        while ((token = stok.nextToken()) == -2) {
            targetObjects.addElement(new Integer((int)stok.nval));
        }
        int n = targetObjects.size();
        int[] objectNums = new int[n];
        int i = 0;
        while (i < n) {
            objectNums[i] = (Integer)targetObjects.elementAt(i);
            ++i;
        }
        return objectNums;
    }

    public static boolean parseOptionalChar(StreamTokenizer stok, String description, char expectedChar) throws IOException {
        boolean result;
        token = stok.nextToken();
        boolean bl = result = token == expectedChar;
        if (!result) {
            stok.pushBack();
        }
        return result;
    }

    public static double parseOptionalNumber(StreamTokenizer stok, String description) throws IOException {
        token = stok.nextToken();
        if (token == -2) {
            return stok.nval;
        }
        stok.pushBack();
        return Double.MAX_VALUE;
    }

    public static boolean parseOptionalWord(StreamTokenizer stok, String description, String expectedWord) throws IOException {
        boolean result;
        token = stok.nextToken();
        boolean bl = result = token == -3 && stok.sval.equalsIgnoreCase(expectedWord);
        if (!result) {
            stok.pushBack();
        }
        return result;
    }

    public static String parseText(StreamTokenizer stok, String description) throws IOException {
        token = stok.nextToken();
        if (token != 34) {
            ParseSupport.formatException("*** expected '\"' here for " + description, stok);
        }
        return stok.sval;
    }

    public static String parseText(StreamTokenizer stok, String description, String tag) throws IOException {
        return ParseSupport.parseText(stok, description, tag, true, null);
    }

    public static String parseText(StreamTokenizer stok, String description, String tag, boolean mandatoryTag) throws IOException {
        return ParseSupport.parseText(stok, description, tag, mandatoryTag, null);
    }

    public static String parseText(StreamTokenizer stok, String description, String tag, boolean mandatoryTag, String languageKey) throws IOException {
        if (tag != null) {
            if (mandatoryTag) {
                ParseSupport.parseMandatoryWord(stok, description, tag);
            } else {
                ParseSupport.parseOptionalWord(stok, description, tag);
            }
            ParseSupport.parseOptionalChar(stok, String.valueOf(description) + " colon ':'", ':');
        }
        token = stok.nextToken();
        String value = stok.sval;
        if (token == -3) {
            if (value.equalsIgnoreCase("key")) {
                ParseSupport.parseMandatoryChar(stok, "text entry key colon ':'", ':');
                token = stok.nextToken();
                String keyReadIn = null;
                if (token == 34) {
                    keyReadIn = stok.sval;
                }
                if (bundle != null) {
                    value = bundle.getMessage(keyReadIn);
                }
            } else if (value.equalsIgnoreCase("from")) {
                String filename = ParseSupport.parseText(stok, "text base file name");
                ParseSupport.parseMandatoryWord(stok, "text from file keywod 'line'", "line");
                int lineNumber = ParseSupport.parseInt(stok, "text from file line number", 0);
                int currentLineNr = -1;
                try {
                    FileInputStream fis = new FileInputStream(filename);
                    BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                    while ((value = br.readLine()) != null && currentLineNr < lineNumber) {
                        ++currentLineNr;
                    }
                    if (currentLineNr < lineNumber) {
                        System.err.println("file " + filename + " contained only lines [0, " + currentLineNr + "]!");
                    }
                }
                catch (IOException e) {
                    System.err.println("****" + e.getMessage());
                }
            }
        } else if (token == 40) {
            String langKey = null;
            String langText = null;
            while ((token = stok.nextToken()) != 41) {
                stok.pushBack();
                langKey = ParseSupport.parseWord(stok, "language key");
                ParseSupport.parseMandatoryChar(stok, String.valueOf(description) + " colon ':'", ':');
                langText = ParseSupport.parseText(stok, "language entry");
                if (!langKey.equalsIgnoreCase(languageKey)) continue;
                value = langText;
            }
        } else if (token != 34 && languageKey == null) {
            ParseSupport.formatException("*** expected '\"' here for " + description, stok);
        }
        return value;
    }

    public static String[] parseTexts(StreamTokenizer stok, String description, String tag, boolean mandatoryTag, String languageKey) throws IOException {
        Vector<String> elements = new Vector<String>(20);
        token = stok.nextToken();
        boolean inInternationalMode = languageKey != null && token == 40;
        stok.pushBack();
        while ((token = stok.nextToken()) == 34 || inInternationalMode && token != 41) {
            stok.pushBack();
            String element = ParseSupport.parseText(stok, description, tag, mandatoryTag, languageKey);
            elements.addElement(element);
        }
        stok.pushBack();
        Object[] results = new String[elements.size()];
        elements.copyInto(results);
        return results;
    }

    public static String parseTextTillEOL(StreamTokenizer stok, String description) throws IOException {
        StringBuilder textReadIn = new StringBuilder();
        token = stok.nextToken();
        textReadIn.append(stok.sval);
        token = stok.nextToken();
        if (token != 10) {
            ParseSupport.formatException("Expected an end of line here for parsing text till EOL", stok);
        }
        return textReadIn.toString();
    }

    public static String parseWord(StreamTokenizer stok, String description) throws IOException {
        token = stok.nextToken();
        if (token != -3) {
            ParseSupport.formatException("String value for " + description + " expected", stok);
        }
        return stok.sval;
    }

    public static boolean parseWord(StreamTokenizer stok, String description, String expectedWord) throws IOException {
        String wordReadIn = ParseSupport.parseWord(stok, description);
        return wordReadIn.equalsIgnoreCase(expectedWord);
    }

    public static void parseMandatoryWord(StreamTokenizer stok, String description, String expectedWord) throws IOException {
        String wordReadIn = ParseSupport.parseWord(stok, description);
        if (!wordReadIn.equalsIgnoreCase(expectedWord)) {
            ParseSupport.formatException2("mandatoryWordNotFound", new Object[]{expectedWord, description, stok.toString()});
        }
    }

    public static void skipLineTillEOL(StreamTokenizer stok, String description) throws IOException {
        boolean messageFlag = false;
        while ((token = stok.nextToken()) != 10) {
            messageFlag = true;
        }
        if (messageFlag) {
            MessageDisplay.message("Skipped entries in line " + stok.lineno() + " until EOL.");
        }
    }

    public static int getErrorCount() {
        return errorCounter;
    }

    public static void resetErrorCounter() {
        errorCounter = 0;
    }

    public static void incrementErrorCounter() {
        ParseSupport.addToErrorCounter(1);
    }

    public static void addToErrorCounter(int nrErrors) {
        if (nrErrors > 0) {
            errorCounter += nrErrors;
        }
    }

    public int nextToken(StreamTokenizer stok) {
        int currentToken = 0;
        try {
            currentToken = stok.nextToken();
            if (currentToken == 92) {
                currentToken = stok.nextToken();
                if (currentToken != 10) {
                    stok.pushBack();
                } else {
                    currentToken = stok.nextToken();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return currentToken;
    }
}

