/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColoredSquare;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;

public class AnimalColorChooserPanel
extends AbstractColorChooserPanel
implements ItemListener {
    private static final long serialVersionUID = -7326010372262725615L;
    private static int NOT_FOUND = -1;
    JComboBox comboBox;
    String[] labels = ColorChoice.getAllColorNames();

    private void setColor(Color newColor) {
        int position = this.findColorPosition(newColor);
        this.comboBox.setSelectedIndex(position);
    }

    private int findColorLabel(Object label) {
        String stringLabel = label.toString();
        int position = NOT_FOUND;
        int i = 0;
        int n = this.labels.length;
        while (i < n) {
            if (stringLabel.equals(this.labels[i])) {
                position = i;
                break;
            }
            ++i;
        }
        return position;
    }

    private int findColorPosition(Color color) {
        String colorName = ColorChoice.getColorName(color);
        return this.findColorLabel(colorName);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int position;
        int state = itemEvent.getStateChange();
        if (state == 1 && (position = this.findColorLabel(itemEvent.getItem())) != NOT_FOUND && position != this.labels.length - 1) {
            ColorSelectionModel selectionModel = this.getColorSelectionModel();
            selectionModel.setSelectedColor(ColorChoice.getColor(this.labels[position]));
        }
    }

    public String getDisplayName() {
        return AnimalTranslator.translateMessage("animalColors");
    }

    public Icon getSmallDisplayIcon() {
        return new ColoredSquare(Color.blue);
    }

    public Icon getLargeDisplayIcon() {
        return new ColoredSquare(Color.green);
    }

    protected void buildChooser() {
        this.comboBox = new JComboBox<String>(this.labels);
        this.comboBox.addItemListener(this);
        this.add(this.comboBox);
    }

    public void updateChooser() {
        Color color = this.getColorFromModel();
        this.setColor(color);
    }
}

