/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.editor.AnimatorEditor;
import animal.editor.Editor;
import animal.editor.GraphicEditor;
import animal.gui.DrawWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.misc.EditableObject;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ObjectPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 9175523615770554449L;
    private boolean graphicEditors;
    private JComboBox comboBox;
    private Hashtable<String, JButton> editorButtonTable;
    private Animal animal;
    private DrawWindow drawWindow;
    private ButtonGroup buttonGroup;
    private JToolBar toolBar;

    public ObjectPanel(Animal animalInstance, AnimalFrame parent, XProperties props, boolean usesGraphicEditors) {
        this.animal = animalInstance;
        if (usesGraphicEditors) {
            this.drawWindow = (DrawWindow)parent;
        }
        this.graphicEditors = usesGraphicEditors;
        this.setLayout(new FlowLayout(0));
        GridLayout l = this.graphicEditors ? new GridLayout(1, 0) : new GridLayout(0, 1);
        JPanel p = new JPanel(l);
        this.add(p);
        this.installEditors(this.animal);
        this.setProperties(props);
        this.add("North", this.toolBar);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void installEditors(Animal animalInstance) {
        if (this.comboBox == null) {
            this.comboBox = new JComboBox();
            this.comboBox.addItem("Specific Operations");
            this.comboBox.addActionListener(this);
        }
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(true);
            this.toolBar.getAccessibleContext().setAccessibleName(this.graphicEditors ? "Graphic primitives" : "Animators");
        } else {
            this.toolBar.removeAll();
        }
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        if (this.editorButtonTable == null) {
            this.editorButtonTable = new Hashtable(53);
        }
        Editor editor = null;
        JButton button = null;
        Hashtable<String, Editor> editors = this.animal.getEditors();
        int nrEditors = editors.size();
        Vector<String> dsSpecifics = new Vector<String>(57);
        int i = 0;
        while (i < nrEditors) {
            Enumeration<Editor> elems = editors.elements();
            while (elems.hasMoreElements()) {
                editor = elems.nextElement();
                if (editor == null) continue;
                String editorClassName = editor.getClass().getName();
                if (editor.getNum() != i || !this.isValidEditor(editor)) continue;
                if (editor instanceof GraphicObjectSpecificAnimation) {
                    String[] typeList;
                    String[] stringArray = typeList = ((GraphicObjectSpecificAnimation)((Object)editor)).getSupportedTypes();
                    int n = 0;
                    int n2 = stringArray.length;
                    while (n < n2) {
                        String element = stringArray[n];
                        dsSpecifics.addElement(String.valueOf(element) + ": " + editor.getName());
                        ++n;
                    }
                    continue;
                }
                if (this.editorButtonTable.containsKey(editorClassName)) {
                    button = this.editorButtonTable.get(editorClassName);
                    this.toolBar.add(button);
                    continue;
                }
                this.addButton(this.toolBar, String.valueOf(editor.getName()) + ".gif", editor.getName(), editorClassName, editor.getName());
            }
            ++i;
        }
        if (dsSpecifics.size() > 0) {
            Object[] dsElements = new String[dsSpecifics.size()];
            dsSpecifics.copyInto(dsElements);
            Arrays.sort(dsElements);
            String previousType = "-";
            Object[] objectArray = dsElements;
            int n = 0;
            int n3 = objectArray.length;
            while (n < n3) {
                Object key = objectArray[n];
                String localKey = ((String)key).substring(0, ((String)key).indexOf(58));
                if (!previousType.equals(localKey)) {
                    this.comboBox.addItem("=== " + localKey + " ===");
                    previousType = localKey;
                }
                this.comboBox.addItem(((String)key).substring(((String)key).indexOf(58) + 2));
                ++n;
            }
        }
        this.toolBar.add(this.comboBox);
    }

    public void addButton(JToolBar aToolBar, String iconName, String toolTipText, String className, String name) {
        JButton button = new JButton(this.animal.getImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setActionCommand(name);
        button.addActionListener(this);
        this.buttonGroup.add(button);
        this.editorButtonTable.put(className, button);
        aToolBar.add(button);
    }

    void setProperties(XProperties props) {
        Enumeration<Editor> e = this.animal.getEditors().elements();
        while (e.hasMoreElements()) {
            Editor ed = e.nextElement();
            if (!this.isValidEditor(ed)) continue;
            ed.createObject();
            ed.setProperties(props);
        }
    }

    boolean isValidEditor(Editor e) {
        return this.graphicEditors && e instanceof GraphicEditor || !this.graphicEditors && e instanceof AnimatorEditor;
    }

    public void getProperties(XProperties props) {
        Enumeration<Editor> e = this.animal.getEditors().elements();
        while (e.hasMoreElements()) {
            Editor ed = e.nextElement();
            if (!(ed instanceof GraphicEditor)) continue;
            ed.getProperties(props);
        }
    }

    public void setCurrentEditor(String name) {
        boolean found = false;
        if (name == null) {
            return;
        }
        Editor editor = this.animal.getEditor(name, false);
        if (editor instanceof GraphicObjectSpecificAnimation) {
            found = true;
        } else {
            Enumeration<AbstractButton> e = this.buttonGroup.getElements();
            while (e.hasMoreElements() && !found) {
                JButton rb = (JButton)e.nextElement();
                boolean thatsit = rb.getActionCommand().equals(name);
                rb.setSelected(thatsit);
                found |= thatsit;
            }
        }
        if (!found || editor == null) {
            MessageDisplay.errorMsg("illegalEditor", name, 8);
        } else if (this.graphicEditors) {
            editor.createObject();
            this.drawWindow.getDrawCanvas().setGraphicEditor((GraphicEditor)editor);
        } else {
            EditableObject a = editor.createObject();
            Editor se = a.getSecondaryEditor();
            se.setProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
            se.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object instanceof JButton) {
            this.setCurrentEditor(((JButton)object).getActionCommand());
        } else if (object instanceof JComboBox) {
            JComboBox box = (JComboBox)object;
            if (box.getSelectedIndex() > 0) {
                this.setCurrentEditor((String)box.getSelectedItem());
            }
            box.setSelectedIndex(0);
        }
    }

    protected ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }
}

