/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Vector;

public class AnimalResourceBundle {
    PropertyResourceBundle bundle = null;

    public AnimalResourceBundle() {
    }

    public AnimalResourceBundle(Locale locale) {
        this(locale, "AnimalResources");
    }

    public AnimalResourceBundle(Locale locale, String filename) {
        if (locale == null) {
            locale = Locale.US;
        }
        if (locale.getCountry() != null) {
            filename = String.valueOf(filename) + '.' + locale.getCountry();
        }
        InputStream in = null;
        in = this.getClass().getResourceAsStream(filename);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(filename);
        }
        if (in == null) {
            MessageDisplay.errorMsg("resourceNotFound", filename, 2);
        }
        try {
            if (in != null) {
                this.bundle = new PropertyResourceBundle(new BufferedInputStream(in));
            }
        }
        catch (IOException ioException) {
            MessageDisplay.errorMsg("resourceIOExc", new String[]{filename, ioException.getMessage()}, 2);
        }
    }

    public AnimalResourceBundle(String baseName, String languageCode) {
        String filename = String.valueOf(baseName) + '.' + languageCode;
        InputStream in = null;
        try {
            in = new FileInputStream(filename);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("resourceNotInDir", filename, 4);
        }
        if (in == null) {
            in = this.getClass().getResourceAsStream(filename);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(filename);
        }
        if (in == null) {
            MessageDisplay.errorMsg("resourceNotFound", filename, 2);
        }
        try {
            if (in != null) {
                this.bundle = new PropertyResourceBundle(new BufferedInputStream(in));
            }
        }
        catch (IOException ioException) {
            MessageDisplay.errorMsg("resourceIOExc", new String[]{filename, ioException.getMessage()}, 2);
        }
    }

    public String[] getKeys() {
        Vector<String> v = new Vector<String>(128);
        Enumeration<String> e = this.bundle.getKeys();
        while (e.hasMoreElements()) {
            v.addElement(this.bundle.getString(e.nextElement()));
        }
        String[] result = new String[v.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)v.elementAt(i);
            ++i;
        }
        return result;
    }

    public String getMessage(String key) {
        return this.getMessage(key, true);
    }

    public String getMessage(String key, boolean warnOnError) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException nullPointerException) {
            if (warnOnError) {
                MessageDisplay.errorMsg("resourceMissing", key, 8);
            }
            return null;
        }
    }

    public String printProperties() {
        if (this.bundle == null) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder(2048);
        Enumeration<String> e = this.bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            sbuf.append(AnimalTranslator.translateMessage("propPrint", new Object[]{key, this.bundle.getObject(key)}));
            sbuf.append("\n");
        }
        return sbuf.toString();
    }
}

