/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTLinkedElement;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedElementHandler
extends GraphicObjectHandler {
    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        PTLinkedElement LinkedElement = null;
        if (!(ptgo instanceof PTLinkedElement)) {
            return new Vector<String>();
        }
        LinkedElement = (PTLinkedElement)ptgo;
        if (obj instanceof Point) {
            result.addElement("translate");
            int nrPointers = 0;
            if (LinkedElement.getPointers() != null) {
                nrPointers = LinkedElement.getPointers().length;
            }
            if (nrPointers > 0) {
                result.addElement("setTip");
                result.addElement("translateWithFixedTip");
            }
        }
        if (obj instanceof Color) {
            result.addElement("text box frame & pointer color");
            result.addElement("fillColor");
            result.addElement("pointer box frame color");
            result.addElement("pointer background color");
            result.addElement("color");
            result.addElement("textcolor");
        }
        if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        PTLinkedElement linkedElement = null;
        if (ptgo instanceof PTLinkedElement) {
            linkedElement = (PTLinkedElement)ptgo;
            String what = e.getPropertyName();
            if (what.equalsIgnoreCase("setTip")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                if (linkedElement.getPointers() != null) {
                    linkedElement.setTip(0, MSMath.sum(linkedElement.getTip(0), diff));
                }
            } else if (what.equalsIgnoreCase("translate")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                linkedElement.translate(diff.x, diff.y);
            } else if (what.equalsIgnoreCase("translateWithFixedTip")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                linkedElement.translateWithFixedTips(diff.x, diff.y);
            } else if (what.equalsIgnoreCase("text box frame & pointer color")) {
                linkedElement.setColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("fillColor")) {
                linkedElement.setBoxFillColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("pointer box frame color")) {
                linkedElement.setPointerAreaColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("pointer background color") || what.equalsIgnoreCase("color")) {
                linkedElement.setPointerAreaFillColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("textcolor")) {
                linkedElement.setTextColor((Color)e.getNewValue());
            } else {
                super.propertyChange(ptgo, e);
            }
        }
    }
}

