/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.handler.GraphicObjectHandlerExtension;
import animal.misc.MSMath;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxPointerMoveMultiplePointers
extends GraphicObjectHandlerExtension {
    public BoxPointerMoveMultiplePointers() {
        this.type = "BoxPointer";
    }

    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        PTBoxPointer boxPointer = null;
        if (ptgo instanceof PTBoxPointer) {
            boxPointer = (PTBoxPointer)ptgo;
        }
        if (obj instanceof Point) {
            int nrPointers = 0;
            if (boxPointer.getPointers() != null) {
                nrPointers = boxPointer.getPointers().length;
            }
            if (nrPointers >= 1) {
                int a = 0;
                while (a < nrPointers) {
                    result.addElement("translateWithFixedTip #" + (a + 1));
                    ++a;
                }
                a = 0;
                while (a < nrPointers) {
                    result.addElement("setTip #" + (a + 1));
                    ++a;
                }
                result.addElement("setTips...");
                result.addElement("translateWithFixedTips...");
            }
        }
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        String what;
        PTBoxPointer boxPointer = null;
        if (ptgo instanceof PTBoxPointer) {
            boxPointer = (PTBoxPointer)ptgo;
        }
        if ((what = e.getPropertyName()).startsWith("translateWithFixedTip #")) {
            int num = Integer.parseInt(what.substring(23));
            boolean[] map = new boolean[boxPointer.getPointerCount()];
            map[num - 1] = true;
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            boxPointer.translateWithFixedTips(map, diff.x, diff.y);
        } else if (what.startsWith("setTip #")) {
            int num = Integer.parseInt(what.substring(8));
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            boxPointer.setTip(num - 1, MSMath.sum(boxPointer.getTip(num - 1), diff));
        } else if (what.startsWith("setTips ") || what.startsWith("translateWithFixedTips ")) {
            boolean setTipsMode = what.startsWith("setTips");
            StringTokenizer stringTok = new StringTokenizer(what.substring(setTipsMode ? 7 : 22));
            int nodeCount = boxPointer.getPointerCount();
            boolean[] map = new boolean[nodeCount];
            int currentNode = 0;
            while (stringTok.hasMoreTokens()) {
                currentNode = Integer.parseInt(stringTok.nextToken());
                if (currentNode <= 0 || currentNode > nodeCount) continue;
                map[currentNode - 1] = true;
            }
            Point old = (Point)e.getOldValue();
            Point now = (Point)e.getNewValue();
            Point diff = MSMath.diff(now, old);
            if (boxPointer.getPointers() != null) {
                if (setTipsMode) {
                    int a = 0;
                    while (a < boxPointer.getPointers().length) {
                        if (map[a]) {
                            boxPointer.setTip(a, MSMath.sum(boxPointer.getTip(a), diff));
                        }
                        ++a;
                    }
                } else {
                    boxPointer.translateWithFixedTips(map, diff.x, diff.y);
                }
            }
        }
    }
}

