/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.editor.Editor;
import animal.editor.GraphicEditor;
import animal.gui.DrawWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.ObjectSelectionButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import translator.TranslatableGUIElement;

public class ObjectToolbar
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = -8705707462029965359L;
    DrawWindow drawingWindow;
    private AbstractButton multiSelectionButton;
    private AbstractButton useEditorsButton;
    private HashMap<String, JButton> editorButtonTable;
    private ButtonGroup buttonGroup;
    private boolean oldMultiSelection;
    private boolean oldUseEditors;

    public ObjectToolbar(DrawWindow aDrawWindow) {
        super(1);
        this.drawingWindow = aDrawWindow;
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.add(this.buildSelectEditComponents(generator));
        this.addSeparator();
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        if (this.editorButtonTable == null) {
            this.editorButtonTable = new HashMap(53);
        }
        this.add(this.getFixedObjectsBox());
        this.addSeparator();
        this.add(this.installEditors());
    }

    private Box buildSelectEditComponents(TranslatableGUIElement generator) {
        Box contentBox = new Box(3);
        this.multiSelectionButton = generator.generateJButton("multiSelect", null, true, this);
        contentBox.add(this.multiSelectionButton);
        this.useEditorsButton = generator.generateJButton("showEdit", null, true, this);
        contentBox.add(this.useEditorsButton);
        return contentBox;
    }

    public Box getFixedObjectsBox() {
        Box contentBox = new Box(3);
        AnimalConfiguration config = Animal.getAnimalConfiguration();
        Hashtable<String, Editor> editors = config.getEditors();
        String[] stringArray = new String[13];
        stringArray[0] = "Point";
        stringArray[2] = "Text";
        stringArray[4] = "Polyline";
        stringArray[5] = "Square";
        stringArray[6] = "Rectangle";
        stringArray[7] = "Triangle";
        stringArray[9] = "Circle";
        stringArray[10] = "Arc";
        stringArray[12] = "BoxPointer";
        String[] predefined = stringArray;
        Editor editor = null;
        String[] stringArray2 = predefined;
        int n = 0;
        int n2 = stringArray2.length;
        while (n < n2) {
            String key = stringArray2[n];
            if (key != null) {
                editor = editors.get(key);
                this.installElement(editor.getClass().getName(), contentBox, editor);
            }
            ++n;
        }
        return contentBox;
    }

    public void installElement(String editorClassName, Box editorsBox, Editor editor) {
        if (!this.editorButtonTable.containsKey(editorClassName)) {
            String name = editor.getName();
            this.addButton(editorsBox, String.valueOf(name) + ".gif", name, editorClassName, name);
        }
    }

    public Box installEditors() {
        Box editorsBox = new Box(3);
        Editor editor = null;
        AnimalConfiguration config = Animal.getAnimalConfiguration();
        Hashtable<String, Editor> editors = config.getEditors();
        Enumeration<Editor> elems = editors.elements();
        while (elems.hasMoreElements()) {
            editor = elems.nextElement();
            if (editor == null) continue;
            String editorClassName = editor.getClass().getName();
            if (!(editor instanceof GraphicEditor) || this.editorButtonTable.containsKey(editorClassName)) continue;
            this.installElement(editorClassName, editorsBox, editor);
        }
        return editorsBox;
    }

    public void addButton(Box contentBox, String iconName, String toolTipText, String className, String name) {
        JButton button = new JButton(Animal.get().getImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setActionCommand(name);
        button.addActionListener(this);
        this.buttonGroup.add(button);
        this.editorButtonTable.put(className, button);
        contentBox.add(button);
    }

    void setSelection(boolean selection, boolean multiSelection, boolean useEditors, ObjectSelectionButton osb) {
        boolean enableButtons = selection && osb == null;
        this.multiSelectionButton.setEnabled(enableButtons);
        this.useEditorsButton.setEnabled(enableButtons);
        if (selection) {
            this.drawingWindow.getObjectPanel().setCurrentEditor(null);
        }
        this.drawingWindow.getDrawCanvas().setSelection(selection, multiSelection, useEditors, osb);
    }

    void setSelection(boolean selection) {
        this.setSelection(selection, this.multiSelectionButton.isSelected(), this.useEditorsButton.isSelected(), null);
    }

    void setExternalSelection(ObjectSelectionButton osb) {
        if (osb != null) {
            this.oldMultiSelection = this.multiSelectionButton.isSelected();
            this.oldUseEditors = this.useEditorsButton.isSelected();
            this.setSelection(true, osb.hasMultiSelection(), false, osb);
        } else {
            this.setSelection(true, this.oldMultiSelection, this.oldUseEditors, null);
        }
    }

    public void setCurrentEditor(JButton selectedButton) {
        if (selectedButton != null) {
            this.setCurrentEditor(selectedButton.getActionCommand());
            selectedButton.setSelected(true);
        }
    }

    public void setCurrentEditor(String name) {
        boolean found = false;
        if (name == null) {
            return;
        }
        Editor editor = Animal.get().getEditor(name, false);
        if (editor instanceof GraphicObjectSpecificAnimation) {
            found = true;
        } else {
            Enumeration<AbstractButton> e = this.buttonGroup.getElements();
            while (!found && e.hasMoreElements()) {
                JButton rb = (JButton)e.nextElement();
                boolean thatsit = name.equals(rb.getActionCommand());
                rb.setSelected(thatsit);
                found |= thatsit;
            }
        }
        if (!found || editor == null) {
            MessageDisplay.errorMsg("illegalEditor", name, 8);
        } else {
            editor.createObject();
            this.drawingWindow.getDrawCanvas().setGraphicEditor((GraphicEditor)editor);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.multiSelectionButton || object == this.useEditorsButton) {
            this.setSelection(true, this.multiSelectionButton.isSelected(), this.useEditorsButton.isSelected(), null);
        }
        if (object instanceof JButton) {
            this.setCurrentEditor(((JButton)object).getActionCommand());
        }
        if (object instanceof JMenuItem) {
            this.setCurrentEditor(((JMenuItem)object).getActionCommand());
        } else if (object instanceof JComboBox) {
            JComboBox box = (JComboBox)object;
            if (box.getSelectedIndex() > 0) {
                this.setCurrentEditor((String)box.getSelectedItem());
            }
            box.setSelectedIndex(0);
        }
    }

    public JPopupMenu createMenuFor(String objectType) {
        JPopupMenu popup = new JPopupMenu("Object Actions");
        JMenuItem item = null;
        item = new JMenuItem(objectType);
        item.addActionListener(this);
        popup.add(item);
        item = new JMenuItem("Dummy");
        item.addActionListener(this);
        popup.add(item);
        return popup;
    }
}

