/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.dialog.AboutDialog;
import animal.dialog.AnimInfoDialog;
import animal.dialog.HTMLDisplay;
import animal.dialog.HelpWindow;
import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.main.AnimationWindow;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import avinteraction.backend.AnimalEvalBackend;
import avinteraction.backend.BackendInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;

public class HelpMenuController
implements ActionListener {
    private HelpWindow tutorialWindow;

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if ("about".equals(command)) {
            AboutDialog.getAboutDialog(Animal.get()).setVisible(true);
        } else if ("animalscript".equals(command)) {
            HTMLDisplay animalScriptDisplay = new HTMLDisplay();
            String localeString = Animal.getCurrentLocale().toString();
            String baseURLString = "/animalScript";
            String targetURL = String.valueOf(baseURLString) + "_" + localeString + ".html";
            try {
                animalScriptDisplay.setURL(targetURL);
            }
            catch (MalformedURLException mfue) {
                MessageDisplay.errorMsg("URL malformed: " + targetURL, 4);
            }
            catch (IOException ioExc) {
                try {
                    animalScriptDisplay.setURL(String.valueOf(baseURLString) + ".html");
                }
                catch (Exception e) {
                    MessageDisplay.errorMsg("Could not access " + targetURL + "or " + baseURLString + ".html", 4);
                }
            }
        } else if ("animInfo".equals(command)) {
            AnimInfoDialog.getAnimInfoDialog(Animal.get()).setVisible(true);
        } else if ("quizResults".equals(command)) {
            Animation anim = Animal.get().getAnimation();
            BackendInterface quizBackend = anim.getInteractionBackend();
            if (quizBackend != null) {
                MessageDisplay.message(((AnimalEvalBackend)quizBackend).getResults());
            }
        } else if ("animWindowSize".equals(command)) {
            AnimationWindow aWin = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true);
            MessageDisplay.message(AnimalTranslator.translateMessage("animWinSizeIs", new Integer[]{aWin.getWidth(), aWin.getHeight()}));
        } else if ("tutorial".equals(command)) {
            if (this.tutorialWindow == null) {
                this.tutorialWindow = new HelpWindow(Animal.get(), AnimalConfiguration.getDefaultConfiguration().getProperties(), AnimalTranslator.translateMessage("tutorial.label"), AnimalTranslator.translateMessage("tutorialPath"));
            }
            this.tutorialWindow.setVisible(true);
        } else {
            MessageDisplay.errorMsg("nothingAssoc", command, 4);
        }
    }
}

