/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.editor.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.gui.GraphicVectorEntry;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.EditPoint;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JOptionPane;

public class GraphicVector {
    private static final int EDIT_POINT_SIZE = 6;
    private EditPoint editPoint;
    private Vector<GraphicVectorEntry> graphicObjects = new Vector();
    private boolean multiSelection = false;
    private boolean showTempObjects = true;
    private boolean useEditors = true;

    public void addElement(PTGraphicObject go, int mode) {
        if (go != null) {
            GraphicVectorEntry gve;
            if (mode == 4 && (gve = this.getGVEByNum(go.getNum(true))) != null) {
                gve.setTemporary(true);
                return;
            }
            gve = new GraphicVectorEntry(go, false, mode);
            this.graphicObjects.addElement(gve);
        }
    }

    public void addElement(GraphicVectorEntry gve) {
        this.graphicObjects.addElement(gve);
    }

    public GraphicVectorEntry elementAt(int index) {
        if (this.graphicObjects != null && this.graphicObjects.size() > index) {
            return this.graphicObjects.elementAt(index);
        }
        return null;
    }

    public GraphicVectorEntry[] convertToArray() {
        Object[] elems = new GraphicVectorEntry[this.graphicObjects.size()];
        this.graphicObjects.copyInto(elems);
        return elems;
    }

    public void heapsort(GraphicVectorEntry[] gve) {
        int n = gve.length - 1;
        if (gve.length > 1) {
            int k = n - gve.length % 2 >>> 1;
            while (k >= 0) {
                this.downheap(gve, k, n);
                --k;
            }
            while (n > 0) {
                GraphicVectorEntry tmp = gve[0];
                gve[0] = gve[n];
                gve[n] = tmp;
                this.downheap(gve, 0, --n);
            }
        }
    }

    public void downheap(GraphicVectorEntry[] gve, int innerNode, int nrElems) {
        int leftSon = (innerNode << 1) + 1;
        int rightSon = leftSon + 1;
        int maxPos = leftSon;
        if (leftSon <= nrElems) {
            if (rightSon <= nrElems && gve[rightSon].mustBeDrawnBefore(gve[leftSon])) {
                maxPos = rightSon;
            }
            if (gve[maxPos].mustBeDrawnBefore(gve[innerNode])) {
                GraphicVectorEntry tmp = gve[innerNode];
                gve[innerNode] = gve[maxPos];
                gve[maxPos] = tmp;
                this.downheap(gve, maxPos, nrElems);
            }
        }
    }

    public PTGraphicObject getGraphicObject(int index) {
        if (this.elementAt(index) != null) {
            return this.elementAt((int)index).go;
        }
        return null;
    }

    public GraphicVectorEntry getGVEByNum(int num) {
        int i = 0;
        while (i < this.graphicObjects.size()) {
            GraphicVectorEntry gve = this.elementAt(i);
            if (gve.go.getNum(false) == num) {
                return gve;
            }
            ++i;
        }
        return null;
    }

    public void removeAllElements() {
        this.deselectAll();
        this.graphicObjects.removeAllElements();
    }

    public boolean removeElement(PTGraphicObject go) {
        int i = 0;
        while (i < this.graphicObjects.size()) {
            if (this.getGraphicObject(i) == go && this.graphicObjects != null && this.graphicObjects.size() > i) {
                this.graphicObjects.removeElementAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    void deselectAll() {
        int a = 0;
        while (a < this.graphicObjects.size()) {
            this.elementAt(a).setSelected(false, this.useEditors);
            ++a;
        }
    }

    void deselectAllButTop() {
        boolean topFound = false;
        int a = this.graphicObjects.size() - 1;
        while (a >= 0) {
            GraphicVectorEntry e = this.elementAt(a);
            if (e.isSelected()) {
                if (topFound) {
                    e.setSelected(false, this.useEditors);
                } else {
                    topFound = true;
                }
            }
            --a;
        }
    }

    int getEditPointNum() {
        return this.editPoint.num;
    }

    Point getEditPointPos() {
        return new Point(this.editPoint.p);
    }

    GraphicVectorEntry getObjectAtEditPoint(Point p) {
        int b = this.getSize() - 1;
        while (b >= 0) {
            GraphicVectorEntry gve = this.elementAt(b);
            if (gve.selected) {
                EditPoint[] ep = ((GraphicEditor)gve.go.getEditor()).getEditPoints(gve.go);
                int mode = 0;
                while (mode < 2) {
                    int a = 0;
                    while (a < ep.length) {
                        if (mode == 0 && ep[a].num > 0 && Math.max(Math.abs(ep[a].p.x - p.x), Math.abs(ep[a].p.y - p.y)) < 3) {
                            this.editPoint = ep[a];
                            return gve;
                        }
                        if (mode == 1 && ep[a].num <= 0 && MSMath.dist(ep[a].p, p) < 6) {
                            this.editPoint = ep[a];
                            return gve;
                        }
                        ++a;
                    }
                    ++mode;
                }
            }
            --b;
        }
        return null;
    }

    int select(Point p, int tolerance) {
        int min = Integer.MAX_VALUE;
        GraphicVectorEntry next = null;
        int sel = 1;
        while (sel < 3) {
            int a = this.getSize() - 1;
            while (a >= 0) {
                int dist;
                GraphicEditor e;
                GraphicVectorEntry gve = this.elementAt(a);
                if ((sel == 1 && gve.isSelected() || sel == 2 && !gve.isSelected()) && (e = (GraphicEditor)gve.go.getEditor()) != null && (dist = e.getMinDist(gve.go, p)) < min) {
                    min = dist;
                    next = gve;
                }
                --a;
            }
            ++sel;
        }
        if (min > tolerance || next == null) {
            return -1;
        }
        this.select(next);
        return next.go.getNum(true);
    }

    void select(int[] objectNums, boolean isOSBInit) {
        if (objectNums == null) {
            return;
        }
        if (isOSBInit && objectNums != null && objectNums.length != 0) {
            this.deselectAll();
        }
        int a = 0;
        while (a < objectNums.length) {
            GraphicVectorEntry gve = this.getGVEByNum(objectNums[a]);
            if (isOSBInit) {
                if (gve != null) {
                    gve.setSelected(true, false);
                }
            } else {
                this.select(gve);
            }
            ++a;
        }
    }

    void select(GraphicVectorEntry gve) {
        if (!this.multiSelection) {
            this.deselectAll();
            if (gve != null) {
                gve.setSelected(true, this.useEditors);
            }
        } else if (gve != null) {
            gve.toggleSelected(this.useEditors);
        }
    }

    public void selectArea(Rectangle r) {
        if (r != null) {
            int i = 0;
            while (i < this.getSize()) {
                GraphicVectorEntry gve = this.elementAt(i);
                Rectangle bb = gve.go.getBoundingBox();
                if (r.intersects(bb)) {
                    gve.setSelected(true, this.useEditors);
                }
                ++i;
            }
        }
    }

    public void setSelectionMode(boolean select, boolean isMultiSelection, boolean usesEditors) {
        if (!select) {
            this.deselectAll();
            this.resetAllEditors();
        }
        if (usesEditors != this.useEditors) {
            this.setAllEditorsVisible(usesEditors);
        }
        if (isMultiSelection != this.multiSelection) {
            this.deselectAllButTop();
        }
        this.multiSelection = isMultiSelection;
        this.useEditors = usesEditors;
    }

    void drawAllBut(Graphics g, PTGraphicObject dontDrawThis) {
        GraphicVectorEntry[] gves = this.convertToArray();
        this.heapsort(gves);
        int a = gves.length - 1;
        while (a >= 0) {
            if (gves[a].go != dontDrawThis && this.isTempAllowed(gves[a])) {
                gves[a].go.paint(g);
            }
            --a;
        }
    }

    void drawAllBut(Graphics g, GraphicVector dontDrawThis) {
        int a = 0;
        while (a < this.getSize()) {
            GraphicVectorEntry gve = this.elementAt(a);
            if (!dontDrawThis.contains(gve) && this.isTempAllowed(gve)) {
                gve.go.paint(g);
            }
            ++a;
        }
    }

    void drawSelected(Graphics g) {
        GraphicVectorEntry[] gves = this.convertToArray();
        this.heapsort(gves);
        int b = gves.length - 1;
        while (b >= 0) {
            GraphicVectorEntry gve = gves[b];
            if (gve.selected && this.isTempAllowed(gve)) {
                gve.go.paint(g);
                EditPoint[] ep = ((GraphicEditor)gve.go.getEditor()).getEditPoints(gve.go);
                g.setColor(Color.black);
                int a = 0;
                while (a < ep.length) {
                    if (ep[a].num <= 0) {
                        g.drawOval(ep[a].p.x - 3, ep[a].p.y - 3, 6, 6);
                    } else {
                        g.drawRect(ep[a].p.x - 3, ep[a].p.y - 3, 6, 6);
                    }
                    ++a;
                }
                g.setColor(Color.gray);
                Rectangle r = gve.go.getBoundingBox();
                g.drawRect(r.x, r.y, r.width, r.height);
            }
            --b;
        }
    }

    void drawUnselected(Graphics g) {
        int b = 0;
        while (b < this.getSize()) {
            GraphicVectorEntry gve = this.elementAt(b);
            if (!gve.selected && this.isTempAllowed(gve)) {
                gve.go.paint(g);
            }
            ++b;
        }
    }

    private boolean isTempAllowed(GraphicVectorEntry gve) {
        return this.showTempObjects || !gve.isTemporary();
    }

    PTGraphicObject[] deleteSelected() {
        GraphicVectorEntry gve;
        Vector<PTGraphicObject> deleted = new Vector<PTGraphicObject>();
        int choice = 0;
        boolean animatedObjectsExist = false;
        int a = this.getSize() - 1;
        while (a >= 0) {
            gve = this.elementAt(a);
            Animation anim = Animation.get();
            int num = gve.go.getNum(false);
            if (gve.isSelected() && (anim.getAnimator(0, num, null) != null || anim.isUsedTemporarily(num, 0))) {
                animatedObjectsExist = true;
                break;
            }
            --a;
        }
        if (animatedObjectsExist) {
            Object[] options = new String[]{AnimalTranslator.translateMessage("selectAll"), AnimalTranslator.translateMessage("selectUnanimated"), AnimalTranslator.translateMessage("selectNothing")};
            choice = JOptionPane.showOptionDialog(AnimalMainWindow.getWindowCoordinator().getDrawWindow(false), AnimalTranslator.translateMessage("deleteWithSelected"), AnimalTranslator.translateMessage("deleteAnimators"), 0, 3, null, options, options[0]);
            if (choice == -1 || choice == 2) {
                return null;
            }
        }
        a = this.getSize() - 1;
        while (a >= 0) {
            gve = this.elementAt(a);
            if (gve.selected && (Animation.get().getAnimator(0, gve.go.getNum(false), null) == null || choice == 0)) {
                if (!gve.go.getEditor().isPrimaryEditor()) {
                    gve.go.getEditor().close();
                }
                this.graphicObjects.removeElementAt(a);
                Animation.get().deleteGraphicObject(gve.go.getNum(false));
                deleted.addElement(gve.go);
            }
            --a;
        }
        if (animatedObjectsExist) {
            AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false).initList(true);
        }
        Object[] result = new PTGraphicObject[deleted.size()];
        deleted.copyInto(result);
        return result;
    }

    void moveToBack() {
        int a = this.getSize() - 1;
        int counter = this.getSize() - 1;
        while (counter >= 0) {
            GraphicVectorEntry gve = this.elementAt(a);
            if (gve.selected) {
                this.graphicObjects.removeElementAt(a);
                this.graphicObjects.insertElementAt(gve, 0);
            } else {
                --a;
            }
            --counter;
        }
    }

    void moveToFront() {
        int a = 0;
        int counter = 0;
        while (counter < this.getSize()) {
            GraphicVectorEntry gve = this.elementAt(a);
            if (gve.selected) {
                this.graphicObjects.removeElementAt(a);
                this.graphicObjects.addElement(gve);
            } else {
                ++a;
            }
            ++counter;
        }
    }

    public int getSize() {
        return this.graphicObjects.size();
    }

    public void nextStep() {
        int i = this.getSize() - 1;
        while (i >= 0) {
            GraphicVectorEntry e = this.elementAt(i);
            if (e.isTemporary()) {
                this.graphicObjects.removeElementAt(i);
            }
            --i;
        }
    }

    public void resetAllEditors() {
        int a = 0;
        while (a < this.getSize()) {
            this.elementAt((int)a).go.resetEditor();
            ++a;
        }
    }

    public void setAllEditorsVisible() {
        this.setAllEditorsVisible(this.useEditors);
    }

    public void setAllEditorsVisible(boolean show) {
        int a = 0;
        while (a < this.getSize()) {
            GraphicVectorEntry gve = this.elementAt(a);
            if (gve.selected) {
                gve.setEditorVisible(show);
            }
            ++a;
        }
    }

    public void setShowTempObjects(boolean b) {
        this.showTempObjects = b;
    }

    public int[] getSelectedObjects() {
        int[] selected = new int[this.getSize()];
        int counter = 0;
        int a = 0;
        while (a < this.graphicObjects.size()) {
            if (this.elementAt(a).isSelected()) {
                selected[counter++] = this.elementAt((int)a).go.getNum(true);
            }
            ++a;
        }
        int[] result = new int[counter];
        int a2 = 0;
        while (a2 < counter) {
            result[a2] = selected[a2];
            ++a2;
        }
        return result;
    }

    public GraphicVector getSelectedObjectsVector() {
        GraphicVector result = new GraphicVector();
        int a = 0;
        while (a < this.graphicObjects.size()) {
            GraphicVectorEntry gve = this.elementAt(a);
            if (gve.isSelected()) {
                result.addElement(gve);
            }
            ++a;
        }
        return result;
    }

    public boolean contains(GraphicVectorEntry go) {
        return this.graphicObjects.contains(go);
    }
}

