/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.main.AnimationWindow;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.TranslatableGUIElement;

public class AnimationDisplayToolBar
extends JToolBar
implements ActionListener,
ChangeListener,
ItemListener {
    private static final long serialVersionUID = 7455622329770177673L;
    public static final String NORMALIZE_DISPLAY = "normalizeDisplay";
    public static final String NORMALIZE_SPEED = "normalizeSpeed";
    private AnimationWindow animationWindow;
    private JSlider displaySpeedSlider;
    private JSlider displayMagnificationSlider;
    public static final Double[] DEFAULT_ZOOM_FACTORS = new Double[]{new Double(0.1), new Double(0.2), new Double(0.25), new Double(0.33), new Double(0.5), new Double(0.66), new Double(0.71), new Double(0.9), new Double(1.0), new Double(1.2), new Double(1.25), new Double(1.33), new Double(1.41), new Double(1.5), new Double(2.0), new Double(2.5), new Double(3.0), new Double(4.0), new Double(5.0), new Double(10.0)};

    public AnimationDisplayToolBar(String title, AnimationWindow animWindow) {
        super(title);
        this.animationWindow = animWindow;
        if (this.animationWindow == null) {
            this.animationWindow = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true);
        }
        this.buildToolBar();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(NORMALIZE_SPEED)) {
            this.displaySpeedSlider.setValue(100);
            this.animationWindow.setSpeed(1.0);
        } else if (command.equals(NORMALIZE_DISPLAY)) {
            this.displayMagnificationSlider.setValue(100);
        } else {
            MessageDisplay.errorMsg("nothingAssoc", command, 4);
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.displayMagnificationSlider && !this.displayMagnificationSlider.getValueIsAdjusting()) {
            double factor = 0.01 * (double)this.displayMagnificationSlider.getValue();
            this.animationWindow.getAnimationCanvas().setMagnification(factor);
            this.displayMagnificationSlider.setToolTipText(AnimalTranslator.translateMessage("magnificationAW.toolTipText", new Object[]{String.valueOf(this.displayMagnificationSlider.getValue())}));
        } else if (source == this.displaySpeedSlider && !this.displaySpeedSlider.getValueIsAdjusting()) {
            double speed = 0.01 * (double)this.displaySpeedSlider.getValue();
            this.displaySpeedSlider.setToolTipText(AnimalTranslator.translateMessage("displaySpeed.toolTipText", new Object[]{String.valueOf(this.displaySpeedSlider.getValue())}));
            this.animationWindow.setSpeed(speed);
        }
    }

    private AbstractButton createButton(String key, boolean isToggle, ActionListener listener, String command) {
        AbstractButton helper = AnimalTranslator.getGUIBuilder().generateJButton(key, null, isToggle, listener);
        helper.setActionCommand(command);
        this.add(helper);
        return helper;
    }

    public void buildToolBar() {
        this.getAccessibleContext().setAccessibleName(AnimalTranslator.translateMessage("fileToolbar"));
        this.setFloatable(false);
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.displaySpeedSlider = generator.generateJSlider("displaySpeed", new Object[]{"100"}, 0, 1000, 100, 200, 10, false, this);
        this.add(this.displaySpeedSlider);
        this.add(this.createButton(NORMALIZE_SPEED, false, this, NORMALIZE_SPEED));
        this.addSeparator(new Dimension(20, 0));
        Box zoomBox = generator.generateBorderedBox(2, "zoomBoxBL");
        this.displayMagnificationSlider = AnimalTranslator.getGUIBuilder().generateJSlider("magnificationAW", new Object[]{"100"}, 0, 500, 100, 100, 50, false, this);
        zoomBox.add(this.displayMagnificationSlider);
        zoomBox.add(this.createButton(NORMALIZE_DISPLAY, false, this, NORMALIZE_DISPLAY));
        this.add(zoomBox);
    }

    public void itemStateChanged(ItemEvent arg0) {
        System.err.println("itemEvent: " + arg0);
    }
}

