/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;

public class PTText
extends PTGraphicObject
implements PropertyChangeListener {
    public static final String TYPE_LABEL = "Text";
    public static final String TEXT_BOLD = "Text.bold";
    public static final String TEXT_COLOR = "Text.color";
    public static final String TEXT_FONT = "Text.font";
    public static final String TEXT_FONT_NAME = "Text.fontName";
    public static final String TEXT_FONT_SIZE = "Text.fontSize";
    public static final String TEXT_FONT_STYLE = "Text.fontStyle";
    public static final String TEXT_ITALIC = "Text.italic";
    public static final String TEXT_ROTATE_ANGLE = "Text.angle";
    public static final String TEXT_ROTATE_CENTER = "Text.rotationCenter";
    public static final String TEXT_TEXT = "Text.text";
    public static final String TEXT_X_SCALE = "Text.xScale";
    public static final String TEXT_Y_SCALE = "Text.yScale";
    private static final long serialVersionUID = 5149137629050065454L;
    public static XProperties DefaultProperties;
    private Point location = new Point(0, 0);

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTText.extractDefaultProperties(properties, TYPE_LABEL);
    }

    public PTText() {
        if (DefaultProperties == null) {
            PTText.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
    }

    public PTText(String text, Font font) {
        this();
        this.setText(text);
        this.setFont(font);
    }

    public PTText(XProperties props) {
        this.setProperties(props);
        this.setLocation(this.getProperties().getPointProperty(this.mapKey("node")));
        this.setFont(new Font(this.getProperties().getProperty(this.mapKey(TEXT_FONT_NAME), "SansSerif"), this.getProperties().getIntProperty(this.mapKey(TEXT_FONT_STYLE), 0), this.getProperties().getIntProperty(this.mapKey(TEXT_FONT_SIZE), 12)));
    }

    public double getCurrentAngle() {
        return this.getProperties().getDoubleProperty(this.mapKey(TEXT_ROTATE_ANGLE));
    }

    public double getCurrentXScale() {
        return this.getProperties().getDoubleProperty(this.mapKey(TEXT_X_SCALE));
    }

    public double getCurrentYScale() {
        return this.getProperties().getDoubleProperty(this.mapKey(TEXT_Y_SCALE));
    }

    public int getFileVersion() {
        return 2;
    }

    public Font getFont() {
        return this.getProperties().getFontProperty(this.mapKey(TEXT_FONT));
    }

    public Point getLocation() {
        return this.location;
    }

    public String getText() {
        return this.getProperties().getProperty(this.mapKey(TEXT_TEXT), "");
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setColor(Color c) {
        this.getProperties().put(this.reverseMapKey(TEXT_COLOR), c);
    }

    public void setCurrentAngle(double angle) {
        this.getProperties().put(this.reverseMapKey(TEXT_ROTATE_ANGLE), angle);
    }

    public void setFont(Font f) {
        this.getProperties().put(this.reverseMapKey(TEXT_FONT), f);
    }

    public void setLocation(Point p) {
        this.location = p;
    }

    public void setText(String text) {
        this.getProperties().put(this.reverseMapKey(TEXT_TEXT), text);
    }

    public void paint(Graphics g) {
        boolean use2DRotate;
        boolean bl = use2DRotate = this.getCurrentAngle() != 0.0 && g instanceof Graphics2D;
        if (this.getText() != null && this.location != null) {
            g.setColor(this.getColor());
            g.setFont(this.getFont());
            if (use2DRotate) {
                ((Graphics2D)g).rotate(this.getCurrentAngle(), this.location.x, this.location.y);
            }
            g.drawString(this.getText(), this.location.x, this.location.y);
            if (use2DRotate) {
                ((Graphics2D)g).rotate(-this.getCurrentAngle());
            }
        }
    }

    public void rotate(double angle) {
        this.setCurrentAngle(angle);
    }

    public void rotate(double angle, PTPoint center) {
        this.translate(-center.getX(), -center.getY());
        this.rotate(angle);
        this.translate(center.getX(), center.getY());
    }

    public void scale(double scaleX, double scaleY) {
        Font currentFont = this.getFont();
        this.setFont(new Font(currentFont.getName(), currentFont.getStyle(), (int)Math.round((double)currentFont.getSize() * ((scaleX + scaleY) / 2.0))));
    }

    public void translate(int x, int y) {
        this.location.translate(x, y);
    }

    public Object clone() {
        PTText b = (PTText)super.clone();
        if (this.getText() != null) {
            b.setText(new String(this.getText()));
        }
        if (this.location != null) {
            b.location = new Point(this.location);
        }
        return b;
    }

    public Rectangle getBoundingBox() {
        int width = Animal.getStringWidth(this.getText(), this.getFont());
        FontMetrics fm = Animal.getConcreteFontMetrics(this.getFont());
        return new Rectangle(this.location.x, this.location.y - fm.getAscent(), width, fm.getAscent() + fm.getDescent());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30 + this.getText().length());
        sb.append("Text ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("{ '" + this.getText()).append("' at (").append(this.location.x);
        sb.append(", ").append(this.location.y).append(") }");
        return sb.toString();
    }

    public static String escapeText(String input) {
        if (input.indexOf("\"") == -1) {
            return new String(input);
        }
        StringBuilder sb = new StringBuilder(input.length() + 30);
        int start = 0;
        int end = input.indexOf("\"", start);
        while (end >= 0) {
            sb.append(input.substring(start, end));
            sb.append("\\\"");
            start = end + 1;
            end = input.indexOf("\"", start);
        }
        if (start < input.length()) {
            sb.append(input.substring(start));
        }
        return sb.toString();
    }

    public void discard() {
        this.location = null;
        this.setText(null);
        super.discard();
    }
}

