/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PolygonalShape;
import animal.main.AnimalConfiguration;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PTSquare
extends PolygonalShape
implements MoveBase {
    public static final String TYPE_LABEL = "Square";
    public static final String SQUARE_COLOR = "Square.color";
    public static final String SQUARE_FILL_COLOR = "Square.fillColor";
    public static final String SQUARE_FILLED = "Square.filled";
    private static final long serialVersionUID = 5793164474737251118L;
    public static XProperties DefaultProperties;
    private int size = 0;

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTSquare.extractDefaultProperties(properties, TYPE_LABEL);
    }

    public PTSquare() {
        if (DefaultProperties == null) {
            PTSquare.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
    }

    public PTSquare(Point node, int squareSize) {
        this(node.x, node.y, squareSize);
    }

    public PTSquare(int x, int y, int squareSize) {
        this.setFirstNode(x, y);
        this.size = squareSize;
    }

    public XProperties getDefaultProperties() {
        return DefaultProperties;
    }

    public int getFileVersion() {
        return 1;
    }

    public int getSize() {
        return this.size;
    }

    public int getNodeCount() {
        if (this.firstNode == null) {
            return 0;
        }
        return 2;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setSize(int newSize) {
        this.size = newSize;
    }

    public void scale(double scaleX, double scaleY) {
        Point node = this.getFirstNode();
        if (node != null && scaleX == scaleY) {
            node.x = (int)((double)node.x * scaleX);
            node.y = (int)((double)node.y * scaleY);
            this.size = (int)((double)this.size * scaleX);
        } else {
            MessageDisplay.errorMsg("invalidScaleFactor", new Double[]{scaleX, scaleY}, 4);
        }
    }

    public int getDifferentNodesCount() {
        return this.getNodeCount();
    }

    public void translate(int deltaX, int deltaY) {
        this.getFirstNode().translate(deltaX, deltaY);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(120);
        result.append("PTSquare ");
        String name = this.getObjectName();
        if (name != null) {
            result.append("\"").append(name).append("\" ");
        } else {
            result.append("\"").append(this.getNum(false)).append("\" ");
        }
        result.append(this.nodeToString(this.getFirstNode()));
        result.append("size ").append(this.size);
        return result.toString();
    }

    public Polygon toPolygon() {
        Point node = this.getFirstNode();
        if (node == null) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            int[] nArray2 = new int[2];
            nArray2[1] = 1;
            return new Polygon(nArray, nArray2, 2);
        }
        int[] xpoints = new int[]{node.x, node.x + this.size};
        int[] ypoints = new int[]{node.y, node.y + this.size};
        return new Polygon(xpoints, ypoints, 2);
    }

    public void paint(Graphics g) {
        int x = this.getFirstNode().x;
        int y = this.getFirstNode().y;
        int paintSize = this.size;
        if (this.size < 0) {
            x += this.size;
            y += this.size;
            paintSize = -this.size;
        }
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillRect(x, y, paintSize, paintSize);
        }
        g.setColor(this.color);
        g.drawRect(x, y, paintSize, paintSize);
    }

    public Object clone() {
        Point node = this.getFirstNode();
        if (node == null) {
            node = new Point(0, 0);
        }
        PTSquare p = new PTSquare(node.x, node.y, this.getSize());
        this.cloneCommonFeaturesInto(p);
        return p;
    }

    public int getLength() {
        return this.size * 4;
    }

    public Point getPointAtLength(int length) {
        int remainingLength = length;
        int nrSide = 0;
        while (remainingLength > this.size) {
            remainingLength -= this.size;
            ++nrSide;
        }
        nrSide %= 4;
        Point node = this.getFirstNode();
        if (node == null) {
            node = new Point(0, 0);
        }
        switch (nrSide) {
            case 1: {
                return new Point(node.x + this.size, node.y + remainingLength);
            }
            case 2: {
                return new Point(node.x + this.size - remainingLength, node.y);
            }
            case 3: {
                return new Point(node.x, node.y + this.size - remainingLength);
            }
        }
        return new Point(node.x + remainingLength, node.y);
    }

    public void useAsMoveBase() {
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.getFirstNode().x, this.getFirstNode().y, this.size, this.size);
    }

    public void discard() {
        super.discard();
    }
}

