/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.PropertyNameMapper;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;

public class PTLinkedElement
extends PTGraphicObject
implements PropertyChangeListener {
    public static final String TYPE_LABEL = "LINKEDELEMENT";
    public static final String LINKEDELEMENT_CLOSED = "LINKEDELEMENT.closed";
    public static final String LINKEDELEMENT_COLOR = "LINKEDELEMENT.color";
    public static final String LINKEDELEMENT_FILL_COLOR = "LINKEDELEMENT.fillColor";
    public static final String LINKEDELEMENT_FILLED = "LINKEDELEMENT.filled";
    public static final String LINKEDELEMENT_FONT = "LINKEDELEMENT.font";
    public static final String LINKEDELEMENT_FONT_NAME = "LINKEDELEMENT.fontName";
    public static final String LINKEDELEMENT_FONT_SIZE = "LINKEDELEMENT.fontSize";
    public static final String LINKEDELEMENT_FONT_STYLE = "LINKEDELEMENT.fontStyle";
    public static final String LINKEDELEMENT_LOCATION = "LINKEDELEMENT.location";
    public static final String LINKEDELEMENT_NR_POINTERS = "LINKEDELEMENT.nrPointers";
    public static final String LINKEDELEMENT_POINTER_AREA_COLOR = "LINKEDELEMENT.pointerAreaColor";
    public static final String LINKEDELEMENT_POINTER_AREA_FILL_COLOR = "LINKEDELEMENT.pointerAreaFillColor";
    public static final String LINKEDELEMENT_POINTER_POSITION = "LINKEDELEMENT.pointerPosition";
    public static final String LINKEDELEMENT_TEXT = "LINKEDELEMENT.text";
    public static final String LINKEDELEMENT_TEXT_COLOR = "LINKEDELEMENT.textColor";
    public static final String LINKEDELEMENT_TIP_POSITION = "LINKEDELEMENT.tipPosition";
    public static final int BOTTOM = 4;
    public static final int LEFT = 2;
    private static final Dimension MINIMUM_SIZE = new Dimension(40, 20);
    public static final int NONE = 0;
    private static final Point PADDING = new Point(5, 2);
    private static final int POINTER_PADDING = 10;
    public static final int RIGHT = 1;
    public static final int TOP = 3;
    private static final long serialVersionUID = 6082233834128917710L;
    public static XProperties DefaultProperties;
    private static PropertyNameMapper textMapper;
    private static PropertyNameMapper textBoxMapper;
    private static PropertyNameMapper pointerAreaMapper;
    private PTPolyline[] pointerArea;
    private PTPolyline[] pointers = null;
    private PTPolyline textBox;
    private PTText textComponent;

    static {
        textMapper = new PropertyNameMapper();
        textMapper.insertMapping("Text.font", LINKEDELEMENT_FONT);
        textMapper.insertMapping("Text.fontName", LINKEDELEMENT_FONT_NAME);
        textMapper.insertMapping("Text.fontSize", LINKEDELEMENT_FONT_SIZE);
        textMapper.insertMapping("Text.fontStyle", LINKEDELEMENT_FONT_STYLE);
        textMapper.insertMapping("Text.color", LINKEDELEMENT_TEXT_COLOR);
        textMapper.insertMapping("Text.text", LINKEDELEMENT_TEXT);
        textBoxMapper = new PropertyNameMapper();
        textBoxMapper.insertMapping("Polyline.color", LINKEDELEMENT_COLOR);
        textBoxMapper.insertMapping("Polyline.closed", LINKEDELEMENT_CLOSED);
        textBoxMapper.insertMapping("Polyline.filled", LINKEDELEMENT_FILLED);
        textBoxMapper.insertMapping("Polyline.fillColor", LINKEDELEMENT_FILL_COLOR);
        pointerAreaMapper = new PropertyNameMapper();
        pointerAreaMapper.insertMapping("Polyline.closed", LINKEDELEMENT_CLOSED);
        pointerAreaMapper.insertMapping("Polyline.filled", LINKEDELEMENT_FILLED);
        pointerAreaMapper.insertMapping("Polyline.color", LINKEDELEMENT_POINTER_AREA_COLOR);
        pointerAreaMapper.insertMapping("Polyline.fillColor", LINKEDELEMENT_POINTER_AREA_FILL_COLOR);
    }

    public PTLinkedElement() {
        if (DefaultProperties == null) {
            PTLinkedElement.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
        }
        this.setProperties((XProperties)DefaultProperties.clone());
    }

    public PTLinkedElement(int x, int y) {
        this(x, y, "");
    }

    public PTLinkedElement(int x, int y, String text) {
        XProperties props = new XProperties(DefaultProperties);
        props.put(this.mapKey(LINKEDELEMENT_LOCATION), new Point(x, y));
        props.put(this.mapKey(LINKEDELEMENT_CLOSED), true);
        props.put(this.mapKey(LINKEDELEMENT_FILLED), false);
        props.put(this.mapKey(LINKEDELEMENT_TEXT), text);
        this.setProperties(props);
    }

    public void setProperties(XProperties props) {
        Point location;
        if (props == null) {
            if (DefaultProperties == null) {
                PTLinkedElement.initializeDefaultProperties(AnimalConfiguration.getDefaultConfiguration().getProperties());
            }
            props = DefaultProperties;
        }
        super.setProperties(props);
        if (this.getProperties().getIntProperty(this.mapKey(LINKEDELEMENT_NR_POINTERS), 0) == 0) {
            this.makeNullPointer();
        }
        if ((location = this.getProperties().getPointProperty(this.mapKey(LINKEDELEMENT_LOCATION))) != null) {
            this.initTextBox(new Point[]{location});
        }
        this.initTextComponent();
        this.init(this.getProperties().getPointProperty(this.mapKey(LINKEDELEMENT_LOCATION), this.getOrigin()));
        this.setPointerCount(this.getProperties().getIntProperty(this.mapKey(LINKEDELEMENT_NR_POINTERS), 1));
        int nrPointers = this.getNrPointers();
        int i = 0;
        while (i < nrPointers) {
            Point targetPoint = this.getProperties().getPointProperty(this.mapKey("LINKEDELEMENT.tipPosition_" + i));
            this.setTipRelative(i, targetPoint.x, targetPoint.y);
            ++i;
        }
    }

    public PTLinkedElement(XProperties props) {
        this.setProperties(props);
    }

    public void init() {
        Point origin = this.getOrigin();
        this.init(origin.x, origin.y);
    }

    void init(int x, int y) {
        this.init(new Point(x, y));
    }

    void init(Point p) {
        int x = p.x;
        int y = p.y;
        FontMetrics f = Animal.getConcreteFontMetrics(this.getFont());
        int width = (this.getText() == null ? 0 : f.stringWidth(this.getText())) + PTLinkedElement.PADDING.x * 2;
        if (width < PTLinkedElement.MINIMUM_SIZE.width - 20) {
            width = PTLinkedElement.MINIMUM_SIZE.width - 20;
        }
        int right = x + width;
        int bottom = y + PTLinkedElement.MINIMUM_SIZE.height + f.getHeight() - 15;
        int textHeight = f.getHeight() + 5;
        if (textHeight < 5 || textHeight > 20) {
            textHeight = 13;
        }
        switch (this.getPointerPosition()) {
            case 3: {
                this.initPointerArea(x, y - textHeight, right, y);
                break;
            }
            case 4: {
                this.initPointerArea(x, bottom, right, bottom + textHeight);
                break;
            }
            case 2: {
                this.initPointerArea(x - 5 * this.getNrPointers(), y, x, bottom);
                break;
            }
            case 1: {
                this.initPointerArea(right, y, right + 5 * this.getNrPointers(), bottom);
                break;
            }
            default: {
                this.pointerArea = null;
            }
        }
        Point[] nodes = new Point[]{new Point(x, y), new Point(x, y + PTLinkedElement.MINIMUM_SIZE.height + f.getHeight() - 15), new Point(x + width, y + PTLinkedElement.MINIMUM_SIZE.height + f.getHeight() - 15), new Point(x + width, y)};
        this.initTextBox(nodes);
        if (this.pointerArea != null) {
            this.recalcPointerOrigins();
        }
    }

    Point calcPointerOrigin(int pointerNum) {
        int left = this.textBox.getNode(0).getX();
        int top = this.textBox.getNode(0).getY();
        int right = this.textBox.getNode(2).getX();
        int bottom = this.textBox.getNode(2).getY();
        int space = (pointerNum + 1) * 10;
        switch (this.getPointerPosition()) {
            case 3: {
                return new Point((left + right) / 2, top - space);
            }
            case 4: {
                return new Point((left + right) / 2, bottom + space);
            }
            case 2: {
                return new Point(left - space, (top + bottom) / 2);
            }
            case 1: {
                return new Point(right + space, (top + bottom) / 2);
            }
        }
        return new Point(0, 0);
    }

    public void makeNullPointer() {
        int count = this.getNrPointers();
        this.pointers = null;
        this.setPointerCount(count);
    }

    PTPolyline makeRectangle(int left, int top, int right, int bottom) {
        return new PTPolyline(new int[]{left, left, right, right, left}, new int[]{top, bottom, bottom, top, top});
    }

    public void recalcPointerOrigins() {
        if (this.pointers != null) {
            int a = 0;
            while (a < this.pointers.length) {
                this.pointers[a].setNode(0, new PTPoint(this.calcPointerOrigin(a)));
                ++a;
            }
        }
    }

    public PTPolyline getBox() {
        return this.textBox;
    }

    public Color getBoxFillColor() {
        return this.getFillColor();
    }

    public Rectangle getBoundingBox() {
        Rectangle r = this.getBoundingBoxWithoutPointers();
        if (this.pointerArea != null) {
            int nrPointers = this.pointerArea.length;
            int i = 0;
            while (i < nrPointers) {
                if (this.pointerArea[i] != null && this.getTip(i) != null) {
                    Point tip = this.getTip(i);
                    r = SwingUtilities.computeUnion(tip.x, tip.y, 0, 0, r);
                }
                ++i;
            }
        }
        return r;
    }

    public Rectangle getBoundingBoxWithoutPointers() {
        Rectangle r = this.textBox.getBoundingBox();
        if (this.pointerArea != null) {
            int nrPointers = this.pointerArea.length;
            int i = 0;
            while (i < nrPointers) {
                if (this.pointerArea[i] != null) {
                    Rectangle r2 = this.pointerArea[i].getBoundingBox();
                    r = SwingUtilities.computeUnion(r2.x, r2.y, r2.width, r2.height, r);
                }
                ++i;
            }
        }
        return r;
    }

    public Color getColor() {
        return this.getProperties().getColorProperty(this.mapKey(LINKEDELEMENT_COLOR));
    }

    public int getFileVersion() {
        return 6;
    }

    public Color getFillColor() {
        return this.getProperties().getColorProperty(this.mapKey(LINKEDELEMENT_FILL_COLOR));
    }

    public Font getFont() {
        return this.getProperties().getFontProperty(this.mapKey(LINKEDELEMENT_FONT));
    }

    public int getNrPointers() {
        return this.getProperties().getIntProperty(this.mapKey(LINKEDELEMENT_NR_POINTERS), 0);
    }

    public Point getOrigin() {
        if (this.textBox == null || this.textBox.getNode(0) == null) {
            return new Point(0, 0);
        }
        return this.textBox.getNode(0).toPoint();
    }

    public PTPolyline[] getPointerArea() {
        return this.pointerArea;
    }

    public PTPolyline getPointerArea(int areaIndex) {
        if (this.pointerArea != null && areaIndex >= 0 && areaIndex <= this.pointerArea.length) {
            return this.pointerArea[areaIndex];
        }
        return null;
    }

    public Color getPointerAreaColor() {
        return this.getProperties().getColorProperty(this.mapKey(LINKEDELEMENT_POINTER_AREA_COLOR));
    }

    public Color getPointerAreaFillColor() {
        return this.getProperties().getColorProperty(this.mapKey(LINKEDELEMENT_POINTER_AREA_FILL_COLOR));
    }

    public int getNrPointers22() {
        return this.pointers == null ? 0 : this.pointers.length;
    }

    public Point getPointerOrigin(int pointerNum) {
        if (this.pointers != null && pointerNum < this.pointers.length && pointerNum >= 0 && this.pointers[pointerNum] != null) {
            return this.pointers[pointerNum].getNode(0).toPoint();
        }
        return this.calcPointerOrigin(pointerNum);
    }

    public int getPointerPosition() {
        return this.getProperties().getIntProperty(this.mapKey(LINKEDELEMENT_POINTER_POSITION), 4);
    }

    public PTPolyline[] getPointers() {
        return this.pointers;
    }

    public Dimension getSize() {
        return MINIMUM_SIZE;
    }

    public String getText() {
        return this.getProperties().getProperty(this.mapKey(LINKEDELEMENT_TEXT));
    }

    public Color getTextColor() {
        return this.getProperties().getColorProperty(this.mapKey(LINKEDELEMENT_TEXT_COLOR), Color.black);
    }

    public PTText getTextComponent() {
        if (this.textComponent == null) {
            this.initTextComponent();
        }
        return this.textComponent;
    }

    public Point getTip(int pointerNum) {
        if (this.pointers == null || pointerNum < 0 || pointerNum >= this.pointers.length) {
            return null;
        }
        return this.pointers[pointerNum].getNode(1).toPoint();
    }

    public Point getTipOrigin(int pointerNum) {
        if (this.pointers == null || pointerNum < 0 || pointerNum >= this.pointers.length) {
            return null;
        }
        return this.pointers[pointerNum].getNode(0).toPoint();
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{"LinkedElement", "ListElement"};
    }

    public void initPointerArea(int baseLeft, int top, int baseRight, int bottom) {
        int nrPointers = this.getNrPointers();
        if (nrPointers <= 0) {
            return;
        }
        int averageWidth = (baseRight - baseLeft) / nrPointers;
        int left = baseLeft;
        int right = baseLeft + averageWidth;
        if (this.pointerArea == null) {
            this.pointerArea = new PTPolyline[nrPointers];
        }
        int i = 0;
        while (i < nrPointers) {
            if (this.pointerArea[i] == null) {
                this.pointerArea[i] = new PTPolyline(this.getProperties());
            } else {
                this.pointerArea[i].removeNodes();
            }
            this.pointerArea[i].addNode(new PTPoint(left, top));
            this.pointerArea[i].addNode(new PTPoint(left, bottom));
            this.pointerArea[i].addNode(new PTPoint(right, bottom));
            this.pointerArea[i].addNode(new PTPoint(right, top));
            this.pointerArea[i].addNode(new PTPoint(left, top));
            this.pointerArea[i].setPropertyNameMapper(pointerAreaMapper);
            this.pointerArea[i].setClosed(true);
            this.pointerArea[i].setFilled(true);
            this.pointerArea[i].setColor(this.getPointerAreaColor());
            this.pointerArea[i].setFillColor(this.getPointerAreaFillColor());
            left += averageWidth;
            right += averageWidth;
            if (i == nrPointers - 1) {
                right = baseRight;
            }
            ++i;
        }
    }

    public void initTextBox(Point[] nodes) {
        this.textBox = new PTPolyline(nodes);
        this.textBox.setProperties(this.getProperties());
        this.textBox.setPropertyNameMapper(textBoxMapper);
        this.textBox.setClosed(true);
        this.textBox.setFilled(true);
    }

    public void initTextComponent() {
        this.textComponent = new PTText(this.getProperties());
        this.textComponent.setPropertyNameMapper(textMapper);
        this.textComponent.setText("");
    }

    public static void initializeDefaultProperties(XProperties properties) {
        DefaultProperties = PTLinkedElement.extractDefaultProperties(properties, "LinkedElement");
    }

    private boolean isNullPointer(int i) {
        Point basePoint = this.getPointerOrigin(i);
        if (this.getPointerPosition() == 3 || this.getPointerPosition() == 4) {
            basePoint.translate(i % 2 == 0 ? 30 : -30, 0);
        } else {
            basePoint.translate(0, i % 2 == 0 ? 30 : -30);
        }
        return basePoint.equals(this.getTip(i));
    }

    public void setBoxFillColor(Color color) {
        this.setFillColor(color);
    }

    public void setColor(Color color) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_COLOR), color);
        if (this.pointers != null) {
            int a = 0;
            while (a < this.pointers.length) {
                this.pointers[a].setColor(color);
                ++a;
            }
        }
    }

    public void setFillColor(Color color) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_FILL_COLOR), color);
    }

    public void setFont(Font f) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_FONT_NAME), f.getFontName());
        this.getProperties().put(this.mapKey(LINKEDELEMENT_FONT_SIZE), f.getSize());
        this.getProperties().put(this.mapKey(LINKEDELEMENT_FONT_STYLE), f.getStyle());
        this.getProperties().put(this.mapKey(LINKEDELEMENT_FONT), f);
        this.init();
    }

    public void setFont(String fn) {
        this.setFont(new Font(fn, 0, 12));
    }

    public void setFont(String fn, int fontStyle, int fontSize) {
        this.setFont(new Font(fn, fontStyle, fontSize));
    }

    public void setLocation(Point p) {
        this.init(p);
        this.makeNullPointer();
    }

    public void setPointerAreaColor(Color color) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_POINTER_AREA_COLOR), color);
    }

    public void setPointerAreaFillColor(Color color) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_POINTER_AREA_FILL_COLOR), color);
    }

    public void setPointerCount(int pointerCount) {
        if (pointerCount == 0) {
            this.pointers = null;
        } else {
            int a;
            PTPolyline[] oldPointers = this.pointers;
            this.pointers = new PTPolyline[pointerCount];
            if (oldPointers != null) {
                a = 0;
                while (a < Math.min(oldPointers.length, pointerCount)) {
                    this.pointers[a] = oldPointers[a];
                    ++a;
                }
            }
            a = oldPointers != null ? oldPointers.length : 0;
            while (a < pointerCount) {
                int[] py;
                int[] px;
                Point p = this.calcPointerOrigin(a);
                int dx = p.x - this.getBoundingBoxWithoutPointers().x;
                int dy = p.y - this.getBoundingBoxWithoutPointers().y;
                if (this.getPointerPosition() == 3 || this.getPointerPosition() == 4) {
                    px = new int[]{p.x, p.x + (a % 2 == 0 ? dx : -dx)};
                    py = new int[]{p.y, p.y};
                } else {
                    px = new int[]{p.x, p.x};
                    py = new int[]{p.y, p.y + (a % 2 == 0 ? dy : -dy)};
                }
                this.pointers[a] = new PTPolyline(px, py);
                this.pointers[a].setObjectName(String.valueOf(this.getObjectName()) + ".pointer_" + a);
                this.pointers[a].setFWArrow(true);
                this.pointers[a].setClosed(false);
                this.pointers[a].setColor(this.getColor());
                ++a;
            }
        }
        this.init();
    }

    public void setPointerPosition(int pointerPosition) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_POINTER_POSITION), pointerPosition);
        this.init();
    }

    public void setText(String text) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_TEXT), text);
        this.init();
    }

    public void setTextColor(Color color) {
        this.getProperties().put(this.mapKey(LINKEDELEMENT_TEXT_COLOR), color);
    }

    public void setTip(int pointerNum, int tipX, int tipY) {
        Point p = this.getPointerOrigin(pointerNum);
        if (tipX == 0 && tipY == 0) {
            tipX = p.x;
            tipY = p.y + PTLinkedElement.MINIMUM_SIZE.height + PTLinkedElement.MINIMUM_SIZE.height / 2;
        }
        if (this.pointers != null && pointerNum < this.pointers.length && this.pointers[pointerNum] != null) {
            this.pointers[pointerNum].setNode(1, new PTPoint(tipX, tipY, 1));
            return;
        }
    }

    public void setTip(int pointerNum, Point p) {
        this.setTip(pointerNum, p.x, p.y);
    }

    public void setTipRelative(int pointerNum, int tipX, int tipY) {
        Point p = this.getPointerOrigin(pointerNum);
        if (tipX == 0 && tipY == 0) {
            tipX = p.x;
            tipY = p.y + PTLinkedElement.MINIMUM_SIZE.height + PTLinkedElement.MINIMUM_SIZE.height / 2;
        }
        if (this.pointers != null && pointerNum < this.pointers.length && this.pointers[pointerNum] != null) {
            this.pointers[pointerNum].setNode(1, new PTPoint(p.x + tipX, p.y + tipY, 1));
            return;
        }
    }

    public void setTipRelative(int pointerNum, Point p) {
        Point orig = this.getPointerOrigin(pointerNum);
        this.setTip(pointerNum, orig.x + p.x, orig.y + p.y);
    }

    public void setTips(boolean[] nodeMap, int tipX, int tipY) {
    }

    public void paint(Graphics g) {
        if (this.getOrigin().x == -1 && this.getOrigin().y == -1) {
            return;
        }
        this.textBox.paint(g);
        if (this.pointerArea != null) {
            int i = 0;
            while (i < this.pointerArea.length) {
                if (this.pointerArea[i] != null) {
                    this.pointerArea[i].paint(g);
                }
                ++i;
            }
            g.setColor(this.getColor());
            if (this.pointers != null) {
                i = 0;
                while (i < this.pointers.length) {
                    if (this.pointers[i] != null) {
                        this.pointers[i].paint(g);
                    }
                    ++i;
                }
            }
        }
        if (this.getText() != null) {
            g.setColor(this.getTextColor());
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            g.drawString(this.getText(), this.getOrigin().x + PTLinkedElement.PADDING.x, this.getOrigin().y + PTLinkedElement.PADDING.y + fm.getAscent());
        }
    }

    public void translate(int x, int y) {
        this.textBox.translate(x, y);
        if (this.pointerArea != null) {
            int nrPointers = this.pointerArea.length;
            int i = 0;
            while (i < nrPointers) {
                this.pointerArea[i].translate(x, y);
                ++i;
            }
        }
        if (this.pointers != null) {
            int i = 0;
            while (i < this.pointers.length) {
                this.pointers[i].translate(x, y);
                ++i;
            }
        }
    }

    public void translateWithFixedTips(boolean[] staticTips, int x, int y) {
        if (staticTips != null && this.pointers != null) {
            Point[] points = new Point[this.getNrPointers()];
            int i = 0;
            while (i < this.pointers.length) {
                points[i] = staticTips[i] ? this.getTip(i) : null;
                ++i;
            }
            this.translateWithFixedTips(points, x, y);
        } else {
            this.translate(x, y);
        }
    }

    public void translateWithFixedTips(Point[] tipsToKeep, int x, int y) {
        this.translate(x, y);
        int i = 0;
        while (i < this.pointers.length) {
            if (tipsToKeep[i] != null) {
                this.setTip(i, tipsToKeep[i]);
            }
            ++i;
        }
    }

    public void translateWithFixedTips(int x, int y) {
        if (this.pointers != null) {
            Point[] points = new Point[this.getNrPointers()];
            int i = 0;
            while (i < this.pointers.length) {
                points[i] = !this.isNullPointer(i) ? this.getTip(i) : null;
                ++i;
            }
            this.translateWithFixedTips(points, x, y);
        } else {
            this.translate(x, y);
        }
    }

    public Object clone() {
        PTLinkedElement b = (PTLinkedElement)super.clone();
        b.textBox = (PTPolyline)this.textBox.clone();
        if (this.pointerArea != null) {
            b.pointerArea = new PTPolyline[this.pointerArea.length];
            int nrPointers = this.pointerArea.length;
            int i = 0;
            while (i < nrPointers) {
                b.pointerArea[i] = (PTPolyline)this.pointerArea[i].clone();
                ++i;
            }
        }
        if (this.pointers != null) {
            b.pointers = new PTPolyline[this.pointers.length];
            int a = 0;
            while (a < this.pointers.length) {
                b.pointers[a] = (PTPolyline)this.pointers[a].clone();
                ++a;
            }
        }
        if (this.textComponent != null) {
            b.textComponent = (PTText)this.textComponent.clone();
        }
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("ListElement ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append(this.textBox.toString()).append(",");
        if (this.pointers != null) {
            sb.append(this.pointers.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean operationRequiresNodeSelector(String operation) {
        return operation != null && operation.indexOf("Tips") != -1;
    }

    public String baseOperationName(String methodName) {
        if (methodName.endsWith("...")) {
            return methodName.substring(0, methodName.indexOf(46));
        }
        if (methodName.indexOf("Tips") != 0) {
            return methodName.substring(0, methodName.indexOf(32));
        }
        return methodName;
    }

    public boolean enableMultiSelectionFor(String operation) {
        return operation != null && operation.indexOf("Tips") != -1;
    }

    public boolean compatibleMethod(String method) {
        return method != null && method.indexOf("Tips") != -1;
    }

    public void discard() {
        int i;
        this.textBox.discard();
        int nrPointers = 0;
        if (this.pointerArea != null) {
            nrPointers = this.pointerArea.length;
            i = 0;
            while (i < nrPointers) {
                this.pointerArea[i].discard();
                ++i;
            }
        }
        nrPointers = this.pointers.length;
        i = 0;
        while (i < nrPointers) {
            this.pointers[i].discard();
            this.pointers[i] = null;
            ++i;
        }
        this.setBoxFillColor(null);
        this.setPointerAreaColor(null);
        this.setPointerAreaFillColor(null);
        this.textComponent.discard();
        super.discard();
    }
}

