/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.main.Animal;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class PTArray
extends PTGraphicObject {
    public static XProperties DefaultProperties;
    protected Font myFont;
    protected FontMetrics fm;
    protected PTText[] entry;
    protected PTPolyline[] cells;
    protected boolean showIndices;
    protected final byte DEACTIVATED = 0;
    protected final byte ACTIVATED = 1;
    protected final byte HIGHLIGHTED = (byte)2;
    protected final byte ELEM_HIGHLIGHTED = (byte)4;
    protected byte[] states;
    protected int[] entryPos;
    protected Point origin;
    protected byte swapPercentage = 0;
    int[] swap = new int[]{-1, -1};
    public int length;

    public void setNum(int index, int cellID) {
        this.entry[index].setNum(cellID);
    }

    public void turnIndicesOff() {
        this.showIndices = false;
    }

    public void setDepth(int newDepth) {
        newDepth = newDepth < 2 ? 2 : newDepth;
        super.setDepth(newDepth);
        if (this.entry != null) {
            int i = 0;
            while (i < this.entry.length) {
                this.entry[i].setDepth(newDepth - 2);
                this.cells[i].setDepth(newDepth);
                ++i;
            }
        }
    }

    public void setActivated(int i, boolean state) {
        if (i >= 0 && i < this.states.length) {
            if (state) {
                this.states[i] = (byte)(this.states[i] | 1);
                this.cells[i].setFillColor(this.isHighlighted(i) ? this.getHighlightColor() : this.getBGColor());
                this.entry[i].setColor(this.isElemHighlighted(i) ? this.getElemHighlightColor() : this.getFontColor());
            } else {
                this.states[i] = (byte)(this.states[i] & 0xFFFFFFFE);
                this.cells[i].setFillColor(Color.GRAY);
                this.entry[i].setColor(Color.DARK_GRAY);
            }
        }
    }

    public boolean isActivated(int i) {
        if (i >= 0 && i < this.states.length) {
            return (this.states[i] & 1) == 1;
        }
        return false;
    }

    public void setHighlighted(int i, boolean state) {
        if (i >= 0 && i < this.states.length) {
            byte by = this.states[i] = state ? (byte)(this.states[i] | 2) : (byte)(this.states[i] & 0xFFFFFFFD);
            if (this.isActivated(i)) {
                this.cells[i].setFillColor(state ? this.getHighlightColor() : this.getBGColor());
            }
        }
    }

    public boolean isHighlighted(int i) {
        if (i >= 0 && i < this.states.length) {
            return (this.states[i] & 2) == 2;
        }
        return false;
    }

    public void setElemHighlighted(int i, boolean state) {
        if (i >= 0 && i < this.states.length) {
            byte by = this.states[i] = state ? (byte)(this.states[i] | 4) : (byte)(this.states[i] & 0xFFFFFFFB);
            if (this.isActivated(i)) {
                this.entry[i].setColor(state ? this.getElemHighlightColor() : this.getFontColor());
            }
        }
    }

    public boolean isElemHighlighted(int i) {
        if (i >= 0 && i < this.states.length) {
            return (this.states[i] & 4) == 4;
        }
        return false;
    }

    public void setLocation(Point p) {
        this.setOrigin(p);
    }

    public void setOrigin(Point p) {
        this.setOrigin(p.x, p.y);
    }

    public void setOrigin(int xpos, int ypos) {
        this.translate(xpos - this.origin.x, ypos - this.origin.y);
    }

    public abstract void setSize(int var1);

    public abstract int getSize();

    public abstract void setBGColor(Color var1);

    public abstract Color getBGColor();

    public abstract void setFont(Font var1);

    public abstract Font getFont();

    public abstract void setFontColor(Color var1);

    public abstract Color getFontColor();

    public abstract void setHighlightColor(Color var1);

    public abstract Color getHighlightColor();

    public abstract void setElemHighlightColor(Color var1);

    public abstract Color getElemHighlightColor();

    public abstract void setOutlineColor(Color var1);

    public abstract Color getOutlineColor();

    public int put(int index, PTText content) {
        this.showIndices = this.indicesShown();
        if (index >= 0 && index < this.entry.length) {
            this.entry[index] = content;
            int delta = index == 0 ? this.cellWidth(0) - this.entryPos[0] : this.cellWidth(index) - this.getBoundingBox((int)index).width;
            int i = index;
            while (i < this.entry.length) {
                int n = i++;
                this.entryPos[n] = this.entryPos[n] + delta;
            }
            return 0;
        }
        return -1;
    }

    public PTText getEntry(int index) {
        if (index >= 0 && index < this.entry.length) {
            this.entry[index].setNum(this.entry[index].getNum(true));
            return this.entry[index];
        }
        return null;
    }

    public PTPolyline getCell(int index) {
        if (index >= 0 && index < this.entry.length) {
            this.cells[index].setNum(this.cells[index].getNum(true));
            return this.cells[index];
        }
        return null;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.origin.x, this.origin.y, this.entryPos[this.entry.length - 1], this.fm.getAscent() + this.fm.getDescent() + 10);
    }

    public Rectangle getBoundingBox(int i) {
        if (i >= this.entry.length || i < 0) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (i == 0) {
            return new Rectangle(this.origin.x, this.origin.y, this.entryPos[0], this.fm.getAscent() + this.fm.getDescent() + 10);
        }
        return new Rectangle(this.origin.x + this.entryPos[i - 1], this.origin.y, this.entryPos[i] - this.entryPos[i - 1], this.fm.getAscent() + this.fm.getDescent() + 10);
    }

    public Rectangle[] getBoundingBoxes() {
        Rectangle[] bBoxes = new Rectangle[this.entryPos.length];
        int i = 0;
        while (i < this.entryPos.length) {
            bBoxes[i] = this.getBoundingBox(i);
            ++i;
        }
        return bBoxes;
    }

    public Point getArrowPoint(int i) {
        if (i == 0) {
            return new Point(this.origin.x + this.entryPos[0] / 2, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 15);
        }
        if (i > 0 && i < this.entry.length) {
            return new Point(this.origin.x + this.entryPos[i - 1] + (this.entryPos[i] - this.entryPos[i - 1]) / 2, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 15);
        }
        return new Point(-1, -1);
    }

    public void translate(int dx, int dy) {
        this.origin.x += dx;
        this.origin.y += dy;
        int i = 0;
        while (i < this.entry.length) {
            this.translate(i, dx, dy, true, true);
            ++i;
        }
    }

    public void translate(int[] index, int dx, int dy, boolean text, boolean cell) {
        if (index != null) {
            int idx = 0;
            while (idx < index.length) {
                this.translate(index[idx], dx, dy, text, cell);
                ++idx;
            }
        }
    }

    public void translate(int index, int dx, int dy, boolean text, boolean cell) {
        if (index >= 0 && index < this.entry.length) {
            if (text) {
                this.entry[index].translate(dx, dy);
            }
            if (cell) {
                this.cells[index].translate(dx, dy);
            }
        }
    }

    public void resizeCell(int index, int dx, boolean leftRight) {
        if (this.cells[index].getNodeCount() != 5) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("nodeCountError"), 8);
        } else if (leftRight) {
            boolean[] blArray = new boolean[5];
            blArray[0] = true;
            blArray[3] = true;
            blArray[4] = true;
            this.cells[index].translate(blArray, dx, 0);
        } else {
            boolean[] blArray = new boolean[5];
            blArray[1] = true;
            blArray[2] = true;
            this.cells[index].translate(blArray, dx, 0);
        }
    }

    public void resizeCell(int index, int dy) {
        if (this.cells[index].getNodeCount() != 5) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("nodeCountError"), 8);
        } else {
            boolean[] blArray = new boolean[5];
            blArray[2] = true;
            blArray[3] = true;
            this.cells[index].translate(blArray, 0, dy);
        }
    }

    public byte getSwapPercentage() {
        return this.swapPercentage;
    }

    public void setSwapPercentage(int p) {
        this.setSwapPercentage((byte)p);
    }

    public void setSwapPercentage(float p) {
        if (p >= 0.0f && p <= 1.0f) {
            this.setSwapPercentage((byte)(100.0f * p));
        } else {
            this.setSwapPercentage((byte)p);
        }
    }

    public void setSwapPercentage(byte p) {
        this.swapPercentage = (byte)Math.max(0, Math.min(100, p));
    }

    public void setSwapCells(int a, int b) {
        if (b != a) {
            if (b < a) {
                int x = a;
                a = b;
                b = x;
            }
            if (a < 0 || b >= this.entry.length) {
                this.swap[0] = -1;
                this.swap[1] = -1;
            } else {
                this.swap[0] = a;
                this.swap[1] = b;
            }
        } else {
            this.swap[0] = -1;
            this.swap[1] = -1;
        }
    }

    public void setSwapCells(int[] affectedCells) {
        if (affectedCells.length == 2) {
            this.setSwapCells(affectedCells[0], affectedCells[1]);
        }
    }

    public void doSwap(int first, int second) {
        if (first >= 0 && second < this.entry.length) {
            int diff = this.getBoundingBox((int)second).width - this.getBoundingBox((int)first).width;
            int j = first;
            while (j < second) {
                int n = j++;
                this.entryPos[n] = this.entryPos[n] + diff;
            }
            PTText tmp = this.entry[first];
            this.entry[first] = this.entry[second];
            this.entry[second] = tmp;
        }
        this.showIndices = this.indicesShown();
    }

    public Object clone() {
        PTArray array = (PTArray)super.clone();
        DefaultProperties = (XProperties)DefaultProperties.clone();
        array.clonePropertiesFrom(this.getProperties(), true);
        array.myFont = new Font(this.myFont.getName(), this.myFont.getStyle(), this.myFont.getSize());
        array.fm = Animal.getConcreteFontMetrics(this.fm.getFont());
        array.entryPos = new int[this.entryPos.length];
        array.entry = new PTText[this.entry.length];
        array.cells = new PTPolyline[this.cells.length];
        array.states = new byte[this.states.length];
        array.origin = (Point)this.origin.clone();
        int i = 0;
        while (i < this.entry.length) {
            array.entryPos[i] = this.entryPos[i];
            array.entry[i] = (PTText)this.entry[i].clone();
            array.cells[i] = (PTPolyline)this.cells[i].clone();
            array.states[i] = this.states[i];
            ++i;
        }
        return array;
    }

    public String toString() {
        String toString = new String();
        toString = this.getType();
        if (this.getObjectName() != null) {
            toString.concat(" '" + this.getObjectName() + "'");
        }
        toString.concat(" with " + this.entry.length + " entries (");
        int c = 0;
        while (c < this.entry.length) {
            toString.concat(this.entry[c].getText());
            if (c == this.entry.length - 1) {
                toString.concat(")");
            } else {
                toString.concat(", ");
            }
            ++c;
        }
        return toString;
    }

    public abstract void showIndices(boolean var1);

    public abstract boolean indicesShown();

    protected abstract void init(int var1);

    protected int cellWidth(int index) {
        if (this.entry[index] != null) {
            return this.entry[index].getBoundingBox().width + 10;
        }
        return 10;
    }

    protected int swapOffset(int index) {
        if (this.swap[0] < 0 || this.swap[1] >= this.entry.length || index <= this.swap[0] || index > this.swap[1]) {
            return 0;
        }
        return (this.cellWidth(this.swap[1]) - this.cellWidth(this.swap[0])) * this.getSwapPercentage() / 100;
    }

    protected int widthOffset(int index) {
        if (index == this.swap[0]) {
            return (this.cellWidth(this.swap[1]) - this.cellWidth(this.swap[0])) * this.getSwapPercentage() / 100;
        }
        if (index == this.swap[1]) {
            return (this.cellWidth(this.swap[0]) - this.cellWidth(this.swap[1])) * this.getSwapPercentage() / 100;
        }
        return 0;
    }

    protected Point upperSwapPoint() {
        PTPolyline pl = new PTPolyline();
        Rectangle a = this.getBoundingBox(this.swap[1]);
        Rectangle b = this.getBoundingBox(this.swap[0]);
        pl.addNode(new PTPoint(a.x + 5, a.y + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(a.x + 5, a.y - this.fm.getDescent() - 5));
        pl.addNode(new PTPoint(b.x + 5, b.y - this.fm.getDescent() - 5));
        pl.addNode(new PTPoint(b.x + 5, b.y + this.fm.getAscent() + 5));
        return pl.getPointAtLength(pl.getLength() * this.getSwapPercentage() / 100);
    }

    protected Point lowerSwapPoint() {
        PTPolyline pl = new PTPolyline();
        Rectangle a = this.getBoundingBox(this.swap[0]);
        Rectangle b = this.getBoundingBox(this.swap[1]);
        pl.addNode(new PTPoint(a.x + 5, a.y + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(a.x + 5, a.y + a.height + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(b.x + b.width - a.width + 5, b.y + b.height + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(b.x + b.width - a.width + 5, b.y + this.fm.getAscent() + 5));
        return pl.getPointAtLength(pl.getLength() * this.getSwapPercentage() / 100);
    }

    public void paint(Graphics g) {
        g.setFont(this.myFont);
        if (!this.getEditor().isVisible()) {
            this.setActivated(0, this.isActivated(0));
        }
        float[] hsb = Color.RGBtoHSB(this.getBGColor().getRed(), this.getBGColor().getGreen(), this.getBGColor().getBlue(), null);
        int index = 0;
        while (index < this.entry.length) {
            this.cells[index].paint(g);
            if (this.showIndices) {
                PTText idx = new PTText(String.valueOf(index), this.myFont);
                idx.setLocation(new Point(this.getBoundingBox((int)index).x + this.getBoundingBox((int)index).width - this.fm.stringWidth(String.valueOf(index)), this.getBoundingBox((int)index).y + this.getBoundingBox((int)index).height));
                idx.setDepth(this.getDepth() - 1);
                if ((double)hsb[2] > 0.5) {
                    if ((double)hsb[1] > 0.5) {
                        idx.setColor(Color.getHSBColor(hsb[0], hsb[1] - 0.1f, hsb[2]).darker());
                    } else {
                        idx.setColor(Color.getHSBColor(hsb[0], hsb[1] + 0.1f, hsb[2]).darker());
                    }
                } else if ((double)hsb[1] > 0.5) {
                    idx.setColor(Color.getHSBColor(hsb[0], hsb[1] - 0.1f, hsb[2]).brighter());
                } else {
                    idx.setColor(Color.getHSBColor(hsb[0], hsb[1] + 0.1f, hsb[2]).brighter());
                }
                idx.paint(g);
            }
            this.entry[index].paint(g);
            ++index;
        }
    }
}

