/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.animator.Animator;
import animal.exchange.AnimationImporter;
import animal.exchange.animalascii.AnimatorImporter;
import animal.exchange.animalascii.Importer;
import animal.exchange.animalascii.LinkImporter;
import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTGraphicObject;
import animal.main.Animal;
import animal.main.Animation;
import animal.main.Link;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;

public class AnimalASCIIImporter
extends AnimationImporter {
    private static Hashtable<String, Importer> asciiImporters = new Hashtable(73);
    protected Animal animal;
    private Animation animation;
    private boolean isCompressed = true;
    private XProperties objectIDMapper;
    private StreamTokenizer stok;

    public void init(String format) {
        super.init(format);
        this.isCompressed = format.endsWith("-compressed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Animation importAnimationFrom(String filename) {
        Animation anim = new Animation();
        InputStream in = null;
        if (filename == null) return new Animation();
        if (filename.equals("")) {
            return new Animation();
        }
        try {
            if (filename.startsWith("http:") || filename.startsWith("https:") || filename.startsWith("file:")) {
                URL targetURL = new URL(filename);
                if (targetURL == null) {
                    return null;
                }
                in = targetURL.openStream();
            } else {
                in = new FileInputStream(filename);
            }
            try {
                in = new GZIPInputStream(in);
            }
            catch (IOException e) {
                in.close();
                this.isCompressed = false;
                in = new FileInputStream(filename);
            }
            anim = this.importAnimationFrom(in, filename);
            in.close();
            return anim;
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("importException", new String[]{filename, e.getMessage()}, 4);
        }
        return anim;
    }

    public Animation importAnimationFrom(InputStream inStream, String filename) {
        try {
            if (filename != null && (filename.endsWith(".aml") || filename.endsWith(".animal")) && !(inStream instanceof GZIPInputStream)) {
                inStream = new GZIPInputStream(inStream);
            }
            InputStreamReader isr = new InputStreamReader(inStream);
            BufferedReader br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder(65536);
            String currentLine = null;
            while ((currentLine = br.readLine()) != null) {
                sb.append(currentLine).append("\n");
            }
            this.stok = new StreamTokenizer(new StringReader(sb.toString()));
            this.stok.eolIsSignificant(true);
            this.stok.quoteChar(34);
            if (this.animal == null) {
                this.animal = Animal.get();
            }
            this.animal.getEditors();
            this.objectIDMapper = new XProperties();
            long timeTaken = System.currentTimeMillis();
            this.animation = this.importAnim();
            if (this.animation == null) {
                this.animation = new Animation();
            }
            timeTaken = System.currentTimeMillis() - timeTaken;
            this.objectIDMapper = null;
            br.close();
            isr.close();
            MessageDisplay.message("loadedInIn", new String[]{String.valueOf(timeTaken)});
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("importException", new String[]{filename, e.getMessage()}, 4);
        }
        return this.animation;
    }

    protected Animation importAnim() {
        int fileID = 0;
        try {
            ParseSupport.parseMandatoryChar(this.stok, "#", '#');
        }
        catch (StreamCorruptedException scee) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("incorrectFormat"), 4);
            return null;
        }
        try {
            this.animation = new Animation();
            ParseSupport.parseMandatoryWord(this.stok, "Animal", "Animal");
            ParseSupport.parseMandatoryWord(this.stok, "protocol", "Protocol");
            int p_version = ParseSupport.parseInt(this.stok, "Protocol Version");
            if (p_version > 1) {
                throw new StreamCorruptedException(AnimalTranslator.translateMessage("invalidOrMissingProtocol", new String[]{String.valueOf(this.stok.nval)}));
            }
            if (ParseSupport.parseOptionalWord(this.stok, AnimalTranslator.translateMessage("animBoundingBox"), "size")) {
                try {
                    this.animation.setWidth(ParseSupport.parseInt(this.stok, "animation width", 0));
                    ParseSupport.parseMandatoryChar(this.stok, "animation bounding box '*'", '*');
                    this.animation.setHeight(ParseSupport.parseInt(this.stok, "animation height", 0));
                }
                catch (StreamCorruptedException e2) {
                    MessageDisplay.errorMsg("animBoundingBoxCorruptButNoMatter", new String[]{e2.getMessage()}, 4);
                }
            }
            ParseSupport.consumeIncludingEOL(this.stok, "Protocol line");
            if (ParseSupport.parseOptionalWord(this.stok, "Animation information keyword 'title'", "title")) {
                this.animation.setTitle(ParseSupport.parseText(this.stok, "Animation title"));
                ParseSupport.consumeIncludingEOL(this.stok, "Protocol line");
            }
            if (ParseSupport.parseOptionalWord(this.stok, "Animation information keyword 'author'", "author")) {
                this.animation.setAuthor(ParseSupport.parseText(this.stok, "Animation author"));
                ParseSupport.consumeIncludingEOL(this.stok, "Protocol line");
            }
            this.parseAndInsertGraphicObjects();
            ParseSupport.parseMandatoryWord(this.stok, "Link intro keyword 'STEPS'", "STEPS");
            ParseSupport.parseMandatoryChar(this.stok, "Link intro colon ':'", ':');
            ParseSupport.consumeIncludingEOL(this.stok, "Link intro ");
            int token = 0;
            while (!ParseSupport.parseOptionalWord(this.stok, "end", "Next")) {
                this.stok.pushBack();
                fileID = ParseSupport.parseInt(this.stok, "File version");
                if (ParseSupport.parseOptionalWord(this.stok, "Link component", "Link")) {
                    this.parseAndInsertLink(fileID);
                } else if (ParseSupport.parseOptionalWord(this.stok, "Step component", "Step")) {
                    this.parseAndInsertAnimator(fileID);
                } else {
                    MessageDisplay.errorMsg(String.valueOf(this.stok.sval) + "/" + this.stok.nval + "/" + this.stok.ttype + " @ line " + this.stok.lineno(), 4);
                }
                while ((token = this.stok.nextToken()) != 10 && token != -1) {
                }
            }
            int throwAway = ParseSupport.parseInt(this.stok, "next Graphic Object");
            this.animation.setNextGraphicObjectNum(throwAway + 1);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("******" + e.getMessage(), 4);
        }
        return this.animation;
    }

    private Importer getLocalImporterFor(String className) {
        try {
            if (!asciiImporters.containsKey(className)) {
                StringBuilder handlerName = new StringBuilder("animal.exchange.animalascii.");
                handlerName.append(className.substring(className.lastIndexOf(46) + 1));
                handlerName.append("Importer");
                String subName = handlerName.toString();
                Class<?> c = Class.forName(subName);
                Importer handler = (Importer)c.newInstance();
                asciiImporters.put(className, handler);
            }
        }
        catch (Exception e) {
            MessageDisplay.errorMsg(String.valueOf(e.getClass().getName()) + "**********" + e.getMessage(), 4);
        }
        return asciiImporters.get(className);
    }

    public void parseAndInsertAnimator(int version) {
        AnimatorImporter importer = null;
        Animator currentAnimator = null;
        Hashtable<String, String> registeredTypes = Animator.registeredHandlers;
        String objectName = null;
        try {
            this.stok.pushBack();
            ParseSupport.parseMandatoryWord(this.stok, "'Step'", "Step");
            int stepNr = ParseSupport.parseInt(this.stok, "Step number");
            objectName = ParseSupport.parseWord(this.stok, "Object type");
            if (registeredTypes.containsKey(objectName.toLowerCase())) {
                String targetType = registeredTypes.get(objectName.toLowerCase());
                try {
                    importer = (AnimatorImporter)this.getLocalImporterFor(targetType);
                    Object dummyObject = importer.importFrom(version, stepNr, this.stok);
                    currentAnimator = dummyObject instanceof Animator ? (Animator)dummyObject : null;
                }
                catch (Exception e) {
                    MessageDisplay.errorMsg("****" + e.getMessage() + " / " + e.toString(), 4);
                }
            } else {
                MessageDisplay.errorMsg("noSuchHandler", new Object[]{objectName.toLowerCase(), String.valueOf(this.stok.lineno())});
            }
            if (currentAnimator != null) {
                this.animation.insertAnimator(currentAnimator);
            }
            this.stok.pushBack();
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("******" + e.getMessage(), 4);
        }
    }

    public void parseAndInsertGraphicObjects() {
        PTGraphicObjectImporter importer = null;
        PTGraphicObject currentObject = null;
        Hashtable<String, String> registeredTypes = PTGraphicObject.registeredTypes;
        String objectName = null;
        try {
            while (this.stok.nextToken() != -3) {
                this.stok.pushBack();
                int fileID = ParseSupport.parseInt(this.stok, "File ID", 1);
                ParseSupport.parseMandatoryWord(this.stok, "'object'", "object");
                int objectID = ParseSupport.parseInt(this.stok, "Object ID", 1);
                objectName = ParseSupport.parseWord(this.stok, "Object type");
                if (registeredTypes.containsKey(objectName.toLowerCase())) {
                    String targetType = registeredTypes.get(objectName.toLowerCase());
                    try {
                        importer = (PTGraphicObjectImporter)this.getLocalImporterFor(targetType);
                        Object dummyObject = importer.importFrom(fileID, this.stok);
                        currentObject = dummyObject instanceof PTGraphicObject ? (PTGraphicObject)dummyObject : null;
                        ParseSupport.consumeIncludingEOL(this.stok, "++");
                    }
                    catch (Exception e) {
                        MessageDisplay.errorMsg("****" + e.getMessage() + " / " + e.toString(), 4);
                    }
                } else {
                    MessageDisplay.errorMsg("noSuchHandler", new Object[]{objectName.toLowerCase(), String.valueOf(this.stok.lineno())});
                    int token = -21;
                    while ((token = this.stok.nextToken()) != 10) {
                    }
                }
                if (currentObject == null) continue;
                currentObject.resetNum();
                currentObject.setNum(objectID);
                this.animation.insertGraphicObject(currentObject);
                this.objectIDMapper.put(String.valueOf(objectID), currentObject.getNum(false));
            }
            this.stok.pushBack();
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("******" + e.getMessage(), 4);
        }
    }

    public void parseAndInsertLink(int version) {
        LinkImporter linkImporter;
        Object linkObject;
        Importer importer = this.getLocalImporterFor("animal.main.Link");
        if (importer != null && importer instanceof LinkImporter && (linkObject = (linkImporter = (LinkImporter)importer).importFrom(version, this.stok)) != null && linkObject instanceof Link && ((Link)linkObject).getStep() != Integer.MAX_VALUE) {
            this.animation.insertLink((Link)linkObject);
        }
    }

    public String getDefaultExtension() {
        return this.isCompressed ? "aml" : "ama";
    }

    public String getMIMEType() {
        return "animation/animal-ascii" + (this.isCompressed ? "-compressed" : "");
    }

    public String getFormatDescription() {
        return this.toString();
    }

    public String toString() {
        return AnimalTranslator.translateMessage("asciiImportDescription");
    }
}

