/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.animator.Animator;
import animal.exchange.AnimationExporter;
import animal.exchange.animalascii.AnimatorExporter;
import animal.exchange.animalascii.Exporter;
import animal.exchange.animalascii.LinkExporter;
import animal.exchange.animalascii.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.main.Animal;
import animal.main.AnimationListEntry;
import animal.main.Link;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalASCIIExporter
extends AnimationExporter {
    protected Animal animal;
    private String extension = null;
    private boolean isCompressed = true;

    @Override
    public boolean exportAnimationTo(String fileName) {
        if (this.animal == null) {
            this.animal = Animal.get();
            this.animal.getEditors();
        }
        FilterOutputStream oStream = null;
        this.filename = fileName;
        String fileExtension = this.getDefaultExtension();
        if (!this.filename.endsWith(fileExtension)) {
            this.filename = String.valueOf(this.filename) + "." + fileExtension;
        }
        try {
            oStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            if (this.isCompressed) {
                oStream = new GZIPOutputStream(oStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDisplay.errorMsg(fileNotFoundException.getMessage(), 4);
        }
        catch (IOException ioException) {
            MessageDisplay.errorMsg(ioException.getMessage(), 4);
        }
        if (oStream == null) {
            return false;
        }
        return this.exportAnimationTo(oStream);
    }

    public boolean exportAnimationTo(OutputStream oStream) {
        Hashtable<String, Exporter> asciiExporters = new Hashtable<String, Exporter>(73);
        PrintWriter writer = new PrintWriter(oStream);
        writer.print("# Animal protocol ");
        writer.println(this.animationToExport.getFileVersion());
        Vector<PTGraphicObject> allGraphicObjects = this.animationToExport.getGraphicObjects();
        int nrGOs = allGraphicObjects.size();
        int i = 0;
        while (i < nrGOs) {
            this.exportGraphicObject(allGraphicObjects.elementAt(i), asciiExporters, writer);
            ++i;
        }
        writer.println("STEPS:");
        AnimationListEntry[] localinfo = this.animationToExport.getAnimatorList();
        if (localinfo != null) {
            i = 0;
            while (i < localinfo.length) {
                AnimationListEntry ali = localinfo[i];
                if (ali.mode == 1) {
                    this.exportAnimator(ali.animator, asciiExporters, writer);
                } else {
                    this.exportLink(ali.link, asciiExporters, writer);
                }
                ++i;
            }
        }
        writer.print("Next ");
        writer.println(this.animationToExport.getNextGraphicObjectNum());
        localinfo = null;
        writer.close();
        return true;
    }

    private void exportLink(Link link, Hashtable<String, Exporter> asciiExporters, PrintWriter writer) {
        String className = link.getClass().getName();
        StringBuilder handlerName = new StringBuilder("animal.exchange.animalascii.");
        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
        handlerName.append("Exporter");
        String subName = handlerName.toString();
        try {
            if (!asciiExporters.containsKey(subName)) {
                Class<?> c = Class.forName(subName);
                LinkExporter handler = (LinkExporter)c.newInstance();
                asciiExporters.put(subName, handler);
            }
            ((LinkExporter)asciiExporters.get(subName)).exportTo(writer, link);
        }
        catch (Exception e) {
            MessageDisplay.errorMsg("exportException", new String[]{subName, className, e.getMessage()}, 4);
        }
    }

    private void exportAnimator(Animator animator, Hashtable<String, Exporter> asciiExporters, PrintWriter writer) {
        String className = animator.getClass().getName();
        StringBuilder handlerName = new StringBuilder("animal.exchange.animalascii.");
        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
        handlerName.append("Exporter");
        String subName = handlerName.toString();
        try {
            if (!asciiExporters.containsKey(subName)) {
                Class<?> c = Class.forName(subName);
                AnimatorExporter handler = (AnimatorExporter)c.newInstance();
                asciiExporters.put(subName, handler);
            }
            ((AnimatorExporter)asciiExporters.get(subName)).exportTo(writer, animator);
        }
        catch (Exception e) {
            MessageDisplay.errorMsg("exportException", new String[]{subName, className, e.getMessage()}, 4);
        }
    }

    private void exportGraphicObject(PTGraphicObject ptgo, Hashtable<String, Exporter> asciiExporters, PrintWriter writer) {
        String className = ptgo.getClass().getName();
        String subName = null;
        try {
            if (!asciiExporters.containsKey(className)) {
                StringBuilder handlerName = new StringBuilder("animal.exchange.animalascii.");
                handlerName.append(className.substring(className.lastIndexOf(46) + 1));
                handlerName.append("Exporter");
                subName = handlerName.toString();
                Class<?> c = Class.forName(subName);
                PTGraphicObjectExporter handler = (PTGraphicObjectExporter)c.newInstance();
                asciiExporters.put(className, handler);
            }
            PTGraphicObjectExporter localHandler = (PTGraphicObjectExporter)asciiExporters.get(className);
            localHandler.exportTo(writer, ptgo);
        }
        catch (Exception e) {
            MessageDisplay.errorMsg("exportException", new String[]{subName, className, e.getMessage()}, 4);
        }
    }

    @Override
    public String getDefaultExtension() {
        return this.isCompressed ? "aml" : "ama";
    }

    @Override
    public String getFormatDescription() {
        return this.isCompressed ? AnimalTranslator.translateMessage("asciiFormatGzip") : AnimalTranslator.translateMessage("asciiFormat");
    }

    @Override
    public String getMIMEType() {
        if (this.isCompressed) {
            return "animation/animal-ascii-compressed";
        }
        return "animation/animal-ascii";
    }

    @Override
    public void init(String format) {
        super.init(format);
        this.extension = format.substring(format.indexOf(47) + 1);
        this.isCompressed = this.extension.endsWith("compressed");
        this.exportCapabilities = 7;
    }

    @Override
    public String toString() {
        return AnimalTranslator.translateMessage("asciiExportDescription");
    }
}

