/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.properties;

import animal.editor.properties.PropertyEditor;
import animal.main.PropertiedObject;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import translator.Translator;

public class PropEditor
implements ActionListener {
    public static final String EDITORS_FILENAME = "properties.cfg";
    public static final String EDITOR_PATH = "animal.editor.";
    XProperties editors = null;
    JFrame frame;
    PropertiedObject currentComponent;
    PropertyEditor[] realEditors = null;

    public void buildFrameFor(String type, PropertiedObject component) {
        if (!this.editors.containsKey(type)) {
            MessageDisplay.errorMsg("noSuchKeyException", new Object[]{type});
            return;
        }
        this.currentComponent = component;
        XProperties subEditors = (XProperties)this.editors.get(type);
        String orderOfComponents = subEditors.getProperty("order", "");
        StringTokenizer stok = new StringTokenizer(orderOfComponents);
        this.realEditors = new PropertyEditor[stok.countTokens()];
        int i = 0;
        this.frame = new JFrame();
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new GridLayout(0, 2));
        while (stok.hasMoreTokens()) {
            String currentKey = stok.nextToken().trim();
            XProperties localProps = (XProperties)subEditors.get(currentKey);
            PropertyEditor localEditor = (PropertyEditor)localProps.get("editor");
            localEditor.setTargetObject(component);
            localEditor.addEditorTo(contentPane);
            this.realEditors[i++] = localEditor;
        }
        AnimalTranslator.setTranslatorLocale(Translator.DEFAULT_LOCALE);
        contentPane.add(AnimalTranslator.getGUIBuilder().generateJButton("ok", null, false, this));
        contentPane.add(AnimalTranslator.getGUIBuilder().generateJButton("cancel", null, false, this));
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.frame.setVisible(false);
        this.frame.dispose();
        int i = 0;
        while (i < this.realEditors.length) {
            if (this.realEditors[i] != null) {
                this.realEditors[i].storeProperty();
            }
            ++i;
        }
        System.exit(0);
    }

    public JComponent getEditComponent() {
        return new JLabel(this.getClass().getName());
    }

    public void addEditorTo(Container container) {
        container.add(new JLabel(this.getClass().getName()));
        container.add(AnimalTranslator.getGUIBuilder().generateJLabel("noValueAssigned"));
    }

    public XProperties getEditors() {
        XProperties newEditors = new XProperties();
        XProperties localHash = new XProperties();
        XProperties propertyHash = null;
        String s = null;
        String key = "UNKNOWN";
        String className = "";
        Class[] constructorParams = new Class[]{key.getClass(), newEditors.getClass()};
        try {
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(EDITORS_FILENAME);
            }
            catch (FileNotFoundException notFoundException) {
                inputStream = ClassLoader.getSystemResourceAsStream(EDITORS_FILENAME);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((s = br.readLine()) != null) {
                if (s == null || s.length() == 0) continue;
                if (s.indexOf(58) == s.trim().length() - 1) {
                    if (localHash.size() != 0) {
                        newEditors.put((Object)key, localHash);
                    }
                    key = s.trim().substring(0, s.length() - 1);
                    localHash = new XProperties();
                    continue;
                }
                int startPos = 0;
                int nextSpacePos = s.indexOf(32, startPos);
                String component = s.substring(startPos, nextSpacePos);
                String currentEntry = null;
                String property = null;
                startPos = nextSpacePos + 1;
                className = EDITOR_PATH + Character.toUpperCase(component.charAt(0)) + component.substring(1) + "PropertyEditor";
                propertyHash = new XProperties();
                propertyHash.put("type", component.toLowerCase());
                int pos = 0;
                do {
                    if (s.charAt(startPos) == '\"') {
                        nextSpacePos = s.indexOf(34, startPos + 1);
                        currentEntry = nextSpacePos != -1 ? s.substring(startPos + 1, nextSpacePos) : s.substring(startPos + 1, s.length() - 1);
                        ++nextSpacePos;
                    } else {
                        nextSpacePos = s.indexOf(32, startPos);
                        currentEntry = nextSpacePos != -1 ? s.substring(startPos, nextSpacePos) : s.substring(startPos);
                    }
                    startPos = nextSpacePos + 1;
                    if (pos == 0) {
                        property = currentEntry;
                        propertyHash.put("property", currentEntry);
                        localHash.put("order", String.valueOf(localHash.getProperty("order", "")) + " " + currentEntry);
                    } else {
                        propertyHash.put("param" + (pos - 1), currentEntry);
                    }
                    ++pos;
                } while (nextSpacePos != -1 && startPos < s.length());
                localHash.put((Object)property, propertyHash);
                try {
                    Class<?> c = Class.forName(className);
                    Constructor<?> constructor = c.getDeclaredConstructor(constructorParams);
                    Object ed = constructor.newInstance(key, propertyHash);
                    propertyHash.put((Object)"editor", ed);
                }
                catch (ClassNotFoundException e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("classNotFound", new String[]{className, e.getMessage()}), 4);
                }
                catch (InstantiationException e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("errorInstantiating", new String[]{className, e.getMessage()}), 4);
                }
                catch (InvocationTargetException e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("invocTExc", new String[]{className, e.getMessage()}), 4);
                }
                catch (NoSuchMethodException e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("nsmEx", new String[]{className, e.getMessage()}), 4);
                }
                catch (IllegalAccessException e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("illegalAccessExc", new String[]{className, e.getMessage()}), 4);
                }
                catch (IllegalArgumentException e) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("illegalArgumentExc", new String[]{className, e.getMessage()}), 4);
                }
            }
            if (!newEditors.containsKey(key)) {
                newEditors.put((Object)key, localHash);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("fileNotFoundExc", new String[]{className, e.getMessage()}), 4);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("ioException", new String[]{className, e.getMessage()}), 4);
        }
        this.editors = newEditors;
        return newEditors;
    }
}

