/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.Rotate;
import animal.editor.Editor;
import animal.editor.TimedAnimatorEditor;
import animal.graphics.PTPoint;
import animal.misc.AnimalTranslator;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RotateEditor
extends TimedAnimatorEditor {
    private static final long serialVersionUID = -3355178488198635871L;
    private ObjectSelectionButton center;
    private JTextField degreesTF;

    public RotateEditor() {
        JPanel c = new JPanel(new FlowLayout(0));
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("rotationCenterLabel"));
        this.center = new ObjectSelectionButton(false);
        c.add(this.center);
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("rotationDegreesLabel"));
        this.degreesTF = new JTextField(5);
        c.add(this.degreesTF);
        this.addLayer(c);
        this.finish();
    }

    public void setProperties(XProperties props) {
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        Rotate rotate = (Rotate)eo;
        this.center.setObjectNum(rotate.getCenterNum());
        this.setInt(this.degreesTF, rotate.getDegrees());
    }

    public void storeAttributesInto(EditableObject rotate) {
        super.storeAttributesInto(rotate);
        ((Rotate)rotate).setCenterNum(this.center.getObjectNum());
        ((Rotate)rotate).setDegrees(this.getInt(this.degreesTF.getText(), 0));
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        RotateEditor result = new RotateEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        Rotate r = new Rotate();
        this.storeAttributesInto(r);
        return r;
    }

    String isOK() {
        String result = super.isOK();
        if (result != null) {
            return result;
        }
        this.center.checkObjects();
        int num = this.center.getObjectNum();
        if (num == 0) {
            return AnimalTranslator.translateMessage("rotationNoCenter");
        }
        if (!(RotateEditor.getGraphicObject(num) instanceof PTPoint)) {
            return AnimalTranslator.translateMessage("rotationCenterNotPoint");
        }
        return null;
    }
}

