/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.HighlightEdge;
import animal.editor.Editor;
import animal.editor.TimedAnimatorEditor;
import animal.graphics.PTGraph;
import animal.graphics.PTGraphicObject;
import animal.misc.AnimalTranslator;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HighlightEdgeEditor
extends TimedAnimatorEditor
implements GraphicObjectSpecificAnimation {
    private static final long serialVersionUID = -5352350893227202431L;
    private int commonLength = -1;
    private JPanel hlContent;
    private JScrollPane scp;
    public GridBagConstraints hlC = new GridBagConstraints(-1, 1, 1, 1, 0.5, 0.5, 17, 0, new Insets(0, 0, 0, 0), 5, 0);
    private static final String CELL_LABEL = "affectedEdges";

    public HighlightEdgeEditor() {
        this.hlContent = new JPanel(new GridLayout(5, 5, 5, 0));
        this.scp = new JScrollPane(this.hlContent, 21, 30);
        this.scp.setRowHeaderView(AnimalTranslator.getGUIBuilder().generateJLabel(CELL_LABEL));
        this.scp.setMaximumSize(new Dimension(400, 300));
        this.addLayer(this.scp);
        this.finish();
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getSource() instanceof ObjectSelectionButton) {
            if (this.objectNums != null && this.objectNums.length > 0) {
                this.commonLength = -1;
                int now = 0;
                int i = 0;
                while (i < this.objectNums.length) {
                    int[] elements = ((ObjectSelectionButton)e.getSource()).getObjectNums();
                    if (elements != null && elements.length > i) {
                        now = elements[i];
                    }
                    int length = -1;
                    if (HighlightEdgeEditor.getGraphicObject(now) instanceof PTGraph) {
                        length = ((PTGraph)HighlightEdgeEditor.getGraphicObject((int)now)).length;
                    }
                    if (this.commonLength == -1 || length > this.commonLength) {
                        this.commonLength = length;
                    }
                    ++i;
                }
                if (this.commonLength == -1) {
                    this.hlContent.removeAll();
                } else {
                    this.hlContent.removeAll();
                    int x = 0;
                    while (x < this.commonLength) {
                        int y = 0;
                        while (y < this.commonLength) {
                            this.hlContent.add(new JCheckBox(String.valueOf(String.valueOf(x)) + "-" + String.valueOf(y), false), this.hlC, x * this.commonLength + y);
                            ++y;
                        }
                        ++x;
                    }
                }
            } else {
                this.commonLength = -1;
                this.hlContent.removeAll();
            }
            if ((double)this.scp.getWidth() > this.scp.getMaximumSize().getWidth()) {
                this.scp.getViewport().setViewSize(this.scp.getMaximumSize());
            }
        }
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        HighlightEdge hl = (HighlightEdge)eo;
        PTGraphicObject ao = null;
        if (this.objectNums != null && this.objectNums.length > 0) {
            int i = 0;
            while (i < this.objectNums.length) {
                if (this.objectSB.getObjectNums() != null) {
                    ao = HighlightEdgeEditor.getGraphicObject(this.objectSB.getObjectNums()[i]);
                }
                int length = -1;
                if (ao instanceof PTGraph) {
                    length = ((PTGraph)ao).length;
                }
                if (this.commonLength == -1 || length > this.commonLength) {
                    this.commonLength = length;
                }
                ++i;
            }
            this.hlContent.removeAll();
            int x = 0;
            while (x < this.commonLength) {
                int y = 0;
                while (y < this.commonLength) {
                    this.hlContent.add(new JCheckBox(String.valueOf(String.valueOf(x)) + "-" + String.valueOf(y), hl.getHighlightState(x, y)), this.hlC, x * this.commonLength + y);
                    ++y;
                }
                ++x;
            }
        }
        this.scp.setViewportView(this.hlContent);
    }

    public void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        HighlightEdge hl = (HighlightEdge)eo;
        if (this.commonLength > 0) {
            boolean[][] highlightState = new boolean[this.commonLength][this.commonLength];
            int x = 0;
            while (x < this.commonLength) {
                int y = 0;
                while (y < this.commonLength) {
                    highlightState[x][y] = ((JCheckBox)this.hlContent.getComponent(x * this.commonLength + y)).isSelected();
                    ++y;
                }
                ++x;
            }
            hl.setHighlightState(highlightState);
        }
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        HighlightEdgeEditor result = new HighlightEdgeEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        HighlightEdge h = new HighlightEdge();
        this.storeAttributesInto(h);
        return h;
    }

    public String[] getSupportedTypes() {
        return new String[]{"Graph"};
    }
}

