/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.AbstractTextEditor;
import animal.editor.Editor;
import animal.graphics.PTArc;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class ArcEditor
extends AbstractTextEditor
implements ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = 3323874737657161500L;
    private ColorChooserAction colorChooser;
    private ColorChooserAction fillColorChooser;
    private ExtendedActionButton fillColorChooserButton;
    private JCheckBox circle;
    private JCheckBox filled;
    private JCheckBox closed;
    private JCheckBox clockwise;
    private boolean isItalic;
    private boolean isBold;
    private JCheckBox fwArrow;
    private JCheckBox bwArrow;

    public ArcEditor() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box colorBox = generator.generateBorderedBox(3, "colorBL");
        Box firstRowBox = new Box(2);
        firstRowBox.add(generator.generateJLabel("colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTText)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("lineColor")}), initialColor);
        firstRowBox.add(new ExtendedActionButton(this.colorChooser, 67));
        colorBox.add(firstRowBox);
        Box secondRowBox = new Box(2);
        secondRowBox.add(generator.generateJLabel("fillColorLabel"));
        initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTArc)this.getCurrentObject()).getFillColor();
        this.fillColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "fillColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("fillColor")}), initialColor);
        this.fillColorChooserButton = new ExtendedActionButton(this.fillColorChooser, 70);
        secondRowBox.add(this.fillColorChooserButton);
        colorBox.add(secondRowBox);
        this.addBox(colorBox);
        this.circle = new JCheckBox(AnimalTranslator.translateMessage("circle"));
        this.circle.addActionListener(this);
        this.filled = new JCheckBox(AnimalTranslator.translateMessage("filled"));
        this.filled.addItemListener(this);
        this.closed = new JCheckBox(AnimalTranslator.translateMessage("closed"));
        this.closed.addItemListener(this);
        this.clockwise = new JCheckBox(AnimalTranslator.translateMessage("clockwise"));
        this.clockwise.addActionListener(this);
        this.fwArrow = new JCheckBox(AnimalTranslator.translateMessage("fwArrow"));
        this.fwArrow.addItemListener(this);
        this.bwArrow = new JCheckBox(AnimalTranslator.translateMessage("bwArrow"));
        this.bwArrow.addItemListener(this);
        Box arcPropertiesBox = generator.generateBorderedBox(3, "arcPropsBL");
        Box closedFilledBox = new Box(2);
        closedFilledBox.add(this.closed);
        closedFilledBox.add(this.filled);
        Box circleClockwiseBox = new Box(2);
        circleClockwiseBox.add(this.circle);
        circleClockwiseBox.add(this.clockwise);
        Box arrowModeBox = new Box(2);
        arrowModeBox.add(this.fwArrow);
        arrowModeBox.add(this.bwArrow);
        arcPropertiesBox.add(closedFilledBox);
        arcPropertiesBox.add(circleClockwiseBox);
        arcPropertiesBox.add(arrowModeBox);
        this.addBox(arcPropertiesBox);
        this.addBox(this.generateTextComponentBox(generator));
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return 4;
    }

    public boolean nextPoint(int num, Point p) {
        PTArc arc = (PTArc)this.getCurrentObject();
        switch (num) {
            case 1: {
                arc.setCenter(p);
                arc.setStartAngle(0);
                arc.setArcAngle(720);
                break;
            }
            case 2: {
                if (arc.isCircle()) {
                    arc.setRadius(MSMath.dist(arc.getCenter(), p));
                    break;
                }
                int xRadius = Math.abs(p.x - arc.getCenter().x);
                int yRadius = Math.abs(p.y - arc.getCenter().y);
                arc.setRadius(new Point(xRadius, yRadius));
                break;
            }
            case 3: {
                arc.setStartAngle(arc.getAngle(p));
                if (Math.abs(arc.getArcAngle()) != 720) break;
                arc.setClosed(true);
                arc.setFilled(false);
                break;
            }
            case 4: {
                int angle = arc.getAngle(p) - arc.getStartAngle();
                if (arc.isClockwise()) {
                    angle = -angle;
                }
                if (angle <= 0) {
                    angle += 360;
                }
                arc.setArcAngle(angle);
                arc.setClosed(this.closed.isSelected());
                arc.setFilled(this.filled.isSelected());
            }
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        double d;
        PTArc arc = (PTArc)go;
        int angle = arc.getAngle(p);
        Point c = arc.getCenter();
        Point firstPoint = arc.getPointAtAngle(arc.getStartAngle());
        Point secondPoint = arc.getPointAtAngle(arc.getStartAngle() + arc.getArcAngle());
        int dist = arc.isAngleInside(angle) ? ((d = MSMath.sqr((double)(p.x - c.x) / (double)arc.getXRadius()) + MSMath.sqr((double)(p.y - c.y) / (double)arc.getYRadius())) >= 1.0 ? (int)Math.sqrt((d - 1.0) * 500.0) : (arc.isFilled() ? 0 : (arc.isClosed() ? Math.min((int)Math.sqrt((1.0 - d) * 500.0), Math.min(MSMath.dist(p, firstPoint, c), MSMath.dist(p, secondPoint, c))) : (int)Math.sqrt((1.0 - d) * 500.0)))) : (arc.isFilled() || arc.isClosed() ? Math.min(MSMath.dist(p, firstPoint, c), MSMath.dist(p, secondPoint, c)) : Math.min(MSMath.dist(p, firstPoint), MSMath.dist(p, secondPoint)));
        return dist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTArc arc = (PTArc)go;
        Point c = arc.getCenter();
        if (arc.isCircle()) {
            int r = arc.getRadius();
            return new EditPoint[]{new EditPoint(-1, c), new EditPoint(4, arc.getPointAtAngle(arc.getStartAngle() + arc.getArcAngle())), new EditPoint(3, arc.getPointAtAngle(arc.getStartAngle())), new EditPoint(2, new Point(c.x - r, c.y)), new EditPoint(2, new Point(c.x + r, c.y)), new EditPoint(2, new Point(c.x, c.y - r)), new EditPoint(2, new Point(c.x, c.y + r))};
        }
        int xr = arc.getXRadius();
        int yr = arc.getYRadius();
        return new EditPoint[]{new EditPoint(-1, c), new EditPoint(2, new Point(c.x - xr, c.y - yr)), new EditPoint(2, new Point(c.x - xr, c.y + yr)), new EditPoint(2, new Point(c.x + xr, c.y - yr)), new EditPoint(2, new Point(c.x + xr, c.y + yr)), new EditPoint(4, arc.getPointAtAngle(arc.getStartAngle() + arc.getArcAngle())), new EditPoint(3, arc.getPointAtAngle(arc.getStartAngle()))};
    }

    public void setProperties(XProperties props) {
        this.bold.setSelected(props.getBoolProperty("Arc.bold"));
        this.bwArrow.setSelected(props.getBoolProperty("Arc.bwArrow"));
        this.circle.setSelected(props.getBoolProperty("Arc.circle"));
        this.clockwise.setSelected(props.getBoolProperty("Arc.clockwise"));
        this.closed.setSelected(props.getBoolProperty("Arc.closed"));
        this.colorChooser.setColor(props.getColorProperty("Arc.color", Color.black));
        this.fillColorChooser.setColor(props.getColorProperty("Arc.fillColor", Color.black));
        this.fontName.setSelectedItem(props.getProperty("Arc.fontName", "SansSerif"));
        this.fontSize.setSelectedItem(props.getProperty("Arc.fontSize", "12"));
        this.filled.setSelected(props.getBoolProperty("Arc.filled"));
        this.fwArrow.setSelected(props.getBoolProperty("Arc.fwArrow"));
        this.italic.setSelected(props.getBoolProperty("Arc.italic"));
        this.textField.setText(props.getProperty("Arc.text"));
        this.textColorChooser.setColor(props.getColorProperty("Arc.textColor", Color.black));
    }

    public void getProperties(XProperties props) {
        props.put("Arc.bold", this.bold.isSelected());
        props.put("Arc.bwArrow", this.bwArrow.isSelected());
        props.put("Arc.circle", this.circle.isSelected());
        props.put("Arc.clockwise", this.clockwise.isSelected());
        props.put("Arc.closed", this.closed.isSelected());
        props.put("Arc.color", this.colorChooser.getColor());
        props.put("Arc.fillColor", this.fillColorChooser.getColor());
        props.put("Arc.filled", this.filled.isSelected());
        props.put((Object)"Arc.fontName", this.fontName.getSelectedItem());
        props.put((Object)"Arc.fontSize", this.fontSize.getSelectedItem());
        props.put("Arc.fwArrow", this.fwArrow.isSelected());
        props.put("Arc.italic", this.italic.isSelected());
        props.put("Arc.text", this.textField.getText());
        props.put("Arc.textColor", this.textColorChooser.getColor());
    }

    public EditableObject createObject() {
        PTArc arc = new PTArc();
        this.storeAttributesInto(arc);
        return arc;
    }

    void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTArc arc = (PTArc)eo;
        arc.setText(this.textField.getText());
        arc.setFont(this.storeFont());
        arc.setCircle(this.circle.isSelected());
        arc.setFilled(this.filled.isSelected());
        arc.setClosed(this.closed.isSelected());
        arc.setClockwise(this.clockwise.isSelected());
        arc.setFWArrow(this.fwArrow.isSelected());
        arc.setBWArrow(this.bwArrow.isSelected());
        arc.setColor(this.colorChooser.getColor());
        arc.setFillColor(this.fillColorChooser.getColor());
        arc.setTextColor(this.textColorChooser.getColor());
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        return new Font(name, 0 + (this.isBold ? 1 : 0) + (this.isItalic ? 2 : 0), this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTArc arc = (PTArc)eo;
        this.textField.setText(arc.getText());
        this.extractFont(arc.getFont());
        this.circle.setSelected(arc.isCircle());
        this.filled.setSelected(arc.isFilled());
        this.closed.setSelected(arc.isClosed());
        this.clockwise.setSelected(arc.isClockwise());
        this.fwArrow.setSelected(arc.hasFWArrow());
        this.bwArrow.setSelected(arc.hasBWArrow());
        this.colorChooser.setColor(arc.getColor());
        this.fillColorChooser.setColor(arc.getFillColor());
        this.textColorChooser.setColor(arc.getTextColor());
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        ArcEditor result = new ArcEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("arcStatusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateCancelButton()});
    }

    public void itemStateChanged(ItemEvent e) {
        PTArc arc = (PTArc)this.getCurrentObject();
        if (arc != null) {
            if (e.getSource() == this.closed) {
                this.filled.setEnabled(this.closed.isSelected());
                this.fwArrow.setEnabled(!this.closed.isSelected());
                this.bwArrow.setEnabled(!this.closed.isSelected());
                arc.setClosed(this.closed.isSelected());
            }
            if (!this.closed.isSelected()) {
                arc.setFilled(false);
            } else {
                arc.setFilled(this.filled.isSelected());
            }
            if (e.getSource() == this.filled) {
                arc.setFilled(this.filled.isSelected());
            }
            if (e.getSource() == this.fwArrow) {
                arc.setFWArrow(this.fwArrow.isSelected());
            }
            if (e.getSource() == this.bwArrow) {
                arc.setBWArrow(this.bwArrow.isSelected());
            }
            this.fillColorChooserButton.setEnabled(this.closed.isSelected() && this.filled.isSelected());
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Font newFont;
        String size;
        String name;
        super.actionPerformed(e);
        PTArc arc = (PTArc)this.getCurrentObject();
        this.isItalic = arc.getFont().isItalic();
        this.isBold = arc.getFont().isBold();
        if (e.getSource() == this.textField) {
            arc.setText(this.textField.getText());
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            arc.setFont(this.storeFont());
        }
        if (e.getSource() == this.italic) {
            this.isItalic = !this.isItalic;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            arc.setFont(newFont);
        }
        if (e.getSource() == this.bold) {
            this.isBold = !this.isBold;
            name = (String)this.fontName.getSelectedItem();
            size = (String)this.fontSize.getSelectedItem();
            newFont = new Font(name, 0 + (this.bold.isSelected() ? 1 : 0) + (this.italic.isSelected() ? 2 : 0), this.getInt(size, 12));
            arc.setFont(newFont);
        }
        if (e.getSource() == this.circle) {
            arc.setCircle(this.circle.isSelected());
        }
        if (e.getSource() == this.clockwise) {
            arc.setClockwise(this.clockwise.isSelected());
        }
        if (Animation.get() != null) {
            Animation.get().doChange();
        }
        this.repaintNow();
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTArc arc = (PTArc)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if (eventName.equals("color")) {
            arc.setColor((Color)event.getNewValue());
        } else if (eventName.equals("fillColor")) {
            arc.setFillColor((Color)event.getNewValue());
        } else if (eventName.equals("textColor")) {
            arc.setTextColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Arc";
    }
}

