/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.GraphicEditor;
import animal.graphics.PTArc;
import animal.main.Animal;
import animal.misc.AnimalTranslator;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.TextUtilities;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public abstract class AbstractTextEditor
extends GraphicEditor {
    protected JTextField textField = null;
    protected JComboBox fontName;
    protected JComboBox fontSize;
    protected JCheckBox bold;
    protected JCheckBox italic;
    protected ColorChooserAction textColorChooser;

    public Box generateTextOperationsBox(TranslatableGUIElement generator, String borderKey) {
        Box textEntryBox = generator.generateBorderedBox(3, borderKey);
        this.textField = new JTextField(16);
        this.textField.addActionListener(this);
        textEntryBox.add(this.textField);
        Box textEditBox = new Box(2);
        Action theAction = TextUtilities.findTextFieldAction("cut-to-clipboard");
        textEditBox.add(generator.generateActionButton("cut", null, theAction));
        theAction = TextUtilities.findTextFieldAction("copy-to-clipboard");
        textEditBox.add(generator.generateActionButton("copy", null, theAction));
        theAction = TextUtilities.findTextFieldAction("paste-from-clipboard");
        textEditBox.add(generator.generateActionButton("paste", null, theAction));
        textEntryBox.add(textEditBox);
        return textEntryBox;
    }

    public Box generateTextComponentBox(TranslatableGUIElement generator) {
        Box textBox = generator.generateBorderedBox(3, "textCompBL");
        textBox.add(this.generateTextOperationsBox(generator, "textBL"));
        textBox.add(this.generateFontAndStyleBox(generator, "fontBL"));
        Box textColorBox = generator.generateBorderedBox(2, "textColorBL");
        textColorBox.add(generator.generateJLabel("colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTArc)this.getCurrentObject()).getTextColor();
        this.textColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "textColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("textColor")}), initialColor);
        textColorBox.add(new ExtendedActionButton(this.textColorChooser, 84));
        textBox.add(textColorBox);
        return textBox;
    }

    public Box generateFontAndStyleBox(TranslatableGUIElement generator, String borderKey) {
        Box fontBox = generator.generateBorderedBox(3, borderKey);
        Box fontNameBox = new Box(2);
        fontNameBox.add(AnimalTranslator.getGUIBuilder().generateJLabel("nameLabel"));
        String[] fonts = Animal.GLOBAL_FONTS;
        this.fontName = new JComboBox();
        int j = 0;
        while (j < fonts.length) {
            this.fontName.addItem(fonts[j]);
            ++j;
        }
        this.fontName.addActionListener(this);
        fontNameBox.add(this.fontName);
        fontBox.add(fontNameBox);
        Box fontSizeBox = new Box(2);
        fontSizeBox.add(generator.generateJLabel("sizeLabel"));
        this.fontSize = new JComboBox();
        this.fontSize.setEditable(true);
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("16");
        this.fontSize.addItem("24");
        this.fontSize.setSelectedItem("12");
        this.fontSize.addActionListener(this);
        fontSizeBox.add(this.fontSize);
        fontBox.add(fontSizeBox);
        Box fontTypeBox = new Box(2);
        fontTypeBox.add(generator.generateJLabel("styleLabel"));
        this.italic = generator.generateJCheckBox("italic", null, this);
        this.italic.setHorizontalAlignment(0);
        fontTypeBox.add(this.italic);
        this.bold = generator.generateJCheckBox("bold", null, this);
        this.bold.setHorizontalAlignment(0);
        fontTypeBox.add(this.bold);
        fontBox.add(fontTypeBox);
        return fontBox;
    }
}

