/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.GraphicObjectSpecificAnimation;
import animal.animator.Move;
import animal.animator.SwapType;
import animal.animator.TimedAnimator;
import animal.graphics.PTArc;
import animal.graphics.PTArray;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;

public class Swap
extends TimedAnimator
implements GraphicObjectSpecificAnimation {
    public static final String TYPE_LABEL = "Swap";
    private static final long serialVersionUID = 6013542892925447747L;
    public static final int POLY = 0;
    public static final int ARC = 1;
    private int[] animatedObjectNums;
    private int animationType = 0;
    private PTPolyline[] p1;
    private PTPolyline[] p2;
    private PTPolyline[] p3;
    private PTArc[] a1;
    private PTArc[] a2;
    private int[] usedIDs;
    private int first = -1;
    private int second = -1;
    private Move[] upperPath;
    private Move[] lowerPath;
    private Move[] translationPath;

    public Swap() {
    }

    public Swap(int step, int objectNum, int totalTimeOrTicks, int firstIndex, int secondIndex) {
        this(step, new int[]{objectNum}, "swap", totalTimeOrTicks, firstIndex, secondIndex);
    }

    public Swap(int step, int[] objectNums, int totalTimeOrTicks, int firstIndex, int secondIndex) {
        this(step, objectNums, "swap", totalTimeOrTicks, firstIndex, secondIndex);
    }

    public Swap(int step, int objectNum, String method, int totalTimeOrTicks, int firstIndex, int secondIndex) {
        this(step, new int[]{objectNum}, method, totalTimeOrTicks, firstIndex, secondIndex);
    }

    public Swap(int step, int[] objectNums, String method, int totalTimeOrTicks, int firstIndex, int secondIndex) {
        super(step, objectNums, totalTimeOrTicks, method);
    }

    public Swap(XProperties props) {
        this.setProperties(props);
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        long l = this.startTimeOrTicks = this.isUnitIsTicks() ? Math.round(ticks) : time;
        if (this.animatedObjectNums != null && this.animatedObjectNums.length > 0) {
            int num = 0;
            while (num < this.animatedObjectNums.length) {
                Rectangle bBox1 = new Rectangle(0, 0, 0, 0);
                Rectangle bBox2 = new Rectangle(0, 0, 0, 0);
                PTGraphicObject ao = animationState.getCloneByNum(this.animatedObjectNums[num]);
                if (ao instanceof PTArray) {
                    bBox1 = ((PTArray)ao).getBoundingBox(this.first);
                    bBox2 = ((PTArray)ao).getBoundingBox(this.second);
                }
                switch (this.animationType) {
                    case 0: {
                        this.p1[num].setNode(0, new PTPoint(bBox1.x + bBox1.width, bBox1.y));
                        this.p1[num].setNode(1, new PTPoint(bBox1.x + bBox1.width, bBox1.y + bBox1.height + 5));
                        this.p1[num].setNode(2, new PTPoint(bBox2.x + bBox2.width, bBox2.y + bBox2.height + 5));
                        this.p1[num].setNode(3, new PTPoint(bBox2.x + bBox2.width, bBox2.y));
                        this.p2[num].setNode(0, new PTPoint(bBox2.x, bBox2.y + bBox2.height));
                        this.p2[num].setNode(1, new PTPoint(bBox2.x, bBox2.y - 5));
                        this.p2[num].setNode(2, new PTPoint(bBox1.x, bBox1.y - 5));
                        this.p2[num].setNode(3, new PTPoint(bBox1.x, bBox1.y + bBox1.height));
                        break;
                    }
                    case 1: {
                        this.a1[num].setLocation(new Point(bBox1.x + bBox1.width, bBox1.y + bBox1.height - this.a1[num].getYRadius()));
                        this.a1[num].setXRadius((bBox2.x - bBox1.x + bBox2.width - bBox1.width) / 2);
                        this.a2[num].setLocation(new Point(bBox1.x, bBox1.y - this.a2[num].getYRadius()));
                        this.a2[num].setXRadius((bBox2.x - bBox1.x) / 2);
                    }
                }
                this.p3[num].setNode(0, new PTPoint(bBox1.x + bBox1.width, bBox1.y));
                this.p3[num].setNode(1, new PTPoint(bBox1.x + bBox2.width, bBox1.y));
                this.upperPath[num].init(animationState, time, ticks);
                this.lowerPath[num].init(animationState, time, ticks);
                this.translationPath[num].init(animationState, time, ticks);
                ++num;
            }
        }
    }

    public void restoreIDs(int[] ID) {
        this.usedIDs = ID;
    }

    public int[] exportIDs() {
        int al = this.animatedObjectNums.length;
        int[] IDs = new int[5 * al];
        int i = 0;
        while (i < al) {
            PTGraphicObject ao = Animation.get().getGraphicObject(this.animatedObjectNums[i]);
            if (ao instanceof PTArray) {
                IDs[2 * i] = ((PTArray)ao).getEntry(this.first).getNum(false);
                IDs[2 * i + 1] = ((PTArray)ao).getEntry(this.second).getNum(false);
            }
            ++i;
        }
        switch (this.animationType) {
            case 0: {
                i = 0;
                while (i < this.p1.length) {
                    IDs[2 * al + 3 * i] = this.p1[i].getNum(false);
                    IDs[2 * al + 3 * i + 1] = this.p2[i].getNum(false);
                    IDs[2 * al + 3 * i + 2] = this.p3[i].getNum(false);
                    ++i;
                }
                break;
            }
            case 1: {
                i = 0;
                while (i < this.a1.length) {
                    IDs[2 * al + 3 * i] = this.a1[i].getNum(false);
                    IDs[2 * al + 3 * i + 1] = this.a2[i].getNum(false);
                    IDs[2 * al + 3 * i + 2] = this.p3[i].getNum(false);
                    ++i;
                }
                break;
            }
        }
        return IDs;
    }

    public void setSwapElements(int a, int b) {
        if (a != b && a >= 0 && b >= 0) {
            if (b < a) {
                int tmp = a;
                a = b;
                b = tmp;
            }
            if (this.animatedObjectNums == null || this.animatedObjectNums.length == 0) {
                MessageDisplay.errorMsg(AnimalTranslator.translateMessage("noSwapObjectsSet"), 4);
            } else {
                int num = 0;
                while (num < this.animatedObjectNums.length) {
                    PTGraphicObject ao = Animation.get().getGraphicObject(this.animatedObjectNums[num]);
                    if (ao instanceof PTArray) {
                        this.modifyAnimatedObjects((PTArray)ao, this.first, a);
                        this.modifyAnimatedObjects((PTArray)ao, this.second, b);
                    }
                    ++num;
                }
            }
            this.first = a;
            this.second = b;
            this.createMoves();
        }
    }

    private void modifyAnimatedObjects(PTArray go, int old, int now) {
        if (this.usedIDs != null && this.usedIDs.length > 0 && now >= 0) {
            go.setNum(now, this.usedIDs[0]);
            this.deleteUsedID();
        }
        if (old < 0) {
            if (now >= 0) {
                Animation.get().insertGraphicObject(go.getEntry(now));
            }
        } else if (old != now) {
            if (go.getEntry(old) != null) {
                Animation.get().deleteGraphicObject(go.getEntry(old).getNum(false));
            }
            if (now >= 0) {
                Animation.get().insertGraphicObject(go.getEntry(now));
            }
        }
    }

    private void deleteUsedID() {
        if (this.usedIDs != null && this.usedIDs.length > 0) {
            int[] temp = new int[this.usedIDs.length - 1];
            int i = 0;
            while (i < temp.length) {
                temp[i] = this.usedIDs[i + 1];
                ++i;
            }
            this.usedIDs = temp;
        } else if (this.usedIDs != null) {
            this.usedIDs = null;
        }
    }

    public int[] getSwapElements() {
        return new int[]{this.first, this.second};
    }

    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public void setObject(int obj) {
        this.setObjects(new int[]{obj});
    }

    public void setObjects(int[] obj) {
        block12: {
            block11: {
                PTGraphicObject ao;
                if (this.animatedObjectNums == null || this.animatedObjectNums.length <= 0 || this.animatedObjectNums.equals(obj)) break block11;
                int num = 0;
                while (num < this.animatedObjectNums.length) {
                    ao = Animation.get().getGraphicObject(this.animatedObjectNums[num]);
                    if (ao instanceof PTArray) {
                        Animation.get().deleteGraphicObject(((PTArray)ao).getEntry(this.first).getNum(false));
                        Animation.get().deleteGraphicObject(((PTArray)ao).getEntry(this.second).getNum(false));
                    }
                    ++num;
                }
                this.animatedObjectNums = obj;
                if (this.animatedObjectNums == null || this.animatedObjectNums.length <= 0) break block12;
                num = 0;
                while (num < this.animatedObjectNums.length) {
                    ao = Animation.get().getGraphicObject(this.animatedObjectNums[num]);
                    if (ao instanceof PTArray) {
                        if (((PTArray)ao).getEntry(this.first) != null) {
                            Animation.get().insertGraphicObject(((PTArray)ao).getEntry(this.first));
                        }
                        if (((PTArray)ao).getEntry(this.second) != null) {
                            Animation.get().insertGraphicObject(((PTArray)ao).getEntry(this.second));
                        }
                    }
                    ++num;
                }
                break block12;
            }
            this.animatedObjectNums = obj;
            if (this.animatedObjectNums != null && this.animatedObjectNums.length != 0) {
                int num = 0;
                while (num < this.animatedObjectNums.length) {
                    PTGraphicObject ao = Animation.get().getGraphicObject(this.animatedObjectNums[num]);
                    if (ao instanceof PTArray) {
                        if (((PTArray)ao).getEntry(this.first) != null) {
                            Animation.get().insertGraphicObject(((PTArray)ao).getEntry(this.first));
                        }
                        if (((PTArray)ao).getEntry(this.second) != null) {
                            Animation.get().insertGraphicObject(((PTArray)ao).getEntry(this.second));
                        }
                    }
                    ++num;
                }
            }
        }
    }

    public void createMoves() {
        if (this.animatedObjectNums != null && this.animatedObjectNums.length != 0) {
            int num;
            switch (this.animationType) {
                case 0: {
                    if (this.p1 != null && this.p1.length == this.animatedObjectNums.length) break;
                    if (this.p1 != null) {
                        num = 0;
                        while (num < this.p1.length) {
                            if (Animation.get().getGraphicObjects().contains(this.p1[num])) {
                                Animation.get().deleteGraphicObject(this.p1[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.p2[num])) {
                                Animation.get().deleteGraphicObject(this.p2[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.p3[num])) {
                                Animation.get().deleteGraphicObject(this.p3[num].getNum(false));
                            }
                            ++num;
                        }
                    }
                    this.p1 = new PTPolyline[this.animatedObjectNums.length];
                    this.p2 = new PTPolyline[this.animatedObjectNums.length];
                    this.p3 = new PTPolyline[this.animatedObjectNums.length];
                    this.upperPath = new Move[this.animatedObjectNums.length];
                    this.lowerPath = new Move[this.animatedObjectNums.length];
                    this.translationPath = new Move[this.animatedObjectNums.length];
                    break;
                }
                case 1: {
                    if (this.a1 != null && this.a1.length == this.animatedObjectNums.length) break;
                    if (this.a1 != null) {
                        num = 0;
                        while (num < this.a1.length) {
                            if (Animation.get().getGraphicObjects().contains(this.a1[num])) {
                                Animation.get().deleteGraphicObject(this.a1[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.a2[num])) {
                                Animation.get().deleteGraphicObject(this.a2[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.p3[num])) {
                                Animation.get().deleteGraphicObject(this.p3[num].getNum(false));
                            }
                            ++num;
                        }
                    }
                    this.a1 = new PTArc[this.animatedObjectNums.length];
                    this.a2 = new PTArc[this.animatedObjectNums.length];
                    this.p3 = new PTPolyline[this.animatedObjectNums.length];
                    this.upperPath = new Move[this.animatedObjectNums.length];
                    this.lowerPath = new Move[this.animatedObjectNums.length];
                    this.translationPath = new Move[this.animatedObjectNums.length];
                }
            }
            num = 0;
            while (num < this.animatedObjectNums.length) {
                PTGraphicObject ao = Animation.get().getGraphicObject(this.animatedObjectNums[num]);
                if (!(ao instanceof PTArray)) {
                    MessageDisplay.errorMsg(AnimalTranslator.translateMessage("wrongTypeForSwap"), 4);
                    return;
                }
                Rectangle bBox1 = ((PTArray)ao).getBoundingBox(this.first);
                Rectangle bBox2 = ((PTArray)ao).getBoundingBox(this.second);
                switch (this.animationType) {
                    case 0: {
                        if (this.p1[num] == null) {
                            this.p1[num] = new PTPolyline(new int[4], new int[4]);
                        } else {
                            this.p1[num].setNode(0, new PTPoint(bBox1.x + bBox1.width, bBox1.y));
                            this.p1[num].setNode(1, new PTPoint(bBox1.x + bBox1.width, bBox1.y + bBox1.height + 5));
                            this.p1[num].setNode(2, new PTPoint(bBox2.x + bBox2.width, bBox2.y + bBox2.height + 5));
                            this.p1[num].setNode(3, new PTPoint(bBox2.x + bBox2.width, bBox2.y));
                        }
                        if (this.usedIDs != null && this.usedIDs.length >= 3) {
                            this.p1[num].setNum(this.usedIDs[0]);
                            this.deleteUsedID();
                        } else {
                            this.p1[num].setNum(this.p1[num].getNum(true));
                        }
                        if (this.p2[num] == null) {
                            this.p2[num] = new PTPolyline(new int[4], new int[4]);
                        } else {
                            this.p2[num].setNode(0, new PTPoint(bBox2.x, bBox2.y + bBox2.height));
                            this.p2[num].setNode(1, new PTPoint(bBox2.x, bBox2.y - 5));
                            this.p2[num].setNode(2, new PTPoint(bBox1.x, bBox1.y - 5));
                            this.p2[num].setNode(3, new PTPoint(bBox1.x, bBox1.y + bBox1.height));
                        }
                        if (this.usedIDs != null && this.usedIDs.length >= 2) {
                            this.p2[num].setNum(this.usedIDs[0]);
                            this.deleteUsedID();
                        } else {
                            this.p2[num].setNum(this.p2[num].getNum(true));
                        }
                        if (this.p3[num] == null) {
                            this.p3[num] = new PTPolyline(new int[2], new int[2]);
                        } else {
                            this.p3[num].setNode(0, new PTPoint(bBox1.x + bBox1.width, bBox1.y));
                            this.p3[num].setNode(1, new PTPoint(bBox1.x + bBox2.width, bBox1.y));
                        }
                        if (this.usedIDs != null && this.usedIDs.length >= 1) {
                            this.p3[num].setNum(this.usedIDs[0]);
                            this.deleteUsedID();
                        } else {
                            this.p3[num].setNum(this.p3[num].getNum(true));
                        }
                        if (this.upperPath[num] == null) {
                            this.upperPath[num] = new Move(this.getStep(), this.animatedObjectNums[num], this.getDuration(), this.getMethod(), this.p2[num].getNum(false));
                        } else {
                            this.upperPath[num].setDuration(this.getDuration());
                            this.upperPath[num].setMethod(this.getMethod());
                            this.upperPath[num].setMoveBaseNum(this.p2[num].getNum(false));
                        }
                        if (this.lowerPath[num] == null) {
                            this.lowerPath[num] = new Move(this.getStep(), this.animatedObjectNums[num], this.getDuration(), this.getMethod(), this.p1[num].getNum(false));
                        } else {
                            this.lowerPath[num].setDuration(this.getDuration());
                            this.lowerPath[num].setMethod(this.getMethod());
                            this.lowerPath[num].setMoveBaseNum(this.p1[num].getNum(false));
                        }
                        if (this.translationPath[num] == null) {
                            this.translationPath[num] = new Move(this.getStep(), this.animatedObjectNums[num], this.getDuration(), this.getMethod(), this.p3[num].getNum(false));
                        } else {
                            this.translationPath[num].setDuration(this.getDuration());
                            this.translationPath[num].setMethod(this.getMethod());
                            this.translationPath[num].setMoveBaseNum(this.p3[num].getNum(false));
                        }
                        if (!Animation.get().getGraphicObjects().contains(this.p1[num])) {
                            Animation.get().insertGraphicObject(this.p1[num]);
                        }
                        if (!Animation.get().getGraphicObjects().contains(this.p2[num])) {
                            Animation.get().insertGraphicObject(this.p2[num]);
                        }
                        if (Animation.get().getGraphicObjects().contains(this.p3[num])) break;
                        Animation.get().insertGraphicObject(this.p3[num]);
                        break;
                    }
                    case 1: {
                        if (this.a1[num] == null) {
                            this.a1[num] = new PTArc();
                            this.a1[num].setStartAngle(180);
                            this.a1[num].setArcAngle(180);
                            this.a1[num].setCircle(false);
                            this.a1[num].setClockwise(false);
                            this.a1[num].setClosed(false);
                            this.a1[num].setYRadius(bBox1.height + 5);
                        } else {
                            this.a1[num].setLocation(new Point(bBox1.x + bBox1.width, bBox1.y + bBox1.height - this.a1[num].getYRadius()));
                            this.a1[num].setXRadius((bBox2.x - bBox1.x + bBox2.width - bBox1.width) / 2);
                        }
                        if (this.usedIDs != null && this.usedIDs.length >= 3) {
                            this.a1[num].setNum(this.usedIDs[0]);
                            this.deleteUsedID();
                        } else {
                            this.a1[num].setNum(this.a1[num].getNum(true));
                        }
                        if (this.a2[num] == null) {
                            this.a2[num] = new PTArc();
                            this.a2[num].setStartAngle(0);
                            this.a2[num].setArcAngle(180);
                            this.a2[num].setCircle(false);
                            this.a2[num].setClockwise(false);
                            this.a2[num].setClosed(false);
                            this.a2[num].setYRadius(bBox2.height + 5);
                        } else {
                            this.a2[num].setLocation(new Point(bBox1.x, bBox1.y - this.a2[num].getYRadius()));
                            this.a2[num].setXRadius((bBox2.x - bBox1.x) / 2);
                        }
                        if (this.usedIDs != null && this.usedIDs.length >= 2) {
                            this.a2[num].setNum(this.usedIDs[0]);
                            this.deleteUsedID();
                        } else {
                            this.a2[num].setNum(this.a2[num].getNum(true));
                        }
                        if (this.p3[num] == null) {
                            this.p3[num] = new PTPolyline(new int[2], new int[2]);
                        } else {
                            this.p3[num].setNode(0, new PTPoint(bBox1.x + bBox1.width, bBox1.y));
                            this.p3[num].setNode(1, new PTPoint(bBox1.x + bBox2.width, bBox1.y));
                        }
                        if (this.usedIDs != null && this.usedIDs.length >= 1) {
                            this.p3[num].setNum(this.usedIDs[0]);
                            this.deleteUsedID();
                        } else {
                            this.p3[num].setNum(this.p3[num].getNum(true));
                        }
                        if (this.upperPath[num] == null) {
                            this.upperPath[num] = new Move(this.getStep(), this.animatedObjectNums[num], this.getDuration(), this.getMethod(), this.a2[num].getNum(false));
                        } else {
                            this.upperPath[num].setDuration(this.getDuration());
                            this.upperPath[num].setMethod(this.getMethod());
                            this.upperPath[num].setMoveBaseNum(this.a2[num].getNum(false));
                        }
                        if (this.lowerPath[num] == null) {
                            this.lowerPath[num] = new Move(this.getStep(), this.animatedObjectNums[num], this.getDuration(), this.getMethod(), this.a1[num].getNum(false));
                        } else {
                            this.lowerPath[num].setDuration(this.getDuration());
                            this.lowerPath[num].setMethod(this.getMethod());
                            this.lowerPath[num].setMoveBaseNum(this.a1[num].getNum(false));
                        }
                        if (this.translationPath[num] == null) {
                            this.translationPath[num] = new Move(this.getStep(), this.animatedObjectNums[num], this.getDuration(), this.getMethod(), this.p3[num].getNum(false));
                        } else {
                            this.translationPath[num].setDuration(this.getDuration());
                            this.translationPath[num].setMethod(this.getMethod());
                            this.translationPath[num].setMoveBaseNum(this.p3[num].getNum(false));
                        }
                        if (!Animation.get().getGraphicObjects().contains(this.a1[num])) {
                            Animation.get().insertGraphicObject(this.a1[num]);
                        }
                        if (!Animation.get().getGraphicObjects().contains(this.a2[num])) {
                            Animation.get().insertGraphicObject(this.a2[num]);
                        }
                        if (Animation.get().getGraphicObjects().contains(this.p3[num])) break;
                        Animation.get().insertGraphicObject(this.p3[num]);
                    }
                }
                ++num;
            }
        }
    }

    public int getFileVersion() {
        return 2;
    }

    public Object getProperty(double factor) {
        if (this.animatedObjectNums == null || this.animatedObjectNums.length == 0) {
            return new SwapType[]{new SwapType(-1, -1, (byte)(factor * 100.0))};
        }
        if (this.lowerPath == null || this.upperPath == null || this.translationPath == null) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("swapNoMovePath"), 4);
            return new SwapType[]{new SwapType(-1, -1, (byte)(factor * 100.0))};
        }
        SwapType[] st = new SwapType[this.animatedObjectNums.length];
        int num = 0;
        while (num < this.animatedObjectNums.length) {
            st[num] = this.lowerPath[num] == null || this.upperPath[num] == null || this.translationPath[num] == null || this.lowerPath.length == 0 || this.upperPath.length == 0 || this.translationPath.length == 0 ? new SwapType(new int[]{-1, -1}, new Point(0, 0), new Point(0, 0), new Point(0, 0), this.hasFinished()) : new SwapType(this.getSwapElements(), (Point)this.lowerPath[num].getProperty(factor), (Point)this.upperPath[num].getProperty(factor), (Point)this.translationPath[num].getProperty(factor), this.hasFinished());
            ++num;
        }
        return st;
    }

    public int[] getTemporaryObjects() {
        int x;
        if (this.p3 == null) {
            return null;
        }
        int objCounter = this.p3.length;
        switch (this.animationType) {
            case 0: {
                objCounter += this.p1.length + this.p2.length;
                break;
            }
            case 1: {
                objCounter += this.a1.length + this.a2.length;
            }
        }
        int[] temp = new int[objCounter];
        switch (this.animationType) {
            case 0: {
                x = 0;
                while (x < this.p1.length) {
                    temp[x] = this.p1[x].getNum(false);
                    ++x;
                }
                objCounter = this.p1.length;
                x = 0;
                while (x < this.p2.length) {
                    temp[objCounter + x] = this.p2[x].getNum(false);
                    ++x;
                }
                objCounter += this.p2.length;
                break;
            }
            case 1: {
                x = 0;
                while (x < this.a1.length) {
                    temp[x] = this.a1[x].getNum(false);
                    ++x;
                }
                objCounter = this.a1.length;
                x = 0;
                while (x < this.a2.length) {
                    temp[objCounter + x] = this.a2[x].getNum(false);
                    ++x;
                }
                objCounter += this.a2.length;
            }
        }
        x = 0;
        while (x < this.p3.length) {
            temp[objCounter + x] = this.p3[x].getNum(false);
            ++x;
        }
        return temp;
    }

    public int getAnimationType() {
        return this.animationType;
    }

    public void setAnimationType(int type) {
        if (this.animationType != type) {
            switch (this.animationType) {
                case 0: {
                    if (this.p1 != null && this.p1.length > 0) {
                        int num = 0;
                        while (num < this.p1.length) {
                            if (Animation.get().getGraphicObjects().contains(this.p1[num])) {
                                Animation.get().deleteGraphicObject(this.p1[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.p2[num])) {
                                Animation.get().deleteGraphicObject(this.p2[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.p3[num])) {
                                Animation.get().deleteGraphicObject(this.p3[num].getNum(false));
                            }
                            ++num;
                        }
                    }
                    this.p1 = null;
                    this.p2 = null;
                    this.p3 = null;
                    break;
                }
                case 1: {
                    if (this.a1 != null && this.a1.length > 0) {
                        int num = 0;
                        while (num < this.a1.length) {
                            if (Animation.get().getGraphicObjects().contains(this.a1[num])) {
                                Animation.get().deleteGraphicObject(this.a1[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.a2[num])) {
                                Animation.get().deleteGraphicObject(this.a2[num].getNum(false));
                            }
                            if (Animation.get().getGraphicObjects().contains(this.p3[num])) {
                                Animation.get().deleteGraphicObject(this.p3[num].getNum(false));
                            }
                            ++num;
                        }
                    }
                    this.a1 = null;
                    this.a2 = null;
                    this.p3 = null;
                }
            }
        }
        this.animationType = type;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void action(long time, double ticks) {
        if (this.hasFinished()) {
            return;
        }
        double elapsed = (this.isUnitIsTicks() ? ticks : (double)time) - (double)this.startTimeOrTicks - (double)this.getOffset();
        double factor = elapsed / (double)this.getDuration();
        if (this.getDuration() == 0 && elapsed >= 0.0 || factor >= 1.0) {
            this.execute();
        } else {
            if (factor < 0.0) {
                return;
            }
            Object newProperty = this.getProperty(factor);
            int a = 0;
            while (a < this.objects.length) {
                if (this.objects[a] != null) {
                    this.objects[a].propertyChange(new PropertyChangeEvent(this, this.getMethod(), ((SwapType[])this.oldProperty)[a], ((SwapType[])newProperty)[a]));
                }
                ++a;
            }
            this.oldProperty = newProperty;
        }
    }

    public void execute() {
        this.setFinished(true);
        if (this.oldProperty == null) {
            this.oldProperty = this.getProperty(0.0);
        }
        Object newProperty = this.getProperty(1.0);
        if (this.objects != null && this.objects.length > 0) {
            int a = 0;
            while (a < this.objects.length) {
                if (this.objects[a] != null) {
                    this.objects[a].propertyChange(new PropertyChangeEvent(this, this.getMethod(), ((SwapType[])this.oldProperty)[a], ((SwapType[])newProperty)[a]));
                }
                ++a;
            }
        } else {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("noObjectsSetException"), new Object[]{String.valueOf(this.getStep()), String.valueOf(this.getAnimatorName()) + " -- " + this.toString()});
        }
    }

    public void discard() {
        int num = 0;
        while (num < this.animatedObjectNums.length) {
            switch (this.animationType) {
                case 0: {
                    this.p1[num].discard();
                    this.p2[num].discard();
                    break;
                }
                case 1: {
                    this.a1[num].discard();
                    this.a2[num].discard();
                }
            }
            this.p3[num].discard();
            this.upperPath[num].discard();
            this.lowerPath[num].discard();
            this.translationPath[num].discard();
            ++num;
        }
        this.a1 = null;
        this.a2 = null;
        this.p1 = null;
        this.p2 = null;
        this.p3 = null;
        this.upperPath = null;
        this.lowerPath = null;
        this.translationPath = null;
        this.usedIDs = null;
        super.discard();
    }

    public String toString() {
        if (this.first < 0 || this.second < 0) {
            return "Invalid parameters; swap cannot be executed";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("Swap cells ").append(this.first).append(" and ");
        sb.append(this.second).append(" of ").append(super.toString());
        sb.append(" using PT");
        sb.append(this.animationType == 0 ? "Polyline " : "Arc ");
        return sb.toString();
    }

    public String[] getSupportedTypes() {
        return new String[]{"StringArray", "IntArray"};
    }
}

