/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.FillInBlanksQuestionAction;
import animal.animator.MultipleChoiceQuestionAction;
import animal.animator.PerformableAction;
import animal.animator.TrueFalseQuestionAction;
import animal.main.PropertiedObject;
import animal.misc.AnimalTranslator;
import animal.misc.MessageDisplay;
import java.util.Hashtable;

public class QuestionAction
extends PropertiedObject
implements PerformableAction {
    private static final long serialVersionUID = 8418489397704058957L;
    public static final String ANSWER_CORRECT_TAG = "QuestionAction.answerCorrect";
    public static final String QUESTION_TEXT = "QuestionAction.questionText";
    public static final String TITLE_TAG = "QuestionAction.title";
    public static final int TYPE_FILL_IN_BLANKS = 1;
    public static final String TYPE_LABEL = "QuestionAction";
    public static final int TYPE_MULTIPLE_CHOICE = 2;
    public static final String TYPE_TAG_LABEL = "QuestionAction";
    public static final int TYPE_TRUE_FALSE = 4;
    private static Hashtable<String, QuestionAction> questionArray;
    public int type = 2;
    boolean used = false;

    public static QuestionAction getActionFor(String key) {
        if (questionArray.containsKey(key)) {
            return questionArray.get(key);
        }
        return null;
    }

    public QuestionAction() {
    }

    public QuestionAction(int typeOfQuestion, String title) {
        this.setType(typeOfQuestion);
        if (questionArray == null) {
            questionArray = new Hashtable(91);
        }
        switch (this.type) {
            case 1: {
                questionArray.put(title, new FillInBlanksQuestionAction(title));
                break;
            }
            case 2: {
                questionArray.put(title, new MultipleChoiceQuestionAction(title));
                break;
            }
            case 4: {
                questionArray.put(title, new TrueFalseQuestionAction(title));
            }
        }
    }

    public void perform() {
        MessageDisplay.errorMsg("doNotInvokeMethod", new Object[]{"perform", this.getClass().getName()});
    }

    public void addAnswer(String text) {
    }

    public void addAnswer(String title, String answerText) {
        QuestionAction o;
        if (questionArray.containsKey(title) && (o = questionArray.get(title)) instanceof QuestionAction) {
            o.addAnswer(answerText);
        }
    }

    public void addCorrectFIBAnswer(String title, String correctAnswerText) {
        QuestionAction o;
        if (questionArray.containsKey(title) && (o = questionArray.get(title)) instanceof FillInBlanksQuestionAction) {
            ((FillInBlanksQuestionAction)o).addCorrectFIBAnswer(correctAnswerText);
        }
    }

    public void addToQuestionText(String text) {
        StringBuilder questionText = new StringBuilder();
        String oldText = this.getProperties().getProperty(QUESTION_TEXT, null);
        if (oldText != null) {
            questionText.append(oldText).append("\n");
        }
        questionText.append(text);
        this.getProperties().put(QUESTION_TEXT, questionText.toString());
    }

    public void addToQuestionText(String title, String text) {
        if (questionArray.containsKey(title)) {
            QuestionAction question = questionArray.get(title);
            question.addToQuestionText(text);
        }
    }

    public String getQuestionText() {
        return this.getProperties().getProperty(QUESTION_TEXT, "");
    }

    public String getTitle() {
        return this.getProperties().getProperty(TITLE_TAG, "");
    }

    public int getType() {
        return this.getProperties().getIntProperty("QuestionAction", 2);
    }

    public void setCorrectMCAnswer(String title, int nrOfCorrectAnswer) {
        QuestionAction questionAction;
        if (questionArray.containsKey(title) && (questionAction = questionArray.get(title)) instanceof MultipleChoiceQuestionAction) {
            ((MultipleChoiceQuestionAction)questionAction).setCorrectAnswer(nrOfCorrectAnswer);
        }
    }

    public void setQuestionText(String text) {
        this.getProperties().put(QUESTION_TEXT, text);
    }

    public void setQuestionTextFor(String title, String text) {
        if (questionArray.containsKey(title)) {
            QuestionAction question = questionArray.get(title);
            question.setQuestionText(text);
        }
    }

    public void setCorrectTFAnswer(String title, boolean isCorrect) {
        QuestionAction question;
        if (questionArray.containsKey(title) && (question = questionArray.get(title)) instanceof TrueFalseQuestionAction) {
            ((TrueFalseQuestionAction)question).setCorrectAnswer(isCorrect);
        }
    }

    public void setTitle(String title) {
        this.getProperties().put(TITLE_TAG, title);
    }

    public void setType(int typeCode) {
        this.getProperties().put("QuestionAction", typeCode);
    }

    public String toString() {
        return AnimalTranslator.translateMessage("doNotInvokeMethodException", new Object[]{"toString", this.getClass().getName()});
    }
}

