/*
 * Decompiled with CFR 0.152.
 */
package algorithm.stringSearch;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.animalTranslator.codeItems.Hidden;
import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Off;
import algorithm.animalTranslator.codeItems.Pos;
import algorithm.animalTranslator.codeItems.TimeOffset;
import algorithm.animalTranslator.codeItems.Timing;
import algorithm.animalTranslator.codeItems.WithinTiming;

public class BruteForceStringSearch {
    private AnimalTranslator at;
    private String dataString;
    private String stringToSearch;
    private boolean initialized = false;
    private String stringArrayName;
    private String subStringArrayName;
    private String algorithmName;
    private String markerIName;
    private String markerJName;
    private String markerStartName;
    private String legendeIName;
    private String legendeJName;
    private String legendeStartName;
    private int textPos;
    private int xPos;
    private int[] markedLinesInAlgorithm;

    public BruteForceStringSearch(AnimalTranslator newAT) {
        this.at = newAT;
    }

    public void initialize(String theString, String toBeSearched) {
        this.dataString = theString;
        this.stringToSearch = toBeSearched;
        this.stringArrayName = "BruteForceSearchArray";
        this.subStringArrayName = "BruteForceSearchArraySubString";
        this.algorithmName = "CodeGroup_Algorithm";
        this.markerIName = "markerInString";
        this.markerJName = "markerInSubString";
        this.markerStartName = "markerInStringStart";
        this.legendeIName = "dieLegendeStringPointer";
        this.legendeJName = "dieLegendeSubStringPointer";
        this.legendeStartName = "dieLegendeStringCompareStart";
        this.textPos = -1;
        this.xPos = -1;
        this.initialized = true;
    }

    public int generateAnimation() throws Exception {
        if (!this.initialized) {
            throw new Exception("Instance of BruteForce-StringSearch has not been initialized!");
        }
        this.at.advancedAddHeaderMM("BruteForce String-Suche");
        this.displayInitialScreen();
        this.displaySearchScreen();
        return this.bFSSearchIterativ(this.dataString, this.stringToSearch);
    }

    private void displayInitialScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("initial screen");
        this.at.advancedCreateWorkSheet();
        this.at.addText("sollSortiert", "BruteForce-Suche nach einer Zeichenkette", new Pos(200, 200), "color black size 35 bold", null);
        this.at.compositeStepEnd();
        this.at.compositeStepStart();
        this.at.addText("comment1", "Die einfachste und allgemeinste Methode der Suche nach Zeichenketten.", new Off(-420, 130, "sollSortiert", "S"), "color black size 25", null);
        this.at.addText("comment2", "Hierbei wird sequentiel f\u00c3\u00bcr jedes Zeichen im Text \u00c3\u00bcberpr\u00c3\u00bcft,", new Off(0, 40, "comment1", "SW"), "color black size 25", null);
        this.at.addText("comment3", "ob hier die gesuchte Zeichenkette beginnt.", new Off(0, 40, "comment2", "SW"), "color black size 25", null);
        this.at.addText("comment4", "Daher auch der Name 'Brute-Force-Suche' ('Suche mit brutaler Gewalt').", new Off(0, 40, "comment3", "SW"), "color black size 25", null);
        this.at.compositeStepEnd();
    }

    private void displaySearchScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("searching screen");
        this.at.hide(new String[]{"sollSortiert", "comment1", "comment2", "comment3", "comment4"}, null);
        this.at.advancedTextLine("headline", new Pos(300, 70), "color black size 25 bold", null, "Brute-Force-Suche nach der Zeichenkette: '" + this.stringToSearch + "'");
        this.at.advancedArrayReduction(this.stringArrayName, (Node)new Off(-200, 120, "headline", "NW"), this.dataString);
        this.at.addArrayMarker(this.markerStartName, this.stringArrayName, 0, "color red", new Hidden());
        this.at.addArrayMarker(this.markerIName, this.stringArrayName, 0, "color blue", new Hidden());
        this.at.advancedTextLine(this.legendeIName, new Off(0, -25, this.stringArrayName, "NW"), "color blue size 15", null, "(textPos) aktuell betrachtete Position im String");
        this.at.advancedArrayReduction(this.subStringArrayName, (Node)new Off(0, 50, this.stringArrayName, "SW"), this.stringToSearch);
        this.at.addArrayMarker(this.markerJName, this.subStringArrayName, 0, "color green3", new Hidden());
        this.at.advancedTextLine(this.legendeJName, new Off(30, 0, this.legendeIName, "NE"), "color green3 size 15", null, "(xPos) aktuell betrachtete Position in der Zeichenkette");
        this.at.advancedTextLine(this.legendeStartName, new Off(30, 0, this.legendeJName, "NE"), "color red size 15", null, "Startposition des aktuellen Vergleichs");
        this.at.hide(new String[]{this.legendeIName, this.legendeJName, this.legendeStartName}, null);
        this.at.advancedCodeGroupStandard(this.algorithmName, new Off(15, 75, this.subStringArrayName, "SW"), new TimeOffset(0), new String[]{"1. Betrachte jeweils das erste Zeichen in Text und zu suchender Zeichenkette", "2. Ist entweder das Ende des Textes oder das der Zeichenkette erreicht?", "   - falls ja, gehe zu Schritt 9", "3. Sind die beiden betrachteten Zeichen gleich?", "   - falls ja, gehe zu Schritt 7", "4. Betrachte im Text das Zeichen direkt hinter der letzten 'Startposition' des Vergleichs", "5. Betrachte in der zu suchenden Zeichenkette wieder das erste Zeichen", "6. gehe zu Schritt 2 (Startposition des Vergleichs wird angepasst)", "7. gehe in Text und Zeichenkette jeweils ein Zeichen weiter", "8. gehe zu Schritt 2", "9. Ist das Ende der Zeichenkette erreicht?", "   - falls ja, gib die letzte 'Startposition' des Vergleichs zur\u00c3\u00bcck", "   - sonst wurde das Element nicht gefunden"});
        this.at.compositeStepEnd();
    }

    private int bFSSearchIterativ(String text, String x) {
        this.setTextPos(0, true);
        this.setXPos(0, true);
        while (this.xPos < x.length() && this.textPos < text.length()) {
            this.codeMarkingForWhile();
            while (text.charAt(this.textPos) != x.charAt(this.xPos)) {
                this.setTextPos(this.textPos - this.xPos + 1, false);
                this.setXPos(0, false);
                if (this.textPos == text.length()) break;
                this.codeMarkingForWhile();
            }
            if (this.xPos >= x.length() || this.textPos >= text.length()) continue;
            this.setTextPos(this.textPos + 1, true);
            this.setXPos(this.xPos + 1, true);
        }
        if (this.xPos == x.length()) {
            return this.returnResult(this.textPos - x.length());
        }
        return this.returnResult(-1);
    }

    private void setTextPos(int newValue, boolean isFor) {
        this.at.compositeStepStart();
        if (this.textPos == -1) {
            this.at.show(this.legendeIName, null);
            this.at.moveArrayMarker(this.markerIName, newValue, (Timing)new WithinTiming(0));
            this.at.show(this.markerIName, null);
            this.markLines(new int[1]);
        } else {
            if (newValue < this.dataString.length()) {
                this.at.moveArrayMarker(this.markerIName, newValue, (Timing)new WithinTiming(1000));
            } else {
                this.at.hide(this.markerIName, null);
            }
            if (isFor) {
                this.markLines(new int[]{8});
            } else {
                this.markLines(new int[]{5});
            }
        }
        this.textPos = newValue;
        this.at.compositeStepEnd();
    }

    private void setXPos(int newValue, boolean isFor) {
        this.at.compositeStepStart();
        if (this.xPos == -1) {
            this.at.show(this.legendeJName, null);
            this.at.moveArrayMarker(this.markerJName, newValue, (Timing)new WithinTiming(0));
            this.at.show(this.markerJName, null);
            this.at.show(this.legendeStartName, null);
            this.at.show(this.markerStartName, null);
            if (newValue == 0) {
                this.at.moveArrayMarker(this.markerStartName, this.textPos, (Timing)new WithinTiming(0));
            }
        } else {
            if (newValue < this.stringToSearch.length()) {
                this.at.moveArrayMarker(this.markerJName, newValue, (Timing)new WithinTiming(1000));
            } else {
                this.at.hide(this.markerJName, null);
            }
            if (isFor) {
                this.at.compositeStepEnd();
                this.at.compositeStepStart();
                this.markLines(new int[]{9});
            } else {
                this.markLines(new int[]{6});
                this.at.compositeStepEnd();
                this.at.compositeStepStart();
                this.markLines(new int[]{7});
                if (newValue == 0) {
                    if (this.textPos < this.dataString.length()) {
                        this.at.moveArrayMarker(this.markerStartName, this.textPos, (Timing)new WithinTiming(1000));
                    } else {
                        this.at.hide(this.markerStartName, null);
                    }
                }
            }
        }
        this.at.compositeStepEnd();
        this.xPos = newValue;
    }

    private void codeMarkingForWhile() {
        if (this.textPos < this.dataString.length()) {
            this.markLines(new int[]{1});
            if (this.xPos < this.stringToSearch.length() && this.textPos < this.dataString.length()) {
                this.markLines(new int[]{3});
                if (this.dataString.charAt(this.textPos) == this.stringToSearch.charAt(this.xPos)) {
                    this.markLines(new int[]{3, 4});
                }
            }
        }
    }

    private int returnResult(int result) {
        this.at.compositeStepStart();
        this.markLines(new int[]{1, 2});
        this.at.compositeStepEnd();
        this.at.compositeStepStart();
        this.markLines(new int[]{10});
        if (result == -1) {
            this.markLines(new int[]{10, 12});
            this.at.advancedTextLine("Ergebnis", new Off(130, 100, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Die gesuchte Zeichenfolge wurde nicht gefunden!");
        } else {
            this.markLines(new int[]{10, 11});
            this.at.advancedTextLine("Ergebnis", new Off(130, 50, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Die gesuchte Zeichenfolge wurde bei index " + result + " gefunden!");
            this.at.advancedTextLine("Ergebnis2", new Off(200, 15, "Ergebnis", "SW"), "color blue size 15", new TimeOffset(0), "(der index beginnt bei 0 und geht bis text.length() - 1)");
        }
        this.at.compositeStepEnd();
        this.at.addLabel("SearchResult");
        return result;
    }

    private void markLines(int[] linesInAlgorithm) {
        if (linesInAlgorithm == null) {
            System.out.println("useless call of markLines in BruteForceSearch - all parameters null");
        } else if (linesInAlgorithm != null) {
            this.at.compositeStepStart();
            if (this.markedLinesInAlgorithm == null) {
                this.markedLinesInAlgorithm = new int[0];
            }
            if (linesInAlgorithm != null) {
                int i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.unhighlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
                this.markedLinesInAlgorithm = linesInAlgorithm;
                i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.highlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
            }
            this.at.compositeStepEnd();
        }
    }
}

