/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import translator.Debug;
import translator.ResourceLocator;
import translator.Translator;

public class ExtendedResourceManagement {
    public static final String ASCII_FORMAT = "ascii";
    public static final String PROPERTY_FORMAT = "properties";
    private Translator translator = null;
    private TreeMap<String, String> resources = new TreeMap();

    public ExtendedResourceManagement(String filename) {
        this(filename, PROPERTY_FORMAT);
    }

    public ExtendedResourceManagement(String filename, String formatName) {
        PropertyResourceBundle bundle = null;
        try {
            bundle = this.loadBundle(filename, formatName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
        }
        this.addKeys(bundle, formatName);
    }

    private PropertyResourceBundle loadBundle(String filename, String formatName) throws FileNotFoundException {
        PropertyResourceBundle bundle = null;
        try {
            InputStream in = ResourceLocator.getResourceLocator().getResourceStream(filename);
            if (PROPERTY_FORMAT.equalsIgnoreCase(formatName)) {
                bundle = new PropertyResourceBundle(new BufferedInputStream(in));
            }
        }
        catch (IOException ioException) {
            throw new FileNotFoundException("Resource file '" + filename + "' could not be read.");
        }
        catch (IllegalArgumentException illArg) {
            System.err.println(illArg.getMessage());
        }
        return bundle;
    }

    private void addKeys(PropertyResourceBundle bundle, String formatName) {
        if (bundle == null) {
            return;
        }
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith("@import")) {
                if (this.resources.containsKey(key) && !this.resources.get(key).equals(bundle.getString(key))) {
                    System.err.println("key '" + key + "' already in list: '" + this.resources.get(key) + "', ignoring new value '" + bundle.getString(key) + "'");
                    continue;
                }
                this.resources.put(key, bundle.getString(key));
                continue;
            }
            PropertyResourceBundle newBundle = null;
            try {
                newBundle = this.loadBundle(bundle.getString(key), formatName);
            }
            catch (FileNotFoundException fnfe) {
                System.err.println(fnfe.getMessage());
            }
            this.addKeys(newBundle, formatName);
        }
    }

    protected void addPropertyResource(String filename) throws FileNotFoundException {
        PropertyResourceBundle bundle = this.loadBundle(filename, PROPERTY_FORMAT);
        this.addKeys(bundle, PROPERTY_FORMAT);
    }

    public String[] getKeys() {
        Set<String> keySet = this.resources.keySet();
        String[] stringKeys = new String[keySet.size()];
        keySet.toArray(stringKeys);
        return stringKeys;
    }

    public String getMessage(String key) {
        return this.getMessage(key, true);
    }

    public String getMessage(String key, boolean warnOnError) {
        if (this.resources == null) {
            return " ";
        }
        String message = null;
        if (this.resources != null && this.resources.containsKey(key)) {
            message = this.resources.get(key);
        }
        if (message != null) {
            return message;
        }
        if (warnOnError) {
            if (message == null && this.resources.containsKey("noSuchKeyException")) {
                Debug.printlnMessage(this.getTranslator().translateMessage("noSuchKeyException", new Object[]{key}));
            } else {
                System.err.println("Missing key: " + key);
            }
        }
        return message;
    }

    public Translator getTranslator() {
        if (this.translator == null) {
            this.translator = new Translator("en", Locale.US);
        }
        return this.translator;
    }

    public void printProperties() {
        this.printProperties(System.out);
    }

    public void printProperties(PrintStream outputStream) {
        if (this.resources == null) {
            return;
        }
        String[] keys = this.getKeys();
        String key = null;
        if (keys != null) {
            int nrKeys = keys.length;
            int i = 0;
            while (i < nrKeys) {
                key = keys[i];
                outputStream.println("key: '" + key + "' entry: '" + this.getMessage(key) + "'");
                ++i;
            }
        }
    }

    public void setTranslator(Translator trans) {
        this.translator = trans == null ? new Translator() : trans;
    }
}

