/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

public class Parallaxer {
    private int openStepCount = 0;
    private boolean headerWritten = false;
    private StringBuilder outputBuffer = null;

    public Parallaxer(StringBuilder buffer) {
        this.outputBuffer = buffer;
        this.openStepCount = 0;
    }

    public void closeStepAsNeeded() {
        if (this.openStepCount == 1) {
            this.ensureClosedStep();
        } else {
            --this.openStepCount;
        }
    }

    public void ensureHeaderWritten() {
        if (!this.headerWritten) {
            this.outputBuffer.append("%Animal 2.0\n");
        }
    }

    public void ensureOpenStep() {
        if (this.openStepCount == 0) {
            this.outputBuffer.append("{\n");
            ++this.openStepCount;
        }
    }

    public void ensureClosedStep() {
        if (this.openStepCount > 0) {
            this.outputBuffer.append("}\n");
            this.openStepCount = 0;
        }
    }

    public void startStepAsNeeded() {
        if (this.openStepCount == 0) {
            this.ensureOpenStep();
        } else {
            ++this.openStepCount;
        }
    }

    public void toggleStep() {
        this.ensureClosedStep();
        this.ensureOpenStep();
    }
}

