/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

import animal.misc.XProperties;

public class AnimatedIntArray {
    private static int arrayCode = 0;
    private int[] arrayData = null;
    private String arrayName = "array";
    private XProperties props = new XProperties();
    private int nrAssignments = 0;
    private int nrComparisons = 0;
    private StringBuilder sbuf = null;
    private String assCounterID = null;
    private String compCounterID = null;

    public AnimatedIntArray(StringBuilder outputBuffer, int[] arrayParam) {
        this(outputBuffer, "array" + arrayCode++, arrayParam);
    }

    public AnimatedIntArray(StringBuilder outputBuffer, String label, int[] arrayParam) {
        this(outputBuffer, label, arrayParam, new StringBuilder(Short.MAX_VALUE));
    }

    public AnimatedIntArray(StringBuilder outputBuffer, String label, int[] theArray, StringBuilder targetBuffer) {
        this(outputBuffer, label, theArray, targetBuffer, "black", "white", "black", "blue", "gray");
    }

    public AnimatedIntArray(StringBuilder outputBuffer, String label, int[] theArray, StringBuilder targetBuffer, String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor) {
        this(outputBuffer, label, theArray, targetBuffer, outlineColor, fillColor, elementColor, elementHighlightColor, cellHighlightColor, 20, 80);
    }

    public AnimatedIntArray(StringBuilder outputBuffer, String label, int[] theArray, StringBuilder targetBuffer, String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor, int x, int y) {
        this.sbuf = outputBuffer;
        if (this.sbuf == null) {
            this.sbuf = new StringBuilder(32768);
        }
        this.setArrayName(label);
        this.arrayData = theArray;
        this.setLocalBuffer(targetBuffer);
        this.installBasicArray(outlineColor, fillColor, elementColor, elementHighlightColor, cellHighlightColor, x, y);
    }

    public void installBasicArray() {
        this.installBasicArray("black", "white", "black", "blue", "gray");
    }

    public void installBasicArray(String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor) {
        this.installBasicArray(outlineColor, fillColor, elementColor, elementHighlightColor, cellHighlightColor, 20, 80);
    }

    public void installBasicArray(String outlineColor, String fillColor, String elementColor, String elementHighlightColor, String cellHighlightColor, int x, int y) {
        if (this.arrayData == null) {
            return;
        }
        int length = this.getLength();
        this.props.put(String.valueOf(this.getArrayName()) + ".name", this.getArrayName());
        this.props.put(String.valueOf(this.getArrayName()) + ".length", length);
        this.sbuf.append("  array \"").append(this.getArrayName()).append("\" (").append(x);
        this.sbuf.append(", ").append(y).append(") color ").append(outlineColor);
        this.sbuf.append(" fillColor ").append(fillColor).append(" elementColor ");
        this.sbuf.append(elementColor).append(" elemHighlight ").append(elementHighlightColor);
        this.sbuf.append(" cellHighlight ").append(cellHighlightColor);
        this.sbuf.append(" length ").append(length).append(" ");
        int i = 0;
        while (i < length) {
            this.sbuf.append("\"").append(this.arrayData[i]).append("\" ");
            ++i;
        }
        this.sbuf.append("\n");
    }

    public int getLength() {
        if (this.arrayData == null) {
            return 0;
        }
        return this.arrayData.length;
    }

    public int getNrAssignments() {
        return this.nrAssignments;
    }

    public int getNrComparisons() {
        return this.nrComparisons;
    }

    public void incrementAssignments() {
        this.incrementAssignments(1);
    }

    public void incrementAssignments(int howMuch) {
        this.nrAssignments += howMuch;
        if (this.assCounterID != null) {
            this.sbuf.append("  move \"").append(this.assCounterID).append("\" type \"");
            this.sbuf.append("translateNodes 1 2\" along line (0,0) (1,0) within 5 ticks\n");
        }
    }

    public void incrementComparisons() {
        this.incrementComparisons(1);
    }

    public void incrementComparisons(int howMuch) {
        this.nrComparisons += howMuch;
        if (this.compCounterID != null) {
            this.sbuf.append("  move \"").append(this.compCounterID).append("\" type \"");
            this.sbuf.append("translateNodes 1 2\" along line (0,0) (1,0) within 5 ticks\n");
        }
    }

    public void setLocalBuffer(StringBuilder targetBuffer) {
        this.sbuf = targetBuffer;
    }

    public String getArrayName() {
        if (this.arrayName == null) {
            this.arrayName = "array" + arrayCode;
            ++arrayCode;
        }
        return this.arrayName;
    }

    public void setArrayName(String name) {
        this.arrayName = name;
    }

    public StringBuilder getLocalBuffer() {
        if (this.sbuf == null) {
            this.sbuf = new StringBuilder(32768);
        }
        return this.sbuf;
    }

    public void swap(int firstIndex, int secondIndex) {
        this.swap(firstIndex, secondIndex, 10);
    }

    public void swap(int firstIndex, int secondIndex, int duration) {
        int length = this.getLength();
        if (length == 0 || firstIndex < 0 || firstIndex > length || secondIndex < 0 || secondIndex > length) {
            return;
        }
        this.sbuf.append("  arraySwap on \"").append(this.getArrayName());
        this.sbuf.append("\" position ").append(firstIndex).append(" with ");
        this.sbuf.append(secondIndex).append(" within ").append(duration).append(" ticks\n");
        int tmp = this.arrayData[secondIndex];
        this.arrayData[secondIndex] = this.arrayData[firstIndex];
        this.arrayData[firstIndex] = tmp;
        this.incrementAssignments(3);
    }

    public void installArrayIndex(int targetPosition, String label, String title) {
        this.installArrayIndex(targetPosition, label, title, "red");
    }

    public void installArrayIndex(int targetPosition, String label, String title, String color) {
        if (targetPosition < 0 || targetPosition >= this.getLength()) {
            return;
        }
        this.sbuf.append("  arrayIndex \"").append(label).append("\" on \"");
        this.sbuf.append(this.getArrayName()).append("\" atIndex ").append(targetPosition);
        if (title != null) {
            this.sbuf.append(" label \"").append(title).append("\"");
        }
        this.sbuf.append(" color ").append(color).append("\n");
        this.props.put(String.valueOf(this.getArrayName()) + ".index_" + label, targetPosition);
        this.props.put(String.valueOf(this.getArrayName()) + ".label_" + label, label);
        this.props.put(String.valueOf(this.getArrayName()) + ".label_" + title, title);
        this.incrementAssignments();
    }

    public void moveArrayIndex(String label, int targetPosition) {
        this.moveArrayIndex(label, targetPosition, 5);
    }

    public void moveArrayIndex(String label, int targetPosition, int duration) {
        if (targetPosition < 0 || targetPosition > this.getLength()) {
            return;
        }
        this.sbuf.append("  moveMarker \"").append(label);
        if (targetPosition == this.getLength()) {
            this.sbuf.append("\" to outside");
        } else {
            this.sbuf.append("\" to position ").append(targetPosition);
        }
        this.sbuf.append(" within ").append(duration).append(" ticks\n");
        this.props.put(String.valueOf(this.getArrayName()) + ".index_" + label, targetPosition);
        this.incrementAssignments();
    }

    public void putElement(int newVal, int position, int offset, int duration) {
        if (position < 0 || position >= this.getLength()) {
            return;
        }
        this.sbuf.append("  arrayPut \"").append(newVal).append("\" on \"");
        this.sbuf.append(this.getArrayName()).append("\" position ").append(position);
        if (offset > 0) {
            this.sbuf.append(" after ").append(offset).append(" ticks");
        }
        if (duration > 0) {
            this.sbuf.append(" within ").append(duration).append(" ticks");
        }
        this.sbuf.append("\n");
        this.arrayData[position] = newVal;
        this.incrementAssignments();
    }

    public void putElement(int newVal, int position) {
        this.putElement(newVal, position, 0, 0);
    }

    public int getElementAt(int index) {
        if (this.arrayData == null || index < 0 || index > this.arrayData.length) {
            return Integer.MIN_VALUE;
        }
        return this.arrayData[index];
    }

    public void printArray() {
        int length = this.getLength();
        if (length > 0) {
            StringBuilder sbuf2 = new StringBuilder(length << 3);
            sbuf2.append("array values: [");
            int i = 0;
            while (i < length - 1) {
                sbuf2.append(this.arrayData[i]).append(", ");
                ++i;
            }
            sbuf2.append(this.arrayData[length - 1]).append("]");
            System.err.println(sbuf2.toString());
            Object var2_2 = null;
        }
    }

    public void highlightArrayCell(int position) {
        this.markPosition(position, position, true, true);
    }

    public void highlightArrayCell(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, true, true);
    }

    public void unhighlightArrayCell(int position) {
        this.markPosition(position, position, true, false);
    }

    public void unhighlightArrayCell(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, true, false);
    }

    public void highlightArrayElement(int position) {
        this.markPosition(position, position, false, true);
    }

    public void highlightArrayElement(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, false, true);
    }

    public void unhighlightArrayElement(int position) {
        this.markPosition(position, position, false, false);
    }

    public void unhighlightArrayElement(int startIndex, int endIndex) {
        this.markPosition(startIndex, endIndex, false, false);
    }

    public void markPosition(int position, boolean turnOn) {
        this.markPosition(position, position, true, turnOn);
    }

    public void markPosition(int startIndex, int endIndex, boolean isCell, boolean turnOn) {
        StringBuilder sb = this.getLocalBuffer();
        sb.append("  ");
        if (!turnOn) {
            sb.append("un");
        }
        sb.append("highlightArray");
        sb.append(isCell ? "Cell" : "Elem");
        sb.append(" on \"").append(this.getArrayName()).append("\" ");
        if (endIndex > startIndex) {
            sb.append(" from ").append(startIndex).append(" to ").append(endIndex);
        } else {
            sb.append(" position ").append(startIndex);
        }
        sb.append("\n");
    }

    public void setCounterIDs(String assignmentID, String comparisonID) {
        this.assCounterID = assignmentID;
        this.compCounterID = comparisonID;
    }
}

