/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generatorImplementations.SortingAlgorithm;
import java.util.Locale;
import net.algoanim.aads.AnimatedIntArray;
import net.algoanim.aads.AnimatedIntArrayMarker;

public class QuickSort2
extends SortingAlgorithm {
    private static final String DESCRIPTION = "QuickSort w\u2030hlt ein Element aus der zu sortierenden Liste aus (Pivotelement) und zerlegt die Liste in zwei Teillisten, eine untere, die alle Elemente kleiner und eine obere, die alle Elemente gleich oder gr\u02c6\ufb02er dem Pivotelement enth\u2030lt.\nDazu wird zun\u2030chst ein Element von unten gesucht, das gr\u02c6\ufb02er als (oder gleichgro\ufb02 wie) das Pivotelement und damit f\u00b8r die untere Liste zu gro\ufb02 ist. Entsprechend wird von oben ein kleineres Element als das Pivotelement gesucht. Die beiden Elemente werden dann vertauscht und landen damit in der jeweils richtigen Liste.\nDer Vorgang wird fortgesetzt, bis sich die untere und obere Suche treffen. Damit sind die oben erw\u2030hnten Teillisten in einem einzigen Durchlauf entstanden. Suche und Vertauschung k\u02c6nnen in-place durchgef\u00b8hrt werden.\n\nDie noch unsortierten Teillisten werden \u00b8ber denselben Algorithmus in noch kleinere Teillisten zerlegt (z. B. mittels Rekursion) und, sobald nur noch Listen mit je einem Element vorhanden sind, wieder zusammengesetzt. Die Sortierung ist damit abgeschlossen.";
    private static final String SOURCE_CODE = "public void quickSort(int[] array, int l, int r)\n{\n  int i, j, pivot;\n  if (r>l)\n  {\n    pivot = array[r];\n    for (i=l; j=r-1; i<j; )\n    {\n      while (array[i] <= pivot && j>i)\n        i++;\n      while (pivot < array[j] && j>i)\n        j--;\n      if (i<j)\n        swap(array, i, j);\n      if (pivot < array[i])\n        swap(array, i, r);\n      else\n        i=r;\n      quickSort(array, l, i-1);\n      quickSort(array, i+1, r);\n    }\n  }\n}";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Quick Sort Animation\"\n");
        this.sb.append("author \"Jens Falk <Jens.Falk@epost.de>\"\n");
        this.sb.append("embed \"quickSortHeader.asu\"\n");
        this.sb.append("hideAll\n");
        this.startAnimGeneration(a);
        this.sb.append("\n");
        this.targetArray = new AnimatedIntArray(this.sb, "quickSortArray", a);
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.iMarker = new AnimatedIntArrayMarker(this.targetArray, 0, "i", this.sb, "i");
        this.jMarker = new AnimatedIntArrayMarker(this.targetArray, 0, "j", this.sb, "j");
        this.quickSort(a, 0, a.length - 1);
        this.startStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("embed \"quickSortFooter.asu\"\n");
        System.err.println("***");
        System.err.print(this.targetArray.getLocalBuffer().toString());
        System.err.println("***");
    }

    private void quickSort(int[] a, int l, int r) {
        this.codeSupport.highlightCode(0, true, false);
        this.startStep();
        this.codeSupport.highlightCode(0, false, false);
        this.codeSupport.highlightCode(2, true, false);
        this.startStep();
        this.codeSupport.highlightCode(2, false, false);
        this.codeSupport.highlightCode(3, true, false);
        this.startStep();
        this.codeSupport.highlightCode(3, false, false);
        if (r > l) {
            this.codeSupport.highlightCode(4, true, false);
            this.startStep();
            this.codeSupport.highlightCode(4, false, false);
            int pivot = a[r];
            this.targetArray.incrementAssignments();
            this.codeSupport.highlightCode(6, true, false);
            this.startStep();
            this.codeSupport.highlightCode(6, false, false);
            int i = l;
            int j = r - 1;
            while (i < j) {
                this.targetArray.moveArrayIndex("i", i);
                this.targetArray.moveArrayIndex("j", j);
                this.codeSupport.highlightCode(7, true, false);
                this.startStep();
                this.codeSupport.highlightCode(7, false, false);
                while (a[i] <= pivot && j > i) {
                    this.targetArray.incrementComparisons(2);
                    this.codeSupport.highlightCode(9, true, false);
                    this.targetArray.moveArrayIndex("i", ++i);
                }
                this.targetArray.incrementComparisons(1);
                this.codeSupport.highlightCode(9, true, false);
                this.startStep();
                this.codeSupport.highlightCode(9, false, false);
                while (pivot < a[j] && j > i) {
                    this.targetArray.incrementComparisons(2);
                    this.codeSupport.highlightCode(10, true, false);
                    this.targetArray.moveArrayIndex("j", --j);
                }
                this.targetArray.incrementComparisons();
                this.codeSupport.highlightCode(10, true, false);
                this.startStep();
                this.codeSupport.highlightCode(10, false, false);
                if (i < j) {
                    this.targetArray.incrementComparisons();
                    this.codeSupport.highlightCode(11, true, false);
                    this.startStep();
                    this.swap(a, i, j);
                    this.targetArray.swap(i, j);
                    this.codeSupport.highlightCode(11, false, false);
                } else {
                    this.targetArray.incrementComparisons();
                }
                this.codeSupport.highlightCode(11, true, false);
                this.startStep();
                this.codeSupport.highlightCode(11, false, false);
            }
            this.codeSupport.highlightCode(7, true, false);
            this.startStep();
            this.codeSupport.highlightCode(7, false, false);
            if (pivot < a[i]) {
                this.targetArray.incrementComparisons(1);
                this.codeSupport.highlightCode(13, true, false);
                this.startStep();
                this.swap(a, i, r);
                this.targetArray.swap(i, r);
                this.codeSupport.highlightCode(13, false, false);
            } else {
                i = r;
                this.targetArray.incrementAssignments();
            }
            this.targetArray.incrementComparisons();
            this.codeSupport.highlightCode(13, true, false);
            this.startStep();
            this.codeSupport.highlightCode(13, false, false);
            this.codeSupport.highlightCode(14, true, false);
            this.startStep();
            this.codeSupport.highlightCode(14, false, false);
            this.quickSort(a, l, i - 1);
            this.codeSupport.highlightCode(15, true, false);
            this.startStep();
            this.codeSupport.highlightCode(15, false, false);
            this.quickSort(a, i + 1, r);
            this.startStep();
        }
        this.codeSupport.highlightCode(4, true, false);
        this.startStep();
        this.codeSupport.highlightCode(4, false, false);
    }

    public int getNrAssigns() {
        return this.targetArray.getNrAssignments();
    }

    public int getNrComparisons() {
        return this.targetArray.getNrComparisons();
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

