/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.awt.Color;
import java.util.Locale;
import net.algoanim.aads.AnimatedIntArray;
import net.algoanim.aads.AnimatedIntArrayMarker;

public class MergeSort
extends SortingAlgorithm
implements Generator {
    private int pointerCounter = 0;
    private static final String DESCRIPTION = "Dieser Generator animiert die Sortierung mittels Mergesort.\nDie grundlegende Idee ist dabei, dass das zu sortierende (Teil-)Feld in jedem Schritt zun\u2030chst rekursiv halbiert wird, bis das Feld nur noch aus einem Element besteht. Auf dem R\u00b8ckweg der Rekursion wird dann das zerlegte Teilfeld sortiert kopiert. Dazu wird ein Hilfsfeld angelegt und die Werte der beiden (vorsortierten) Feldh\u2030lften sortiert in dieses Hilfsfeld kopiert. Aus Effizienzgr\u00b8nden werden die Werte des linken Teilfelds aufsteigend, die des rechten Teilfelds absteigend sortiert in das Hilfsfeld \u00b8bertragen.\nDas Hilfsfeld besteht also aus einer aufsteigend und einer absteigend sortierten H\u2030lfte. Nun werden von beiden Enden des Felds beginnend die Werte sortiert in das Ursprungsfeld zur\u00b8ckkopiert.\nMergesort ist sehr g\u00b8nstig und liegt in jedem Fall in O(n log n), wobei es keine Unterscheidung zwischen 'best', 'average' oder 'worst case' gibt. Allerdings ben\u02c6tigt MergeSort im Gegensatz zu den meisten anderen Verfahren zus\u2030tzlichen Speicher (f\u00b8r das Hilfsfeld).";
    private static final String HEADER_TEXT = "\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Bestimme die Mitte m des zu betrachtenden Feldes\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Wende mergesort(array, l, m) an,\" at (20,140) color black font SansSerif size 24\ntext \"f2-04\" \"3. Wende mergesort(array, m+1, r) an\" at (20,180) color black font SansSerif size 24\ntext \"f2-05\" \"4. Lege ein Hilfsfeld der Gr\u02c6\ufb02e n an i\" at (20,220) color black font SansSerif size 24\ntext \"f2-06\" \"5. Kopiere die Werte l...m in das Hilfsfeld\" at (20,260) color black font SansSerif size 24\ntext \"f2-07\" \"6. Kopiere die Werte r...m+1 in das Hilfsfeld\" at (20,300) color black font SansSerif size 24\ntext \"f2-08\" \"7. Vergleiche jeweils die linken und rechten Werte des Hilfsfeldes\" at (20,340) color black font SansSerif size 24\ntext \"f2-09\" \"und kopiere den kleineren in das Feld\" at (20,380) color black font SansSerif size 24\n";
    private static final String SOURCE_CODE = "public void mergesort(int[] array, int l, int r) {\n\n  int i, j, k, m;\n  int[] b = new int[r - l + 1];\n  if (r>l) {\n\n    m = (l+r)/2;                    // Mitte bestimmen\n    mergesort(array, l, m);\n    mergesort(array, m+1, r);           // Sortiere und Mische\n    for (i=l; i<=m && i<array.length; i++) b[i] = array[i]; // Kopiere linken Teil\n    for (j=m+1; j<=r; j++) b[r+m+1-j] = array[j];         // Kopiere rechten Teil\n    for (k=l, i=l, j=r; k<=r && k<array.length; k++)\n      array[k] = (b[i] <b[j]) ? b[i++] : b[j--]; // Zusammenfuegen\n  }\n}";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Merge Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling (roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.mergesort(this.targetArray, 0, a.length - 1);
        this.toggleStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    private AnimatedIntArray generateHelperArray(int left, int right) {
        String outlineColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "color"));
        String fillColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "fillColor"));
        String elementColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "elementColor"));
        String elemHLColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "elemHighlight"));
        String cellHLColorName = this.dumpColor((Color)this.animationProperties.get("tmpArray", "cellHighlight"));
        AnimatedIntArray helper = new AnimatedIntArray(this.sb, "tmpArray", new int[right - left + 1], this.sb, outlineColorName, fillColorName, elementColorName, elemHLColorName, cellHLColorName, 20, 200);
        return helper;
    }

    private void mergesort(AnimatedIntArray array, int l, int r) {
        this.toggleStep();
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.switchCodeLine(0, 2);
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        AnimatedIntArray b = this.generateHelperArray(l, r);
        this.toggleStep();
        this.codeSupport.unhighlightCode(3);
        ++this.nrComparisons;
        if (r > l) {
            this.codeSupport.highlightCode(4);
            int m = (l + r) / 2;
            ++this.nrAssigns;
            this.toggleStep();
            this.codeSupport.unhighlightCode(4);
            this.mergesort(array, l, m);
            this.codeSupport.switchCodeLine(5, 6);
            this.mergesort(array, m + 1, r);
            ++this.nrAssigns;
            this.toggleStep();
            this.codeSupport.switchCodeLine(6, 7);
            ++this.pointerCounter;
            AnimatedIntArrayMarker localIMarker = new AnimatedIntArrayMarker(array, l, "i" + this.pointerCounter, this.sb, "i");
            ++this.pointerCounter;
            AnimatedIntArrayMarker copyMarker = new AnimatedIntArrayMarker(b, l, "copy" + this.pointerCounter, this.sb, "copy");
            int i = l;
            while (i <= m && i < array.getLength()) {
                this.toggleStep();
                localIMarker.moveArrayIndex(i);
                copyMarker.moveArrayIndex(i);
                this.toggleStep();
                b.putElement(array.getElementAt(i), i);
                b.highlightArrayCell(i);
                array.highlightArrayCell(i);
                this.nrComparisons += 2;
                ++i;
            }
            this.nrComparisons += 2;
            ++this.nrAssigns;
            this.endStep();
            this.codeSupport.switchCodeLine(7, 8);
            ++this.pointerCounter;
            AnimatedIntArrayMarker localJMarker = new AnimatedIntArrayMarker(array, m + 1, "j" + this.pointerCounter, this.sb, "copy");
            int targetPos = -1;
            int j = m + 1;
            while (j <= r) {
                this.toggleStep();
                targetPos = r + m + 1 - j;
                localJMarker.moveArrayIndex(j);
                copyMarker.moveArrayIndex(targetPos);
                this.toggleStep();
                b.putElement(array.getElementAt(j), targetPos);
                b.highlightArrayCell(targetPos);
                array.highlightArrayCell(j);
                ++this.nrComparisons;
                ++j;
            }
            ++this.nrComparisons;
            this.nrAssigns += 3;
            this.toggleStep();
            this.codeSupport.switchCodeLine(8, 9);
            AnimatedIntArrayMarker localKMarker = null;
            int k = l;
            i = l;
            j = r;
            while (k <= r && k < array.getLength()) {
                this.codeSupport.unhighlightCode(10);
                localIMarker.moveArrayIndex(i);
                localJMarker.moveArrayIndex(j);
                if (localKMarker == null) {
                    localKMarker = new AnimatedIntArrayMarker(array, l, "k" + this.pointerCounter, this.sb, "k");
                } else {
                    localKMarker.moveArrayIndex(k);
                }
                this.toggleStep();
                this.codeSupport.switchCodeLine(9, 10);
                array.highlightArrayCell(k);
                if (b.getElementAt(i) < b.getElementAt(j)) {
                    array.putElement(b.getElementAt(i), k);
                    localIMarker.moveArrayIndex(i + 1);
                } else {
                    array.putElement(b.getElementAt(j), k);
                    localJMarker.moveArrayIndex(j - 1);
                }
                ++this.nrComparisons;
                this.nrAssigns += 2;
                ++k;
            }
            this.nrComparisons += 2;
        }
        this.toggleStep();
        this.sb.append("hide \"");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Merge Sort";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

