/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.IntMatrix;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LZ77Decoding
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 11;
    private static final String DESCRIPTION = "Die LZ77 Dekodierung ist die Umkehrung der gleichnamigen Kodierung.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 30 Buchstaben begrenzt. Es handelt sich hier um einen Dekodierungsalgorithmus. Ihre Eingabe wird zun\u2030chst durch die entsprechende Kodierung kodiert. Erst diese Daten werden dekodiert.";

    public LZ77Decoding() {
        this(new AnimalScript("LZ77 Decoding", "Florian Lindner", 800, 600));
    }

    public LZ77Decoding(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void decode(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 11)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "LZ77 Decoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 40, topic, "SW"), "Die Eingabe ist:  ", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(10, -5, step1, "SE"), input, "line1", null, tpsteps);
        step12.changeColor(null, Color.RED, null, null);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "Durch die LZ77-Kodierung erhalten wir:  ", "line1", null, tpsteps);
        String in = LZ77Decoding.LZ77compress(text);
        Text step22 = this.lang.newText(new Offset(10, -5, step2, "SE"), in, "line1", null, tpsteps);
        step22.changeColor(null, Color.RED, null, null);
        Text step3 = this.lang.newText(new Offset(0, 30, step2, "SW"), "Wir wollen die Ausgabe nun wieder dekodieren.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(10, 40, step3, "SW"), "Lese die 3-Tupel (x, y, z) der Eingabe einzeln ein. ", "line2", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "- Ist x = 0 und y = 0, so erweitere die Ausgabe um z.", "line2", null, tpsteps);
        Text step42 = this.lang.newText(new Offset(0, 20, step41, "SW"), "- Ansonsten erweitere die Ausgabe um den Substring, der sich in", "line2", null, tpsteps);
        Text step43 = this.lang.newText(new Offset(0, 20, step42, "SW"), "  der Ausgabe an Indexstelle (absteigend numeriert!) x befindet und die", "line2", null, tpsteps);
        Text step44 = this.lang.newText(new Offset(0, 20, step43, "SW"), "  L\u2030nge y hat. Konkateniere zus\u2030tzlich noch z an die Ausgabe.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text tupelLabel = this.lang.newText(new Offset(0, 60, step44, "SW"), "Tupel: ", "tupelLabel", null, tpsteps);
        Text tup = this.lang.newText(new Offset(15, -5, tupelLabel, "SE"), "(Index,length,next)", "tup", null, tpsteps);
        tupelLabel.changeColor(null, Color.BLUE, null, null);
        StringArray tupel = this.lang.newStringArray(new Offset(25, -4, tup, "NE"), new String[]{"     ", "     ", "     "}, "tupel", null, ap);
        tupel.changeColor(null, Color.BLUE, null, null);
        String result = "";
        Text ausgabeLabel = this.lang.newText(new Offset(0, 100, tupelLabel, "SW"), "Ausgabe:", "ausgabe", null, tpsteps);
        ausgabeLabel.changeColor(null, Color.RED, null, null);
        int[][] ind = new int[1][11];
        int i3 = 0;
        while (i3 < ind[0].length) {
            ind[0][i3] = i3;
            ++i3;
        }
        IntMatrix indizes = this.lang.newIntMatrix(new Offset(20, -20, ausgabeLabel, "Ne"), ind, "ind", null, mp);
        String[] l = new String[11];
        int i4 = 0;
        while (i4 < l.length) {
            l[i4] = "     ";
            ++i4;
        }
        StringArray let = this.lang.newStringArray(new Offset(-7, 7, indizes, "SW"), l, "letters", null, ap);
        int s = 1;
        while (s < in.length()) {
            int index = Integer.parseInt("" + in.charAt(s));
            int length = Integer.parseInt("" + in.charAt(s += 2));
            char next = in.charAt(s += 2);
            s += 4;
            tupel.hide();
            tupel = this.lang.newStringArray(new Offset(25, -4, tup, "NE"), new String[]{"  " + index + " ", "  " + length + " ", "  " + next + " "}, "tupel", null, ap);
            tupel.changeColor(null, Color.BLUE, null, null);
            if (index == 0 && length == 0) {
                result = String.valueOf(result) + next;
            } else {
                result = String.valueOf(result) + result.substring(result.length() - index - 1, result.length() - index - 1 + length);
                if (in.charAt(s - 3) != 'O') {
                    result = String.valueOf(result) + next;
                }
            }
            indizes.hide();
            let.hide();
            ind = new int[1][result.length()];
            int i5 = 0;
            while (i5 < ind[0].length) {
                ind[0][i5] = ind[0].length - i5 - 1;
                ++i5;
            }
            indizes = this.lang.newIntMatrix(new Offset(20, -20, ausgabeLabel, "Ne"), ind, "ind", null, mp);
            l = new String[result.length()];
            i5 = 0;
            while (i5 < result.length()) {
                l[i5] = "  " + result.charAt(i5) + "  ";
                ++i5;
            }
            let = this.lang.newStringArray(new Offset(-7, 7, indizes, "SW"), l, "letters", null, ap);
            this.lang.nextStep();
        }
        Text fazit = this.lang.newText(new Offset(0, 60, ausgabeLabel, "SW"), "Die Ausgabe entspricht genau der anf\u2030nglichen Eingabe.", "Ausgabe", null, tpsteps);
    }

    public static String LZ77compress(String[] text) {
        String window = "";
        String buffer = "";
        String result = "";
        int i = 0;
        while (i < text.length) {
            buffer = String.valueOf(buffer) + text[i];
            ++i;
        }
        while (buffer.length() != 0) {
            String tmp = "" + buffer.charAt(0);
            int cnt = 0;
            while (cnt < buffer.length() - 1 && window.contains(tmp)) {
                if (!window.contains(String.valueOf(tmp) + buffer.charAt(++cnt))) break;
                tmp = String.valueOf(tmp) + buffer.charAt(cnt);
            }
            if (!window.contains(tmp)) {
                result = String.valueOf(result) + "(0,0," + tmp + ") ";
                window = String.valueOf(window) + buffer.substring(0, 1);
                buffer = buffer.substring(1, buffer.length());
                continue;
            }
            if (cnt + 1 < buffer.length()) {
                result = String.valueOf(result) + "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + buffer.charAt(cnt) + ") ";
                window = String.valueOf(window) + buffer.substring(0, tmp.length() + 1);
                buffer = buffer.substring(tmp.length() + 1, buffer.length());
                continue;
            }
            result = String.valueOf(result) + "(" + (window.length() - window.indexOf(tmp) - 1) + "," + tmp.length() + "," + "EOF)";
            break;
        }
        return result;
    }

    public static String getDESCRIPTION() {
        return DESCRIPTION;
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "LZ77 Decoding";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.decode(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

