/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BurrowsWheelerTransform
extends CompressionAlgorithm
implements Generator {
    public static int IndexOut;
    private static final int inputLimit = 12;
    private static final String DESCRIPTION = "Die Burrows Wheeler Transformation dient der Vorbereitung eines Kompressionsverfahrens. Der Eingabetext wird bei der Transformation nicht komprimiert, da die Buchstaben und Zeichen alle erhalten bleiben. Hingegen wird die Reihenfolge so ver\u2030ndert, dass ein Ausgabestring erzeugt wird, bei dem Buchstaben h\u2030ufig aufeinanderfolgen. So dient die Transformation als eine gute Vorbereitung z.B. f\u00b8r eine Laufl\u2030ngenkodierung.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 12 Buchstaben begrenzt.";

    public BurrowsWheelerTransform() {
        this(new AnimalScript("Burrows Wheeler Transformation", "Florian Lindner", 800, 800));
    }

    public BurrowsWheelerTransform(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) {
        int i;
        StringArray strArray;
        String ein = "";
        String[] t = new String[Math.min(text.length, 12)];
        int i2 = 0;
        while (i2 < t.length) {
            t[i2] = text[i2];
            ein = String.valueOf(ein) + text[i2];
            ++i2;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Burrows Wheeler Transformation", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Coordinates(20, 100), "1) Liste alle Rotationsm\u02c6glichkeiten des Eingabe-Strings auf.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "2) Sortiere die entstandene Liste alphabetisch.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 30, step2, "SW"), "3)  Der letzte Buchstabe jedes Rotations-Strings wird dem Ergebnis hinzugef\u00b8gt.", "line3", null, tpsteps);
        this.lang.nextStep();
        step1.changeColor(null, Color.RED, null, null);
        StringArray first = strArray = this.lang.newStringArray(new Offset(0, 40, step3, "SW"), text, "stringArray", null, ap);
        Vector<String[]> rotations = new Vector<String[]>(0, 1);
        String[] tmp = text;
        int i3 = 0;
        while (i3 < text.length) {
            this.lang.nextStep();
            rotations.add(BurrowsWheelerTransform.rotateLeft(tmp));
            tmp = BurrowsWheelerTransform.rotateLeft(tmp);
            if (i3 != text.length - 1) {
                strArray = this.lang.newStringArray(new Offset(0, 10, strArray, "SW"), tmp, "stringArray", null, ap);
            }
            ++i3;
        }
        StringArray last = strArray;
        step1.changeColor(null, Color.BLACK, null, null);
        step2.changeColor(null, Color.RED, null, null);
        Vector<String[]> sorted = new Vector<String[]>(0, 1);
        Vector<StringArray> strArrays = new Vector<StringArray>();
        String[] early = (String[])rotations.elementAt(0);
        strArray = this.lang.newStringArray(new Offset(50, -36, first, "NE"), tmp, "stringArray", null, ap);
        strArray.hide();
        while (!rotations.isEmpty()) {
            i = 0;
            while (i < rotations.size()) {
                if (BurrowsWheelerTransform.isEarlier((String[])rotations.elementAt(i), early)) {
                    early = (String[])rotations.elementAt(i);
                }
                ++i;
            }
            sorted.add(early);
            strArray = this.lang.newStringArray(new Offset(0, 10, strArray, "SW"), early, "stringArray", null, ap);
            strArrays.add(strArray);
            this.lang.nextStep();
            rotations.removeElement(early);
            if (rotations.isEmpty()) continue;
            early = (String[])rotations.elementAt(0);
        }
        step2.changeColor(null, Color.BLACK, null, null);
        step3.changeColor(null, Color.RED, null, null);
        i = 0;
        while (i < strArrays.size()) {
            ((StringArray)strArrays.elementAt(i)).highlightCell(((StringArray)strArrays.elementAt(i)).getLength() - 1, null, null);
            ++i;
        }
        i = 0;
        while (i < sorted.size()) {
            boolean equal = true;
            int j = 0;
            while (j < text.length) {
                if (text[j] != ((String[])sorted.elementAt(i))[j]) {
                    equal = false;
                    break;
                }
                ++j;
            }
            if (equal) {
                IndexOut = i;
                break;
            }
            ++i;
        }
        String result = "";
        int i4 = 0;
        while (i4 < sorted.size()) {
            result = String.valueOf(result) + ((String[])sorted.elementAt(i4))[((String[])sorted.elementAt(i4)).length - 1];
            ++i4;
        }
        Text fazit1 = this.lang.newText(new Offset(0, 50, last, "SW"), "Daraus ergibt sich die Ausgabe:  ", "fazit", null, tpsteps);
        tpsteps.set("color", Color.BLUE);
        Text fazit11 = this.lang.newText(new Offset(15, 8, fazit1, "E"), result, "fazit1", null, tpsteps);
        tpsteps.set("color", Color.BLACK);
        Text fazit2 = this.lang.newText(new Offset(0, 15, fazit1, "SW"), "Durch die erfolgte Transformation folgen mehrere Buchstaben aufeinander.", "fazit2", null, tpsteps);
        Text fazit3 = this.lang.newText(new Offset(0, 15, fazit2, "SW"), "Darauf k\u02c6nnen nun andere Kompressionsverfahren, wie die Laufl\u2030ngenkodierung,", "fazit3", null, tpsteps);
        Text fazit4 = this.lang.newText(new Offset(0, 15, fazit3, "SW"), "vorgenommen werden, wodurch eine bessere Kompression erreicht wird.", "fazit4", null, tpsteps);
        Text fazit5 = this.lang.newText(new Offset(0, 15, fazit4, "SW"), "F\u00b8r eine Dekodierung wird desweiteren die Zeile der Rotationsmatrix", "fazit5", null, tpsteps);
        Text fazit6 = this.lang.newText(new Offset(0, 15, fazit5, "SW"), "ausgeben, in der sich die Eingabe befindet:", "fazit5", null, tpsteps);
        tpsteps.set("color", Color.BLUE);
        Text fazit61 = this.lang.newText(new Offset(15, 8, fazit6, "E"), "" + IndexOut, "fazit6", null, tpsteps);
        tpsteps.set("color", Color.BLACK);
    }

    public static String[] rotateLeft(String[] text) {
        String[] tmp = new String[text.length];
        int i = 0;
        while (i < text.length - 1) {
            tmp[i] = text[i + 1];
            ++i;
        }
        tmp[text.length - 1] = text[0];
        return tmp;
    }

    public static boolean isEarlier(String[] text1, String[] text2) {
        int i = 0;
        while (i < text1.length) {
            int first = new Integer(text1[i].charAt(0));
            int second = new Integer(text2[i].charAt(0));
            if (text1[i].equals(".")) {
                first = Integer.MAX_VALUE;
            }
            if (text2[i].equals(".")) {
                second = Integer.MAX_VALUE;
            }
            if (first < second) {
                return true;
            }
            if (first > second) {
                return false;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArrayIn = (String[])primitives.get("stringArray");
        this.compress(strArrayIn);
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public String getName() {
        return "Burrows Wheeler Transformation";
    }

    @Override
    public String getAlgorithmName() {
        return "Burrows-Wheeler Transformation";
    }
}

