/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.properties.TextProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticDecoding
extends CompressionAlgorithm
implements Generator {
    private static Vector<Range> ranges;
    private static Vector<Rect> rects;
    private float startSubInterval;
    private float endSubInterval;
    private static final int inputLimit = 6;
    private static final String DESCRIPTION = "Die arithmetische Dekodierung ist die Umkehrung der gleichnamigen Kodierung. Durch die arithmetische Kodierung wurde ein String in eine Gleitkommazahl komprimiert. Um nun diese Gleikommazahl wieder zu dekomprimieren werden die absoluten H\u2030ufigkeiten ben\u02c6tigt, die bei der Kodierung mit ausgeliefert werden.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 6 Buchstaben begrenzt. Es handelt sich hier um einen Dekodierungsalgorithmus. Ihre Eingabe wird zun\u2030chst durch die entsprechende Kodierung kodiert. Erst diese Daten werden dekodiert.";

    public ArithmeticDecoding() {
        this(new AnimalScript("Arithmetic Decoding", "Florian Lindner", 800, 600));
    }

    public ArithmeticDecoding(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void decode(String[] text) {
        String eingabe = "";
        String[] t = new String[Math.min(text.length, 6)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            eingabe = String.valueOf(eingabe) + text[i];
            ++i;
        }
        text = t;
        RectProperties rctpHighlight = new RectProperties();
        rctpHighlight.set("color", Color.BLACK);
        rctpHighlight.set("fillColor", Color.YELLOW);
        rctpHighlight.set("filled", Boolean.TRUE);
        rctpHighlight.set("depth", 2);
        Text topic = this.lang.newText(new Coordinates(20, 50), "Aritmetic Decoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "0) Gegeben ist eine Tabelle absoluter H\u2030ufigkeiten und eine Kodierung als Gleitkommazahl.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "1) Bilde ein Intervall I in [0,1], welches entsprechend der H\u2030ufigkeiten", "line2", null, tpsteps);
        Text step21 = this.lang.newText(new Offset(0, 20, step2, "SW"), "       proportional auf die Buchstaben aufgeteilt wird.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 30, step21, "SW"), "2) W\u2030hle das Teilintervall, in dem sich die Gleitkommzahl befindet und betrachte", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "      dieses als neues Intervall. Der Buchstabe, der zu diesem Intervall geh\u02c6rte", "line31", null, tpsteps);
        Text step32 = this.lang.newText(new Offset(0, 20, step31, "SW"), "     wird f\u00b8r die Ausgabe notiert. Das neue Intervall wird wie in 1) unterteilt.", "line31", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 30, step32, "SW"), "3) Schritt 2 wird entsprechend der Anzahl der Gesamtbuchstaben, die aus der Tabelle", "line4", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "      der H\u2030ufigkeiten ermittelt werden kann, wiederholt.", "line32", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step2.hide();
        step21.hide();
        step3.hide();
        step31.hide();
        step32.hide();
        step4.hide();
        step41.hide();
        tpwords.set("font", new Font("SansSerif", 0, 16));
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        algoinWords.setText("Eingabe:  " + input, null, null);
        algoinWords.show();
        this.lang.nextStep();
        Text expl = this.lang.newText(new Offset(0, 0, step1, "SW"), "Wir erhalten die H\u2030ufigkeiten, sowie die kodierte Zahl der Eingabe:       " + ArithmeticDecoding.encode(input), "line2", null, tpsteps);
        Text expl2 = this.lang.newText(new Offset(0, 20, expl, "SW"), "Durch die H\u2030ufigkeiten l\u2030sst sich das initiale Intervall herstellen.", "line2", null, tpsteps);
        String result = "";
        Text ausgabeLabel = this.lang.newText(new Offset(0, 30, expl2, "SW"), "Ausgabe:", "ausgabe", null, tpsteps);
        Text ausgabe = this.lang.newText(new Offset(10, -5, ausgabeLabel, "SE"), result, "ausgabe", null, tpsteps);
        ausgabe.changeColor(null, Color.BLUE, null, null);
        this.lang.nextStep();
        this.startSubInterval = 0.0f;
        this.endSubInterval = 1.0f;
        rects = new Vector();
        Rect actualRect = null;
        int i3 = 0;
        while (i3 < ranges.size()) {
            if (i3 == 0) {
                actualRect = this.printRange(ranges.elementAt(i3), expl2);
            } else {
                this.printRange(ranges.elementAt(i3), expl2);
            }
            if (i3 == ranges.size() - 1) {
                TextProperties tpend = new TextProperties();
                tpend.set("color", Color.BLACK);
                tpend.set("font", new Font("SansSerif", 0, 10));
                Text text2 = this.lang.newText(new Offset(685, 10, actualRect, "SW"), new Float(this.endSubInterval).toString(), "text", null, tpend);
            }
            ++i3;
        }
        float n = ArithmeticDecoding.encode(input);
        Vector<Range> urRanges = new Vector<Range>(0, 1);
        int i4 = 0;
        while (i4 < ranges.size()) {
            Range r = new Range(ranges.elementAt(i4).getLetter(), ranges.elementAt(i4).getStart(), ranges.elementAt(i4).getEnd());
            urRanges.add(r);
            ++i4;
        }
        i4 = 0;
        while (i4 < text.length) {
            int tmp = -1;
            int j = 0;
            while (j < ranges.size()) {
                if (n >= ranges.elementAt(j).getStart() && n < ranges.elementAt(j).getEnd()) {
                    result = String.valueOf(result) + ranges.elementAt(j).getLetter();
                    tmp = j;
                    break;
                }
                ++j;
            }
            rects.elementAt(tmp).hide();
            rects.set(tmp, this.lang.newRect(rects.elementAt(tmp).getUpperLeft(), rects.elementAt(tmp).getLowerRight(), "rect", null, rctpHighlight));
            rects = new Vector(0, 1);
            this.lang.nextStep();
            ausgabe.setText(result, null, null);
            this.lang.nextStep();
            float start = ranges.elementAt(tmp).getStart();
            float end = ranges.elementAt(tmp).getEnd();
            this.startSubInterval = start;
            this.endSubInterval = end;
            int k = 0;
            while (k < ranges.size()) {
                float urStart = ((Range)urRanges.elementAt(k)).getStart();
                float urEnd = ((Range)urRanges.elementAt(k)).getEnd();
                ranges.elementAt(k).start = start + urStart * (end - start);
                ranges.elementAt(k).end = start + urEnd * (end - start);
                ++k;
            }
            Rect tmpRect = actualRect;
            int k2 = 0;
            while (k2 < ranges.size()) {
                if (k2 == 0) {
                    actualRect = this.printRange(ranges.elementAt(k2), actualRect);
                } else {
                    this.printRange(ranges.elementAt(k2), tmpRect);
                }
                if (k2 == ranges.size() - 1) {
                    Text text3 = this.lang.newText(new Offset(685, 10, actualRect, "SW"), new Float(this.endSubInterval).toString(), "text", null, tpsteps);
                }
                ++k2;
            }
            ++i4;
        }
        tpsteps.set("font", new Font("SansSerif", 0, 16));
        Text fazit = this.lang.newText(new Offset(0, 90, rects.elementAt(0), "SW"), "Die Ausgabe entspricht genau der erwarteten Eingabe. Die kodierte Zahl stammt aus dem", "Ausgabe", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit, "SW"), "letzten aufgef\u00b8hrtem Intervall. Dabei ist es nicht wichtig, welche Zahl innerhalb dieses Intervals gew\u2030hlt", "ausgabe", null, tpsteps);
        Text fazit3 = this.lang.newText(new Offset(0, 20, fazit2, "SW"), "wurde. F\u00b8r eine gute Kompression sollten allerdings Zahlen gew\u2030hlt werden, die sich mit", "fazit", null, tpsteps);
        Text fazit4 = this.lang.newText(new Offset(0, 20, fazit3, "SW"), "m\u02c6glichst wenigen Bits kodieren lassen.", "fazit", null, tpsteps);
    }

    private static float encode(String text) {
        float[] letters = new float[256];
        int i = 0;
        while (i < text.length()) {
            int n = new Integer(text.charAt(i));
            letters[n] = letters[n] + 1.0f;
            ++i;
        }
        float[] frequency = new float[256];
        int i2 = 0;
        while (i2 < letters.length) {
            frequency[i2] = letters[i2] / (float)text.length();
            ++i2;
        }
        float big = 0.0f;
        int index = 0;
        ranges = new Vector(0, 1);
        int i3 = 0;
        while (i3 < text.length()) {
            int j = 0;
            while (j < frequency.length) {
                if (frequency[j] > big) {
                    big = frequency[j];
                    index = j;
                }
                ++j;
            }
            if (!ranges.isEmpty() && big > 0.0f) {
                ranges.add(new Range((char)index, ranges.lastElement().getEnd(), ranges.lastElement().getEnd() + big));
            } else if (big > 0.0f) {
                ranges.add(new Range((char)index, 0.0f, big));
            }
            frequency[index] = -1.0f;
            big = 0.0f;
            index = 0;
            ++i3;
        }
        float start = 0.0f;
        float end = 1.0f;
        int i4 = 0;
        while (i4 < text.length()) {
            char tmp = text.charAt(i4);
            int j = 0;
            while (j < ranges.size()) {
                if (tmp == ranges.elementAt(j).getLetter()) {
                    float foo = start + (end - start) * ranges.elementAt(j).getStart();
                    end = foo + (end - start) * (ranges.elementAt(j).getEnd() - ranges.elementAt(j).getStart());
                    start = foo;
                }
                ++j;
            }
            ++i4;
        }
        return start;
    }

    private Rect printRange(Range r, Primitive prim) {
        int s = new Float((r.getStart() - this.startSubInterval) * 700.0f / (this.endSubInterval - this.startSubInterval)).intValue();
        int e = new Float((r.getEnd() - this.startSubInterval) * 700.0f / (this.endSubInterval - this.startSubInterval)).intValue();
        RectProperties recIntervalProp = new RectProperties();
        recIntervalProp.set("color", Color.BLACK);
        Rect rect = this.lang.newRect(new Offset(s, 40, prim, "SW"), new Offset(e, 65, prim, "SW"), "rectangle", null, recIntervalProp);
        rects.add(rect);
        Text t = this.lang.newText(new Offset((e - s) / 2, 20, rect, "M"), "" + r.letter, "text", null, tpsteps);
        tpsteps.set("font", new Font("SansSerif", 0, 10));
        Text startNode = this.lang.newText(new Offset(2, 9, rect, "SW"), new Float(r.getStart()).toString(), "startValue", null, tpsteps);
        return rect;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.decode(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public String getName() {
        return "Arithmetic Decoding";
    }

    @Override
    public String getAlgorithmName() {
        return "Arithmetic Decoding";
    }

    public static class Range {
        private char letter;
        private float start;
        private float end;

        public Range(char letterIn, float startIn, float endIn) {
            this.letter = letterIn;
            this.start = startIn;
            this.end = endIn;
        }

        public float getEnd() {
            return this.end;
        }

        public char getLetter() {
            return this.letter;
        }

        public float getStart() {
            return this.start;
        }
    }
}

