/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.Generator;
import generator.PropertiesPanel;
import generator.PropertiesPanelListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GeneratorPropertiesEditor
implements PropertiesPanelListener {
    private Generator currentGenerator = null;
    protected PropertiesPanel propPanel;

    public GeneratorPropertiesEditor(Generator targetGenerator) {
        this.setGenerator(targetGenerator);
        this.propPanel = new PropertiesPanel();
        this.propPanel.setListener(this);
    }

    public void setGenerator(Generator targetGenerator) {
        this.currentGenerator = targetGenerator;
    }

    protected void fillPropertiesForGenerator() {
        if (this.currentGenerator == null) {
            return;
        }
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.currentGenerator.getClass().getPackage().getName());
        buf.append("/");
        buf.append(this.currentGenerator.getClass().getSimpleName());
        buf.append(".ptm");
        try {
            this.propPanel.loadURI(buf.toString());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    protected PropertiesPanel getPropertiesPanel() {
        return this.propPanel;
    }

    public void callMethod(String methodName) {
        this.callMethodByName(methodName);
    }

    private void callMethodByName(String name) {
        if (this.currentGenerator == null) {
            return;
        }
        Class<?> c = this.currentGenerator.getClass();
        Class[] parameterTypes = new Class[]{};
        Object[] arguments = new Object[]{};
        try {
            Method theMethod = c.getMethod(name, parameterTypes);
            theMethod.invoke((Object)this.currentGenerator, arguments);
        }
        catch (NoSuchMethodException e) {
            System.err.println("No such method: '" + name + "'");
        }
        catch (IllegalAccessException e) {
            System.err.println("IllegalAccessException for method '" + name + "'");
        }
        catch (InvocationTargetException e) {
            System.err.println("InvocationTargetEception for method '" + name + "'");
        }
    }
}

