/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Color;
import de.ahrgr.animal.kohnert.asugen.Node;
import de.ahrgr.animal.kohnert.asugen.OffsetNode;
import de.ahrgr.animal.kohnert.asugen.TimeOffset;
import java.io.PrintWriter;

public abstract class AnimalObject {
    public static final int NW = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int W = 3;
    public static final int C = 4;
    public static final int E = 5;
    public static final int SW = 6;
    public static final int S = 7;
    public static final int SE = 8;
    protected static int instance_count = 0;
    protected PrintWriter out;
    protected AnimalScriptWriter scriptwriter;
    protected boolean registered = false;
    protected String name = null;
    protected int instance_index = 0;
    protected Node position;
    protected int depth;
    protected boolean hidden = false;
    protected TimeOffset timeOffset;
    protected Color color = null;
    protected Color fillColor = null;

    public AnimalObject(AnimalScriptWriter sw) {
        this.scriptwriter = sw;
        this.out = sw.getOut();
        this.name = "obj" + ++instance_count;
        this.instance_index = instance_count;
        this.depth = sw.default_depth;
        this.timeOffset = new TimeOffset(sw, 0);
    }

    public void setName(String pname) {
        if (!this.registered) {
            this.name = pname;
        }
    }

    public void setDepth(int aDepth) {
        if (!this.registered) {
            this.depth = aDepth;
        }
    }

    public String getName() {
        return this.name;
    }

    public Node getPosition() {
        return this.position;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void register() {
        if (!this.registered) {
            this.scriptwriter.registeredObjects.add(this);
        }
    }

    public void moveTo(Node dst) {
        if (!this.registered) {
            this.register();
        }
        this.out.print("move \"");
        this.out.print(this.name);
        this.out.print("\" to ");
        dst.print();
        this.out.print(" within 400 ms");
        this.out.println();
        this.position = dst;
    }

    public Node createOffset(int dx, int dy, int direction) {
        return new OffsetNode(this.scriptwriter, this, dx, dy, direction);
    }

    public void setTimeOffset(int value) {
        if (this.registered) {
            return;
        }
        this.timeOffset = new TimeOffset(this.scriptwriter, value);
    }

    public void setColor(Color c) {
        this.color = c;
        if (!this.registered) {
            return;
        }
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
        if (!this.registered) {
            return;
        }
        this.out.print("color \"");
        this.out.print(this.name);
        this.out.print("\" type \"fillColor\" ");
        this.out.println(c.getColorString());
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getColor() {
        return this.color;
    }

    public void setHidden(boolean isHidden) {
        if (!this.registered) {
            this.hidden = isHidden;
        } else {
            if (isHidden) {
                this.out.print("hide \"");
            } else {
                this.out.print("show \"");
            }
            this.out.print(this.name);
            this.out.println("\"");
        }
    }

    public void setPosition(Node node) {
        this.position = node;
        if (!this.registered) {
            return;
        }
        this.out.print("move \"");
        this.out.print(this.name);
        this.out.print("\" to ");
        this.position.print();
        this.out.println();
    }

    protected void printID() {
        this.out.print(" \"");
        this.out.print(this.name);
        this.out.print("\"");
    }

    protected void printQuoted(String s) {
        this.out.print(" \"");
        this.out.print(s);
        this.out.print("\"");
    }

    protected void printDisplayOptions() {
        if (this.hidden) {
            this.out.print(" hidden ");
        }
    }

    protected void printColor() {
        if (this.color == null) {
            return;
        }
        this.out.print(" color ");
        this.out.print(this.color.getColorString());
    }

    protected void printFillColor() {
        if (this.fillColor == null) {
            return;
        }
        this.out.print(" filled fillColor ");
        this.out.print(this.fillColor.getColorString());
    }

    protected void printDepth() {
        if (this.depth == 0) {
            return;
        }
        this.out.print(" depth ");
        this.out.print(this.depth);
    }
}

