/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ColorChooserComboBox
extends JComboBox
implements ActionListener {
    private static final long serialVersionUID = -984850815478582378L;
    private static final String[] strAnimalNames = new String[]{"black", "dark Gray", "gray", "light Gray", "white", "red", "pink", "orange", "yellow", "green", "cyan", "blue", "magenta", "blue4", "blue3", "blue2", "light_blue", "green4", "green3", "green2", "cyan4", "cyan3", "cyan2", "red4", "red3", "red2", "magenta4", "magenta3", "magenta2", "brown4", "brown3", "brown2", "pink4", "pink3", "pink2", "gold"};
    private static final String[] strTranslatorKeys = new String[]{"black", "darkGray", "gray", "lightGray", "white", "red", "pink", "orange", "yellow", "green", "cyan", "blue", "magenta", "blue4", "blue3", "blue2", "light_blue", "green4", "green3", "green2", "cyan4", "cyan3", "cyan2", "red4", "red3", "red2", "magenta4", "magenta3", "magenta2", "brown4", "brown3", "brown2", "pink4", "pink3", "pink2", "gold", "moreColors", "customColor", "colorChooserTitle"};
    static final Color[] colorValues = new Color[]{Color.black, Color.darkGray, Color.gray, Color.lightGray, Color.white, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.cyan, Color.blue, Color.magenta, new Color(0, 0, 144), new Color(0, 0, 176), new Color(0, 0, 208), new Color(135, 206, 255), new Color(0, 144, 0), new Color(0, 176, 0), new Color(0, 208, 0), new Color(0, 144, 144), new Color(0, 176, 176), new Color(0, 208, 208), new Color(144, 0, 0), new Color(176, 0, 0), new Color(208, 0, 0), new Color(144, 0, 144), new Color(176, 0, 176), new Color(208, 0, 208), new Color(128, 48, 0), new Color(160, 64, 0), new Color(192, 96, 0), new Color(255, 128, 128), new Color(255, 160, 160), new Color(255, 224, 224), new Color(255, 215, 0)};
    static String[] strLocalStrings = new String[]{"Black", "Dark Gray", "Gray", "Light Gray", "White", "Red", "Pink", "Orange", "Yellow", "Green", "Cyan", "Blue", "Magenta", "Blue 4", "Blue 3", "Blue 2", "Light Blue", "Green 4", "Green 3", "Green 2", "Cyan 4", "Cyan 3", "Cyan 2", "Red 4", "Red 3", "Red 2", "Magenta 4", "Magenta 3", "Magenta 2", "Brown 4", "Brown 3", "Brown 2", "Pink 4", "Pink 3", "Pink 2", "Gold", "More Colors...", "Custom Color", "Please choose a Color"};
    private Color colorSelected = Color.BLACK;
    private ComboBoxRenderer renderer = new ComboBoxRenderer();
    private String strSelected = "black";
    private Object[][] values = new Object[strAnimalNames.length + 1][2];
    private boolean bChangeByComponent = false;

    public ColorChooserComboBox() {
        this.init();
    }

    public ColorChooserComboBox(Color colorNew) {
        this.init();
        this.setColorSelected(colorNew);
    }

    public ColorChooserComboBox(String strNewColor) {
        this.init();
        this.setColorSelected(strNewColor);
    }

    public void setColorSelected(Color colorNew) {
        if (colorNew == null) {
            return;
        }
        this.colorSelected = colorNew;
        int i = 0;
        while (i < colorValues.length) {
            if (colorValues[i].equals(colorNew)) {
                this.strSelected = strAnimalNames[i];
                this.bChangeByComponent = true;
                this.setSelectedIndex(i);
                this.bChangeByComponent = false;
                this.repaint();
                return;
            }
            ++i;
        }
        this.strSelected = ColorChooserComboBox.getStringForColorRGB(colorNew);
        int iLastIndex = colorValues.length;
        if (!(this.getItemAt(iLastIndex) instanceof Object[])) {
            return;
        }
        Object[] lastitem = (Object[])this.getItemAt(iLastIndex);
        if (!(lastitem[0] instanceof ColoredSquare)) {
            return;
        }
        ColoredSquare csq = (ColoredSquare)lastitem[0];
        csq.changeColor(colorNew);
        this.bChangeByComponent = true;
        this.setSelectedIndex(iLastIndex);
        this.bChangeByComponent = false;
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    public void setColorSelected(String strNewColor) {
        block4: {
            try {
                colorNew = ColorChooserComboBox.getColorForString(strNewColor);
                this.setColorSelected(colorNew);
                break block4;
            }
            catch (IllegalArgumentException e) {
                i = 0;
                ** while (i < ColorChooserComboBox.colorValues.length)
            }
lbl-1000:
            // 1 sources

            {
                if (ColorChooserComboBox.strAnimalNames[i].equals(strNewColor)) {
                    this.strSelected = strNewColor;
                    this.colorSelected = ColorChooserComboBox.colorValues[i];
                    this.bChangeByComponent = true;
                    this.setSelectedIndex(i);
                    this.bChangeByComponent = false;
                    this.repaint();
                    return;
                }
                ++i;
                continue;
            }
        }
    }

    public Color getColorSelected() {
        return this.colorSelected;
    }

    public String getColorSelectedAsString() {
        return this.strSelected;
    }

    public void setLocalStrings(String[] newLocalStrings) {
        if (newLocalStrings == null || newLocalStrings.length != strTranslatorKeys.length) {
            return;
        }
        boolean bDifferent = false;
        int i = 0;
        while (i < newLocalStrings.length) {
            if (!strLocalStrings[i].equals(newLocalStrings[i])) {
                bDifferent = true;
                break;
            }
            ++i;
        }
        if (!bDifferent) {
            return;
        }
        i = 0;
        while (i < newLocalStrings.length) {
            ColorChooserComboBox.strLocalStrings[i] = newLocalStrings[i];
            ++i;
        }
        Color selected = this.getColorSelected();
        this.init();
        this.bChangeByComponent = true;
        this.setColorSelected(selected);
        this.bChangeByComponent = false;
    }

    public static String getStringForColor(Color colorObject) {
        int i = 0;
        while (i < colorValues.length) {
            if (colorValues[i].equals(colorObject)) {
                return strAnimalNames[i];
            }
            ++i;
        }
        return ColorChooserComboBox.getStringForColorRGB(colorObject);
    }

    public String[] getTranslatorKeys() {
        String[] retval = new String[strTranslatorKeys.length];
        int i = 0;
        while (i < retval.length) {
            retval[i] = strTranslatorKeys[i];
            ++i;
        }
        return retval;
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (this.bChangeByComponent) {
            return;
        }
        int index = this.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (index < colorValues.length) {
            this.colorSelected = colorValues[index];
            this.strSelected = strAnimalNames[index];
        } else {
            Color colorNew = JColorChooser.showDialog(this, strLocalStrings[colorValues.length + 2], this.colorSelected);
            if (colorNew == null) {
                return;
            }
            this.setColorSelected(colorNew);
        }
    }

    public static String getStringForColorRGB(Color colorObject) {
        StringBuilder buf = new StringBuilder(15);
        buf.append("(");
        buf.append(Integer.toString(colorObject.getRed()));
        buf.append(", ");
        buf.append(Integer.toString(colorObject.getGreen()));
        buf.append(", ");
        buf.append(Integer.toString(colorObject.getBlue()));
        buf.append(")");
        return buf.toString();
    }

    public static Color getColorForString(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("getColorForString: String cannot be null!");
        }
        if ((str = str.trim()).length() == 0) {
            throw new IllegalArgumentException("getColorForString: String cannot be empty!");
        }
        if (str.matches("\\x28((\\d{1,3})(,\\s)){2}(\\d{1,3})\\x29")) {
            int r = 1000;
            int g = 1000;
            int b = 1000;
            int fc = str.indexOf(", ");
            int sc = str.indexOf(", ", fc + 2);
            if (fc < 1 || sc < 1) {
                throw new IllegalArgumentException("getColorForString: invalid given String!");
            }
            try {
                r = Integer.parseInt(str.substring(1, fc));
                g = Integer.parseInt(str.substring(fc + 2, sc));
                b = Integer.parseInt(str.substring(sc + 2, str.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("getColorForString: invalid given String!");
            }
            if (r > 255 || g > 255 || b > 255) {
                throw new IllegalArgumentException("getColorForString: Color-Value greater than 255!");
            }
            return new Color(r, g, b);
        }
        throw new IllegalArgumentException("getColorForString: String has to be in the form '(r,g,b)'!");
    }

    private void init() {
        int i = 0;
        this.bChangeByComponent = true;
        this.removeAllItems();
        while (i < colorValues.length) {
            this.values[i][0] = new ColoredSquare(colorValues[i]);
            this.values[i][1] = strLocalStrings[i];
            this.addItem(this.values[i]);
            ++i;
        }
        this.values[i][0] = new ColoredSquare();
        this.values[i][1] = strLocalStrings[colorValues.length];
        this.addItem(this.values[i]);
        this.setRenderer(this.renderer);
        this.removeActionListener(this);
        this.addActionListener(this);
        this.colorSelected = colorValues[0];
        this.bChangeByComponent = false;
    }

    private static class ColoredSquare
    implements Icon {
        private Color color;
        private boolean special = false;

        public ColoredSquare(Color c) {
            if (c == null) {
                return;
            }
            this.color = c;
            this.special = false;
        }

        public ColoredSquare() {
            this.color = Color.WHITE;
            this.special = true;
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconHeight() {
            return 12;
        }

        public int getIconWidth() {
            return 14;
        }

        public void changeColor(Color c) {
            if (c == null) {
                return;
            }
            this.color = c;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c == null || g == null) {
                return;
            }
            Color oldColor = g.getColor();
            if (!this.special) {
                g.setColor(this.color);
                g.fill3DRect(x + 2, y, this.getIconWidth() - 2, this.getIconHeight(), true);
            } else {
                g.setColor(Color.WHITE);
                g.fill3DRect(x + 2, y, this.getIconWidth() - 2, this.getIconHeight(), true);
                g.setColor(Color.GRAY);
                g.drawRect(4, 9, 1, 1);
                g.drawRect(7, 9, 1, 1);
                g.drawRect(10, 9, 1, 1);
            }
            g.setColor(oldColor);
        }
    }

    private static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -3699370669894412136L;

        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null || value == null) {
                this.setText("?");
                this.setIcon(new ColoredSquare(Color.BLACK));
                return this;
            }
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!(value instanceof Object[])) {
                return this;
            }
            Object[] itemValues = (Object[])value;
            if (!(itemValues[1] instanceof String)) {
                return this;
            }
            this.setText((String)itemValues[1]);
            if (index >= 0 || !this.getText().equals(strLocalStrings[colorValues.length])) {
                this.setIcon((Icon)itemValues[0]);
            } else {
                if (!(itemValues[0] instanceof ColoredSquare)) {
                    return this;
                }
                ColoredSquare csq = (ColoredSquare)itemValues[0];
                this.setIcon(new ColoredSquare(csq.getColor()));
                this.setText(String.valueOf(strLocalStrings[colorValues.length + 1]) + " " + ColorChooserComboBox.getStringForColorRGB(csq.getColor()));
            }
            return this;
        }
    }
}

