/*
 * Decompiled with CFR 0.152.
 */
package avinteraction.parser;

import avinteraction.FIBQuestion;
import avinteraction.GroupInfo;
import avinteraction.HTMLDocumentation;
import avinteraction.InteractionModule;
import avinteraction.MCQuestion;
import avinteraction.TFQuestion;
import avinteraction.parser.BadSyntaxException;
import avinteraction.parser.LanguageParserInterface;
import avinteraction.parser.Parser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalscriptParser
implements LanguageParserInterface {
    private final String LANGUAGE = "AnimalScript";
    private Hashtable<String, GroupInfo> groupInfo = new Hashtable();
    private Hashtable<String, Object> interactionObjects = new Hashtable();
    private Parser parser;
    private StreamTokenizer stok;
    private boolean DEBUG;
    private int curLine = 1;

    public AnimalscriptParser() {
        this(false);
    }

    public AnimalscriptParser(boolean tf) {
        this.DEBUG = tf;
    }

    @Override
    public void setDebug(boolean tf) {
        this.DEBUG = tf;
    }

    @Override
    public Hashtable<String, GroupInfo> getGroupInfo() {
        return this.groupInfo;
    }

    @Override
    public Hashtable<String, Object> parse(String filename) {
        if (this.DEBUG) {
            System.out.println(InteractionModule.translateMessage("parsing", new String[]{filename}));
        }
        try {
            BufferedReader theReader;
            if (filename.startsWith("http://") || filename.startsWith("ftp://") || filename.startsWith("file://")) {
                URL theURL = new URL(filename);
                theReader = new BufferedReader(new InputStreamReader(theURL.openStream()));
            } else {
                theReader = new BufferedReader(new FileReader(filename));
            }
            this.stok = new StreamTokenizer(theReader);
            this.parser = new Parser(this.stok, filename);
            this.parser.setIgnoreCase(true);
            while (this.stok.ttype != -1) {
                while (this.getOptionalEOL()) {
                }
                this.stok.pushBack();
                String word = this.parser.getWord();
                if ("documentation".equalsIgnoreCase(word)) {
                    this.parseDocumentation();
                    continue;
                }
                if ("fibQuestion".equalsIgnoreCase(word)) {
                    this.parseFIBQuestion();
                    continue;
                }
                if ("mcQuestion".equalsIgnoreCase(word)) {
                    this.parseMCQuestion();
                    continue;
                }
                if ("tfQuestion".equalsIgnoreCase(word)) {
                    this.parseTFQuestion();
                    continue;
                }
                throw this.parser.generateException("keywordExpected", word);
            }
        }
        catch (BadSyntaxException bse) {
            System.out.println(InteractionModule.translateMessage("syntaxError", new String[]{bse.getMessage(), filename, String.valueOf(this.stok.lineno())}));
        }
        catch (IOException ioe) {
            System.out.println(InteractionModule.translateMessage("genericException", new String[]{this.getClass().getName(), ioe.getMessage(), filename, String.valueOf(this.stok.lineno())}));
        }
        return this.interactionObjects;
    }

    @Override
    public String toString() {
        return "AnimalScript";
    }

    private boolean getEOL() throws IOException, BadSyntaxException {
        this.parser.getOptionalWhitespace();
        if (this.parser.getEOL()) {
            ++this.curLine;
            this.parser.getOptionalWhitespace();
            return true;
        }
        return false;
    }

    private boolean getEOX() throws IOException, BadSyntaxException {
        this.parser.getOptionalWhitespace();
        if (this.parser.getEOX()) {
            ++this.curLine;
            this.parser.getOptionalWhitespace();
            return true;
        }
        return false;
    }

    private boolean getOptionalEOL() throws IOException {
        this.parser.getOptionalWhitespace();
        if (this.parser.getOptionalEOL()) {
            ++this.curLine;
            this.parser.getOptionalWhitespace();
            return true;
        }
        return false;
    }

    private void parseDocumentation() throws IOException, BadSyntaxException {
        this.parser.getWhitespace();
        String id = this.parser.getQuoted();
        this.getEOL();
        String url = this.parser.getQuoted();
        this.getEOL();
        this.parser.getKeyword("endtext");
        this.getEOX();
        HTMLDocumentation doc = new HTMLDocumentation(id);
        doc.setURL(url);
        this.interactionObjects.put(id, doc);
    }

    private void parseFIBQuestion() throws IOException, BadSyntaxException {
        StringBuilder commentBuffer = new StringBuilder(256);
        StringBuilder questionTextBuffer = new StringBuilder(256);
        int points = 0;
        int repeat = 0;
        this.parser.getWhitespace();
        String id = this.parser.getQuoted();
        this.getEOL();
        String groupID = "";
        points = 0;
        repeat = 0;
        String tmp = this.parser.getOptionalWord();
        while (!"".equals(tmp)) {
            if ("questiongroup".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                groupID = this.parser.getQuoted();
                if (this.groupInfo.get(groupID) == null) {
                    this.groupInfo.put(groupID, new GroupInfo(repeat, 0));
                }
            } else if ("nrRepeats".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                repeat = this.parser.getNumber();
                if (this.groupInfo.get(groupID) != null && this.groupInfo.get((Object)groupID).repeats == 0) {
                    this.groupInfo.put(groupID, new GroupInfo(repeat, 0));
                }
            } else if ("points".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                points = this.parser.getNumber();
            } else {
                throw this.parser.generateException("optionalComponentExpected", tmp);
            }
            this.getEOL();
            tmp = this.parser.getOptionalWord();
        }
        tmp = this.parser.getOptionalQuoted();
        while (!"".equals(tmp)) {
            questionTextBuffer.append(tmp);
            this.getEOL();
            tmp = this.parser.getOptionalQuoted();
        }
        this.parser.getKeyword("endtext");
        this.getEOL();
        FIBQuestion question = new FIBQuestion(id, groupID);
        question.setQuestion(questionTextBuffer.toString());
        this.parser.getKeyword("answer");
        this.getEOL();
        while (!this.parser.getOptionalKeyword("endanswer")) {
            String answer = this.parser.getQuoted();
            this.getEOL();
            question.addAnswer(answer);
        }
        this.getEOX();
        if (this.parser.getOptionalKeyword("comment")) {
            this.getEOL();
            while (!this.parser.getOptionalKeyword("endcomment")) {
                commentBuffer.append(this.parser.getQuoted());
                this.getEOL();
            }
            this.getEOX();
        }
        question.setPoints(points);
        question.setComment(commentBuffer.toString());
        this.interactionObjects.put(id, question);
    }

    private void parseMCQuestion() throws IOException, BadSyntaxException {
        StringBuilder questionTextBuffer = new StringBuilder(256);
        int nrCorrectAnswers = 0;
        this.parser.getWhitespace();
        String id = this.parser.getQuoted();
        this.getEOL();
        String groupID = "";
        int points = 0;
        int repeat = 0;
        String tmp = this.parser.getOptionalWord();
        while (!"".equals(tmp)) {
            if ("questiongroup".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                groupID = this.parser.getQuoted();
                if (this.groupInfo.get(groupID) == null) {
                    this.groupInfo.put(groupID, new GroupInfo(repeat, 0));
                }
            } else if ("nrRepeats".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                repeat = this.parser.getNumber();
                if (this.groupInfo.get(groupID) != null && this.groupInfo.get((Object)groupID).repeats == 0) {
                    this.groupInfo.put(groupID, new GroupInfo(repeat, 0));
                }
            } else if ("points".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                points = this.parser.getNumber();
            } else {
                throw this.parser.generateException("optionalComponentExpected", tmp);
            }
            this.getEOL();
            tmp = this.parser.getOptionalWord();
        }
        tmp = this.parser.getOptionalQuoted();
        while (!"".equals(tmp)) {
            questionTextBuffer.append(tmp);
            this.getEOL();
            tmp = this.parser.getOptionalQuoted();
        }
        this.parser.getKeyword("endtext");
        this.getEOL();
        MCQuestion question = new MCQuestion(id, groupID);
        question.setQuestion(questionTextBuffer.toString());
        while (!this.parser.getOptionalKeyword("answer")) {
            String answer = this.parser.getQuoted();
            this.getEOL();
            this.parser.getKeyword("endchoice");
            this.getEOL();
            StringBuilder commentBuffer = new StringBuilder(256);
            int subpoints = 0;
            if (this.parser.getOptionalKeyword("points")) {
                this.parser.getWhitespace();
                subpoints = this.parser.getNumber();
                this.getEOL();
            }
            if (this.parser.getOptionalKeyword("comment")) {
                this.getEOL();
                while (!this.parser.getOptionalKeyword("endcomment")) {
                    commentBuffer.append(this.parser.getQuoted());
                    this.getEOL();
                }
                this.getEOL();
            }
            question.addPossibleAnswer(answer, subpoints, commentBuffer.toString());
        }
        this.getEOL();
        while (!this.parser.getOptionalKeyword("endanswer")) {
            int correctAnswer = this.parser.getNumber();
            this.getEOL();
            question.addCorrectAnswer(correctAnswer);
            ++nrCorrectAnswers;
        }
        this.getEOX();
        question.randomize();
        question.setPoints(points);
        question.useCheckBoxes(nrCorrectAnswers > 1);
        this.interactionObjects.put(id, question);
    }

    private void parseTFQuestion() throws IOException, BadSyntaxException {
        boolean correct;
        StringBuilder commentBuffer = new StringBuilder(256);
        StringBuilder questionTextBuffer = new StringBuilder(256);
        this.parser.getWhitespace();
        String id = this.parser.getQuoted();
        this.getEOL();
        String groupID = "";
        int points = 0;
        int repeat = 0;
        String tmp = this.parser.getOptionalWord();
        while (!"".equals(tmp)) {
            if ("questiongroup".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                groupID = this.parser.getQuoted();
                if (this.groupInfo.get(groupID) == null) {
                    this.groupInfo.put(groupID, new GroupInfo(repeat, 0));
                }
            } else if ("nrRepeats".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                repeat = this.parser.getNumber();
                if (this.groupInfo.get(groupID) != null && this.groupInfo.get((Object)groupID).repeats == 0) {
                    this.groupInfo.put(groupID, new GroupInfo(repeat, 0));
                }
            } else if ("points".equalsIgnoreCase(tmp)) {
                this.parser.getWhitespace();
                points = this.parser.getNumber();
            } else {
                throw this.parser.generateException("optionalComponentExpected", tmp);
            }
            this.getEOL();
            tmp = this.parser.getOptionalWord();
        }
        tmp = this.parser.getOptionalQuoted();
        while (!"".equals(tmp)) {
            questionTextBuffer.append(tmp);
            this.getEOL();
            tmp = this.parser.getOptionalQuoted();
        }
        this.parser.getKeyword("endtext");
        this.getEOL();
        this.parser.getKeyword("answer");
        this.getOptionalEOL();
        String tf = this.parser.getWord();
        if ("t".equalsIgnoreCase(tf)) {
            correct = true;
        } else if ("f".equalsIgnoreCase(tf)) {
            correct = false;
        } else {
            throw this.parser.generateException("tfExpected", tf);
        }
        this.getEOL();
        this.parser.getKeyword("endanswer");
        this.getEOX();
        if (this.parser.getOptionalKeyword("comment")) {
            this.getEOL();
            while (!this.parser.getOptionalKeyword("endcomment")) {
                commentBuffer.append(this.parser.getQuoted());
                this.getEOL();
            }
            this.getEOX();
        }
        TFQuestion question = new TFQuestion(id, groupID);
        question.setQuestion(questionTextBuffer.toString());
        question.setAnswer(correct);
        question.setPoints(points);
        question.setComment(commentBuffer.toString());
        this.interactionObjects.put(id, question);
    }
}

